/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.ui.wizards;

import java.awt.Component;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.modules.junit.api.JUnitSettings;
import org.netbeans.modules.junit.api.JUnitTestUtil;
import org.netbeans.modules.junit.api.JUnitUtils;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.modules.junit.ui.wizards.EmptyTestCaseWizardIterator;
import org.netbeans.modules.junit.ui.wizards.SimpleTestStepLocation;
import org.netbeans.modules.junit.ui.wizards.StepProblemMessage;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class SimpleTestCaseWizardIterator
implements WizardDescriptor.InstantiatingIterator<WizardDescriptor> {
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wizard;
    private Project lastSelectedProject = null;
    private WizardDescriptor.Panel<WizardDescriptor> classChooserPanel;

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    public void initialize(WizardDescriptor wizard) {
        WizardDescriptor.Panel<WizardDescriptor> chooserPanel;
        this.wizard = wizard;
        this.index = 0;
        this.panels = this.createPanels(wizard);
        FileObject targetFolder = Templates.getTargetFolder((WizardDescriptor)wizard);
        this.loadSettings(wizard);
        String[] beforeSteps = null;
        Object prop = wizard.getProperty("WizardPanel_contentData");
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        if (targetFolder == null) {
            targetFolder = Templates.getTargetFolder((WizardDescriptor)wizard);
        }
        if ((chooserPanel = this.getClassChooserPanel()) instanceof SimpleTestStepLocation && targetFolder != null) {
            ((SimpleTestStepLocation)chooserPanel).selectLocation(targetFolder);
        }
    }

    public void uninitialize(WizardDescriptor wizard) {
        if (this.classChooserPanel != null && !(this.classChooserPanel instanceof StepProblemMessage)) {
            assert (this.classChooserPanel instanceof SimpleTestStepLocation);
            ((SimpleTestStepLocation)this.classChooserPanel).cleanUp();
        }
        this.classChooserPanel = null;
        this.wizard = null;
    }

    public Set<DataObject> instantiate() throws IOException {
        this.saveSettings(this.wizard);
        FileObject classToTest = (FileObject)this.wizard.getProperty("classToTest");
        FileObject testRootFolder = (FileObject)this.wizard.getProperty("testRootFolder");
        Map params = JUnitTestUtil.getSettingsMap((boolean)false);
        JUnitPlugin plugin = JUnitTestUtil.getPluginForProject((Project)Templates.getProject((WizardDescriptor)this.wizard));
        if (!JUnitTestUtil.createTestActionCalled((JUnitPlugin)plugin, (FileObject[])new FileObject[]{classToTest})) {
            return null;
        }
        FileObject[] testFileObjects = JUnitTestUtil.createTests((JUnitPlugin)plugin, (FileObject[])new FileObject[]{classToTest}, (FileObject)testRootFolder, (Map)params);
        if (testFileObjects == null) {
            throw new IOException();
        }
        HashSet<DataObject> dataObjects = new HashSet<DataObject>((int)((float)testFileObjects.length * 1.5f));
        for (FileObject testFile : testFileObjects) {
            try {
                dataObjects.add(DataObject.find((FileObject)testFile));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        if (dataObjects.isEmpty()) {
            throw new IOException();
        }
        return dataObjects;
    }

    private WizardDescriptor.Panel[] createPanels(WizardDescriptor wizardDescriptor) {
        return new WizardDescriptor.Panel[]{this.getClassChooserPanel()};
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        assert (panels != null);
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    private WizardDescriptor.Panel<WizardDescriptor> getClassChooserPanel() {
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        if (this.classChooserPanel == null || project != this.lastSelectedProject) {
            SourceGroupModifier.createSourceGroup((Project)project, (String)"java", (String)"test");
            JUnitUtils utils = new JUnitUtils(project);
            if (utils.getSourcesToTestsMap(true).isEmpty()) {
                this.classChooserPanel = new StepProblemMessage(project, NbBundle.getMessage(EmptyTestCaseWizardIterator.class, (String)"MSG_NoTestSourceGroup"));
            } else {
                if (this.classChooserPanel == null) {
                    this.classChooserPanel = new SimpleTestStepLocation();
                }
                ((SimpleTestStepLocation)this.classChooserPanel).setUp(utils);
            }
        }
        this.lastSelectedProject = project;
        return this.classChooserPanel;
    }

    private void loadSettings(WizardDescriptor wizard) {
        JUnitSettings settings = JUnitSettings.getDefault();
        wizard.putProperty("Public", (Object)settings.isMembersPublic());
        wizard.putProperty("Protected", (Object)settings.isMembersProtected());
        wizard.putProperty("Package", (Object)settings.isMembersPackage());
        wizard.putProperty("SetUp", (Object)settings.isGenerateSetUp());
        wizard.putProperty("TearDown", (Object)settings.isGenerateTearDown());
        wizard.putProperty("BeforeClass", (Object)settings.isGenerateClassSetUp());
        wizard.putProperty("AfterClass", (Object)settings.isGenerateClassTearDown());
        wizard.putProperty("Content", (Object)settings.isBodyContent());
        wizard.putProperty("JavaDoc", (Object)settings.isJavaDoc());
        wizard.putProperty("Comments", (Object)settings.isBodyComments());
        wizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(SimpleTestStepLocation.class, (String)"LBL_simpleTestWizard_stepName"));
    }

    private void saveSettings(WizardDescriptor wizard) {
        JUnitSettings settings = JUnitSettings.getDefault();
        settings.setMembersPublic(Boolean.TRUE.equals(wizard.getProperty("Public")));
        settings.setMembersProtected(Boolean.TRUE.equals(wizard.getProperty("Protected")));
        settings.setMembersPackage(Boolean.TRUE.equals(wizard.getProperty("Package")));
        settings.setGenerateSetUp(Boolean.TRUE.equals(wizard.getProperty("SetUp")));
        settings.setGenerateTearDown(Boolean.TRUE.equals(wizard.getProperty("TearDown")));
        settings.setGenerateClassSetUp(Boolean.TRUE.equals(wizard.getProperty("BeforeClass")));
        settings.setGenerateClassTearDown(Boolean.TRUE.equals(wizard.getProperty("AfterClass")));
        settings.setBodyContent(Boolean.TRUE.equals(wizard.getProperty("Content")));
        settings.setJavaDoc(Boolean.TRUE.equals(wizard.getProperty("JavaDoc")));
        settings.setBodyComments(Boolean.TRUE.equals(wizard.getProperty("Comments")));
    }
}

