/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.search.backend.smo.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Scanner;
import org.apache.maven.search.backend.smo.SmoSearchTransport;

public class UrlConnectionSmoSearchTransport
implements SmoSearchTransport {
    @Override
    public String fetch(String serviceUri, Map<String, String> headers) throws IOException {
        HttpURLConnection httpConnection = (HttpURLConnection)new URL(serviceUri).openConnection();
        httpConnection.setInstanceFollowRedirects(false);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            httpConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        int httpCode = httpConnection.getResponseCode();
        if (httpCode == 200) {
            try (InputStream inputStream = httpConnection.getInputStream();){
                Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8.name());
                try {
                    String string = scanner.useDelimiter("\\A").next();
                    scanner.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        throw new IOException("Unexpected response code: " + httpCode);
    }
}

