/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.spi.debugger.BreakpointsActivationProvider;

public final class ActiveBreakpoints {
    public static final String PROP_BREAKPOINTS_ACTIVE = "breakpointsActive";
    private static final List<Reference<DebuggerEngine>> dEngines = new LinkedList<Reference<DebuggerEngine>>();
    private static final List<Reference<ActiveBreakpoints>> aBreakpoints = new LinkedList<Reference<ActiveBreakpoints>>();
    private static final ActiveBreakpoints UNSUPPORTED = new ActiveBreakpoints(null);
    private final BreakpointsActivationProvider bap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActiveBreakpoints get(DebuggerEngine debuggerEngine) {
        BreakpointsActivationProvider bap = debuggerEngine.lookupFirst(null, BreakpointsActivationProvider.class);
        if (bap == null) {
            return UNSUPPORTED;
        }
        List<Reference<DebuggerEngine>> list = dEngines;
        synchronized (list) {
            for (int i = 0; i < dEngines.size(); ++i) {
                ActiveBreakpoints ab;
                DebuggerEngine de = dEngines.get(i).get();
                if (de == null) {
                    dEngines.remove(i);
                    aBreakpoints.remove(i);
                    --i;
                    continue;
                }
                if (de != debuggerEngine || (ab = aBreakpoints.get(i).get()) == null) continue;
                return ab;
            }
            ActiveBreakpoints ab = new ActiveBreakpoints(bap);
            dEngines.add(new WeakReference<DebuggerEngine>(debuggerEngine));
            aBreakpoints.add(new WeakReference<ActiveBreakpoints>(ab));
            return ab;
        }
    }

    private ActiveBreakpoints(BreakpointsActivationProvider bap) {
        this.bap = bap;
    }

    public boolean canDeactivateBreakpoints() {
        return this.bap != null;
    }

    public boolean areBreakpointsActive() {
        return this.bap == null || this.bap.areBreakpointsActive();
    }

    public void setBreakpointsActive(boolean active) throws UnsupportedOperationException {
        if (this.bap == null) {
            throw new UnsupportedOperationException("No implementation of BreakpointsActivationProvider provided by the engine.");
        }
        this.bap.setBreakpointsActive(active);
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.bap != null) {
            this.bap.addPropertyChangeListener(l);
        }
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.bap != null) {
            this.bap.removePropertyChangeListener(l);
        }
    }
}

