/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.modules.refactoring.java.ui.WhereUsedPanelClass;
import org.netbeans.modules.refactoring.java.ui.WhereUsedPanelMethod;
import org.netbeans.modules.refactoring.java.ui.WhereUsedPanelPackage;
import org.netbeans.modules.refactoring.java.ui.WhereUsedPanelVariable;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.ScopePanel;
import org.netbeans.modules.refactoring.spi.ui.ScopeProvider;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Pair;
import org.openide.util.lookup.Lookups;

public class WhereUsedPanel
extends JPanel
implements CustomRefactoringPanel {
    private final transient TreePathHandle element;
    private final transient ChangeListener parent;
    private boolean enableScope;
    private final WhereUsedInnerPanel panel;
    private boolean initialized = false;
    private ButtonGroup buttonGroup;
    private JPanel innerPanel;
    private JLabel jLabel1;
    private ScopePanel scope;

    private WhereUsedPanel(String name, TreePathHandle e, WhereUsedInnerPanel panel, ChangeListener parent) {
        this.setName(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_WhereUsed"));
        this.element = e;
        this.parent = parent;
        this.enableScope = true;
        this.panel = panel;
        this.initComponents();
    }

    public static WhereUsedPanel create(String name, TreePathHandle e, ElementKind kind, List<Pair<Pair<String, Icon>, TreePathHandle>> classes, ChangeListener parent) {
        WhereUsedInnerPanel panel;
        switch (kind) {
            case CONSTRUCTOR: 
            case METHOD: {
                panel = new WhereUsedPanelMethod(parent, e, classes);
                break;
            }
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case ANNOTATION_TYPE: {
                panel = new WhereUsedPanelClass(parent);
                break;
            }
            case PACKAGE: {
                panel = new WhereUsedPanelPackage(parent);
                break;
            }
            default: {
                panel = kind.name().equals("RECORD") ? new WhereUsedPanelClass(parent) : new WhereUsedPanelVariable(parent);
            }
        }
        return new WhereUsedPanel(name, e, panel, parent);
    }

    public ScopeProvider getCustomScope() {
        if (!this.enableScope) {
            final FileObject file = this.element.getFileObject();
            return new ScopeProvider(){

                public boolean initialize(Lookup context, AtomicBoolean cancel) {
                    return true;
                }

                public Scope getScope() {
                    return Scope.create(null, null, Arrays.asList(file));
                }
            };
        }
        return this.scope.getSelectedScopeProvider();
    }

    String getMethodDeclaringClass() {
        if (this.panel instanceof WhereUsedPanelMethod) {
            WhereUsedPanelMethod whereUsedPanelMethod = (WhereUsedPanelMethod)this.panel;
            return whereUsedPanelMethod.getMethodDeclaringClass();
        }
        return null;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        JavaSource source = JavaSource.forFileObject((FileObject)this.element.getFileObject());
        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

            public void cancel() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void run(CompilationController info) throws Exception {
                info.toPhase(JavaSource.Phase.RESOLVED);
                Element element = WhereUsedPanel.this.element.resolveElement((CompilationInfo)info);
                WhereUsedPanel.this.panel.initialize(element, info);
                if (element.getKind() == ElementKind.LOCAL_VARIABLE || element.getKind() == ElementKind.PARAMETER || element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    WhereUsedPanel.this.enableScope = false;
                } else {
                    WhereUsedPanel.this.enableScope = WhereUsedPanel.this.scope.initialize(Lookups.fixed((Object[])new Object[]{WhereUsedPanel.this.element.getFileObject(), WhereUsedPanel.this.element, element}), new AtomicBoolean());
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WhereUsedPanel.this.innerPanel.removeAll();
                        WhereUsedPanel.this.innerPanel.add((Component)WhereUsedPanel.this.panel, "Center");
                        WhereUsedPanel.this.panel.setVisible(true);
                        WhereUsedPanel.this.scope.setVisible(WhereUsedPanel.this.enableScope);
                        WhereUsedPanel.this.jLabel1.setVisible(WhereUsedPanel.this.enableScope);
                    }
                });
            }
        };
        try {
            source.runUserActionTask((Task)task, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.initialized = true;
    }

    public TreePathHandle getMethodHandle() {
        if (this.panel instanceof WhereUsedPanelMethod) {
            WhereUsedPanelMethod whereUsedPanelMethod = (WhereUsedPanelMethod)this.panel;
            return whereUsedPanelMethod.getMethodHandle();
        }
        return null;
    }

    @Override
    public boolean requestFocusInWindow() {
        return false;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.innerPanel = new JPanel();
        this.scope = new ScopePanel(WhereUsedPanel.class.getCanonicalName().replace('.', '-'), NbPreferences.forModule(WhereUsedPanel.class), "whereUsed.scope", this.parent);
        this.jLabel1 = new JLabel();
        this.innerPanel.setLayout(new BorderLayout());
        this.jLabel1.setLabelFor((Component)this.scope);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_Scope"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.innerPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.scope, -1, 511, Short.MAX_VALUE).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.innerPanel, -1, 210, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent((Component)this.scope, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addGap(0, 0, 0)));
    }

    public boolean isMethodFromBaseClass() {
        if (this.panel instanceof WhereUsedPanelMethod) {
            WhereUsedPanelMethod methodPanel = (WhereUsedPanelMethod)this.panel;
            return methodPanel.isMethodFromBaseClass();
        }
        return false;
    }

    public boolean isMethodOverriders() {
        if (this.panel instanceof WhereUsedPanelMethod) {
            WhereUsedPanelMethod methodPanel = (WhereUsedPanelMethod)this.panel;
            return methodPanel.isMethodOverriders();
        }
        return false;
    }

    public boolean isMethodFindUsages() {
        if (this.panel instanceof WhereUsedPanelMethod) {
            WhereUsedPanelMethod methodPanel = (WhereUsedPanelMethod)this.panel;
            return methodPanel.isMethodFindUsages();
        }
        return false;
    }

    public boolean isMethodSearchOverloaded() {
        if (this.panel instanceof WhereUsedPanelMethod) {
            WhereUsedPanelMethod methodPanel = (WhereUsedPanelMethod)this.panel;
            return methodPanel.isSearchOverloaded();
        }
        return false;
    }

    public boolean isClassSubTypes() {
        if (this.panel instanceof WhereUsedPanelClass) {
            WhereUsedPanelClass classPanel = (WhereUsedPanelClass)this.panel;
            return classPanel.isClassSubTypes();
        }
        return false;
    }

    public boolean isClassSubTypesDirectOnly() {
        if (this.panel instanceof WhereUsedPanelClass) {
            WhereUsedPanelClass classPanel = (WhereUsedPanelClass)this.panel;
            return classPanel.isClassSubTypesDirectOnly();
        }
        return false;
    }

    public boolean isClassFindUsages() {
        if (this.panel instanceof WhereUsedPanelClass) {
            WhereUsedPanelClass classPanel = (WhereUsedPanelClass)this.panel;
            return classPanel.isClassFindUsages();
        }
        return false;
    }

    public boolean isSearchInComments() {
        return this.panel.isSearchInComments();
    }

    public Component getComponent() {
        return this;
    }

    static abstract class WhereUsedInnerPanel
    extends JPanel {
        WhereUsedInnerPanel() {
        }

        abstract boolean isSearchInComments();

        abstract void initialize(Element var1, CompilationController var2);
    }
}

