/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.input;

import com.oracle.truffle.api.ArrayUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.tregex.nodes.input.InputEqualsNodeGen;
import com.oracle.truffle.regex.tregex.nodes.input.InputLengthNode;
import com.oracle.truffle.regex.tregex.nodes.input.InputReadNode;
import java.util.Arrays;

public abstract class InputEqualsNode
extends Node {
    public static InputEqualsNode create() {
        return InputEqualsNodeGen.create();
    }

    public abstract boolean execute(Object var1, Object var2, Object var3);

    @Specialization(guards={"mask == null"})
    public boolean doBytes(byte[] input, byte[] string, Object mask) {
        return Arrays.equals(input, string);
    }

    @Specialization(guards={"mask != null"})
    public boolean doBytesMask(byte[] input, byte[] string, byte[] mask) {
        return input.length == string.length && ArrayUtils.regionEqualsWithOrMask((byte[])input, (int)0, (byte[])string, (int)0, (int)mask.length, (byte[])mask);
    }

    @Specialization(guards={"mask == null"})
    public boolean doString(String input, String string, Object mask) {
        return input.equals(string);
    }

    @Specialization(guards={"mask != null"})
    public boolean doStringMask(String input, String string, String mask) {
        return input.length() == string.length() && ArrayUtils.regionEqualsWithOrMask((String)input, (int)0, (String)string, (int)0, (int)mask.length(), (String)mask);
    }

    @Specialization(guards={"mask == null"})
    public boolean doTruffleObjBytes(TruffleObject input, byte[] string, Object mask, @Cached InputLengthNode lengthNode, @Cached InputReadNode charAtNode) {
        return InputEqualsNode.equalsTruffleObj(input, string, null, lengthNode, charAtNode);
    }

    @Specialization(guards={"mask != null"})
    public boolean doTruffleObjBytesMask(TruffleObject input, byte[] string, byte[] mask, @Cached InputLengthNode lengthNode, @Cached InputReadNode charAtNode) {
        return InputEqualsNode.equalsTruffleObj(input, string, mask, lengthNode, charAtNode);
    }

    @Specialization(guards={"mask == null"})
    public boolean doTruffleObjString(TruffleObject input, String string, Object mask, @Cached InputLengthNode lengthNode, @Cached InputReadNode charAtNode) {
        return InputEqualsNode.equalsTruffleObj(input, string, null, lengthNode, charAtNode);
    }

    @Specialization(guards={"mask != null"})
    public boolean doTruffleObjStringMask(TruffleObject input, String string, String mask, @Cached InputLengthNode lengthNode, @Cached InputReadNode charAtNode) {
        return InputEqualsNode.equalsTruffleObj(input, string, mask, lengthNode, charAtNode);
    }

    private static boolean equalsTruffleObj(TruffleObject input, String string, String mask, InputLengthNode lengthNode, InputReadNode charAtNode) {
        if (lengthNode.execute(input) != string.length()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (InputReadNode.readWithMask(input, i, mask, i, charAtNode) == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsTruffleObj(TruffleObject input, byte[] string, byte[] mask, InputLengthNode lengthNode, InputReadNode charAtNode) {
        if (lengthNode.execute(input) != string.length) {
            return false;
        }
        for (int i = 0; i < string.length; ++i) {
            if (InputReadNode.readWithMask(input, i, mask, i, charAtNode) == Byte.toUnsignedInt(string[i])) continue;
            return false;
        }
        return true;
    }
}

