/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.core.storage;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.core.storage.CommonStorable;
import org.eclipse.mylyn.commons.core.storage.ICommonStorable;
import org.eclipse.osgi.util.NLS;

public class CommonStore {
    private static final long FLUSH_DELAY = 500L;
    private boolean scheduled;
    private FlushJob flushJob;
    private final Map<File, CommonStorable> storableByLocation;
    private File location;

    public CommonStore(File location) {
        Assert.isNotNull((Object)location);
        this.storableByLocation = new HashMap<File, CommonStorable>();
        this.location = location;
    }

    public synchronized ICommonStorable get(IPath path) {
        File file = this.getFile(path);
        CommonStorable storable = this.storableByLocation.get(file);
        if (storable == null) {
            storable = new CommonStorable(this, file);
            this.storableByLocation.put(file, storable);
        }
        return storable;
    }

    public File getLocation() {
        return this.location;
    }

    public void setLocation(File location) {
        Assert.isNotNull((Object)location);
        this.location = location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        CommonStore commonStore = this;
        synchronized (commonStore) {
            if (this.flushJob != null) {
                this.flushJob.cancel();
                this.flushJob = null;
            }
        }
        this.flushPending();
    }

    private File getFile(IPath path) {
        return this.getFile(path, true);
    }

    private File getFile(IPath path, boolean create) {
        File file = new File(this.location, path.toOSString());
        if (create && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return file;
    }

    synchronized void schedule() {
        if (!this.scheduled) {
            if (this.flushJob == null) {
                this.flushJob = new FlushJob();
            }
            this.flushJob.schedule(500L);
        }
    }

    synchronized void flushPending() {
        MultiStatus status = new MultiStatus("org.eclipse.mylyn.commons.core", 0, "Failed to save storable", null);
        for (CommonStorable memento : this.storableByLocation.values()) {
            if (!memento.isDirty()) continue;
            IStatus result = memento.flush();
            status.add(result);
        }
        if (!status.isOK()) {
            StatusHandler.log((IStatus)status);
        }
    }

    synchronized void release(CommonStorable storable) {
        this.storableByLocation.remove(storable.getPath());
    }

    public void move(IPath oldPath, IPath newPath) throws CoreException {
        File oldFile = this.getFile(oldPath, false);
        if (oldFile.exists()) {
            File newFile = this.getFile(newPath, false);
            newFile.getParentFile().mkdirs();
            if (!oldFile.renameTo(newFile)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.commons.core", NLS.bind((String)"The target path ''{0}'' already exists", (Object)newPath)));
            }
        }
    }

    private class FlushJob
    extends Job {
        public FlushJob() {
            super("Flush context mementos");
            this.setSystem(true);
            this.setPriority(20);
        }

        protected IStatus run(IProgressMonitor monitor) {
            CommonStore.this.flushPending();
            return Status.OK_STATUS;
        }
    }
}

