/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.wizard;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.docker.ui.UiUtils;
import org.netbeans.modules.docker.ui.wizard.Configuration;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class ConfigurationPanel
extends JPanel
implements Configuration {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton browseButton;
    private JLabel certDirectoryLabel;
    private JTextField certTextField;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JLabel urlLabel;
    private JTextField urlTextField;

    public ConfigurationPanel() {
        this.initComponents();
        DefaultDocumentListener listener = new DefaultDocumentListener();
        this.nameTextField.getDocument().addDocumentListener(listener);
        this.urlTextField.getDocument().addDocumentListener(listener);
        this.certTextField.getDocument().addDocumentListener(listener);
    }

    @Override
    public void setInputEnabled(boolean enabled) {
        this.nameTextField.setEnabled(enabled);
        this.urlTextField.setEnabled(enabled);
        this.certTextField.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public String getDisplayName() {
        return UiUtils.getValue(this.nameTextField);
    }

    @Override
    public void setDisplayName(String displayName) {
        this.nameTextField.setText(displayName);
    }

    @Override
    public boolean isSocketSelected() {
        return false;
    }

    @Override
    public void setSocketSelected(boolean socketSelected) {
    }

    @Override
    public File getSocket() {
        return null;
    }

    @Override
    public void setSocket(File socket) {
    }

    @Override
    public String getUrl() {
        return UiUtils.getValue(this.urlTextField);
    }

    @Override
    public void setUrl(String url) {
        this.urlTextField.setText(url);
    }

    @Override
    public String getCertPath() {
        return UiUtils.getValue(this.certTextField);
    }

    @Override
    public void setCertPath(String path) {
        this.certTextField.setText(path);
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.urlLabel = new JLabel();
        this.urlTextField = new JTextField();
        this.certDirectoryLabel = new JLabel();
        this.certTextField = new JTextField();
        this.browseButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(ConfigurationPanel.class, (String)"ConfigurationPanel.nameLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.urlLabel, (String)NbBundle.getMessage(ConfigurationPanel.class, (String)"ConfigurationPanel.urlLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.certDirectoryLabel, (String)NbBundle.getMessage(ConfigurationPanel.class, (String)"ConfigurationPanel.certDirectoryLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ConfigurationPanel.class, (String)"ConfigurationPanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurationPanel.this.browseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.certDirectoryLabel).addComponent(this.urlLabel).addComponent(this.nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.certTextField, -1, 202, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addComponent(this.nameTextField).addComponent(this.urlTextField))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.urlLabel).addComponent(this.urlTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.certDirectoryLabel).addComponent(this.certTextField, -2, -1, -2).addComponent(this.browseButton))));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setFileHidingEnabled(false);
        String text = UiUtils.getValue(this.certTextField);
        if (text != null) {
            chooser.setSelectedFile(new File(text));
        }
        if (chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0) {
            this.certTextField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ConfigurationPanel.this.changeSupport.fireChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ConfigurationPanel.this.changeSupport.fireChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ConfigurationPanel.this.changeSupport.fireChange();
        }
    }
}

