/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.pull;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.docker.api.Credentials;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerAuthenticationException;
import org.netbeans.modules.docker.api.DockerException;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.api.DockerName;
import org.netbeans.modules.docker.api.StatusEvent;
import org.netbeans.modules.docker.ui.credentials.CredentialsUtils;
import org.netbeans.modules.docker.ui.node.StatefulDockerInstance;
import org.netbeans.modules.docker.ui.output.StatusOutputListener;
import org.netbeans.modules.docker.ui.pull.Bundle;
import org.netbeans.modules.docker.ui.pull.DockerHubSearchPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class PullImageAction
extends NodeAction {
    private static final Logger LOGGER = Logger.getLogger(PullImageAction.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] activatedNodes) {
        DockerInstance instance = (DockerInstance)activatedNodes[0].getLookup().lookup(DockerInstance.class);
        if (instance != null) {
            JButton pullButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)pullButton, (String)Bundle.LBL_Pull());
            DockerHubSearchPanel panel = new DockerHubSearchPanel(instance, pullButton);
            DialogDescriptor descriptor = new DialogDescriptor((Object)panel, Bundle.LBL_SearchImage(), true, new Object[]{pullButton, DialogDescriptor.CANCEL_OPTION}, (Object)pullButton, 0, null, null);
            descriptor.setClosingOptions(new Object[]{pullButton, DialogDescriptor.CANCEL_OPTION});
            Dialog dlg = null;
            try {
                dlg = DialogDisplayer.getDefault().createDialog(descriptor);
                dlg.setVisible(true);
                if (descriptor.getValue() == pullButton) {
                    this.perform(instance, panel.getImage());
                }
            }
            finally {
                if (dlg != null) {
                    dlg.dispose();
                }
            }
        }
    }

    private void perform(DockerInstance instance, String image) {
        RequestProcessor.getDefault().post((Runnable)new Pull(instance, image));
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return false;
        }
        StatefulDockerInstance checked = (StatefulDockerInstance)activatedNodes[0].getLookup().lookup(StatefulDockerInstance.class);
        if (checked == null || !checked.isAvailable()) {
            return false;
        }
        return activatedNodes[0].getLookup().lookup(DockerInstance.class) != null;
    }

    public String getName() {
        return Bundle.LBL_PullImageAction();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private static class Pull
    implements Runnable {
        private final DockerInstance instance;
        private final String image;

        public Pull(DockerInstance instance, String image) {
            this.instance = instance;
            this.image = image;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            final InputOutput io = IOProvider.getDefault().getIO(Bundle.MSG_Pulling(this.image), false);
            ProgressHandle handle = ProgressHandleFactory.createHandle((String)Bundle.MSG_Pulling(this.image), (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    io.select();
                }
            });
            handle.start();
            try {
                io.getOut().reset();
                io.select();
                DockerAction facade = new DockerAction(this.instance);
                facade.pull(this.image, (StatusEvent.Listener)new StatusOutputListener(io));
            }
            catch (DockerAuthenticationException ex) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)Bundle.MSG_EditCredentials(), 0);
                        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)desc) != NotifyDescriptor.YES_OPTION) {
                            return;
                        }
                        DockerName name = DockerName.parse((String)image);
                        Credentials c = CredentialsUtils.askForCredentials(name.getRegistry());
                        if (c != null) {
                            RequestProcessor.getDefault().post((Runnable)this);
                        }
                    }
                });
            }
            catch (DockerException ex) {
                LOGGER.log(Level.INFO, null, ex);
                io.getErr().println(ex.getMessage());
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            finally {
                io.getOut().close();
                handle.finish();
            }
        }
    }
}

