/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.api;

import org.openide.util.Lookup;
import org.openide.windows.InputOutput;

public abstract class IOEmulation {
    private static IOEmulation find(InputOutput io) {
        if (io instanceof Lookup.Provider) {
            Lookup.Provider p = (Lookup.Provider)io;
            return (IOEmulation)p.getLookup().lookup(IOEmulation.class);
        }
        return null;
    }

    public static String getEmulation(InputOutput io) {
        IOEmulation ior = IOEmulation.find(io);
        if (ior != null) {
            return ior.getEmulation();
        }
        return "dumb";
    }

    public static boolean isDisciplined(InputOutput io) {
        IOEmulation ior = IOEmulation.find(io);
        if (ior != null) {
            return ior.isDisciplined();
        }
        return true;
    }

    public static void setDisciplined(InputOutput io) {
        IOEmulation ior = IOEmulation.find(io);
        if (ior != null) {
            ior.setDisciplined();
        }
    }

    public static boolean isSupported(InputOutput io) {
        return IOEmulation.find(io) != null;
    }

    protected abstract String getEmulation();

    protected abstract boolean isDisciplined();

    protected abstract void setDisciplined();
}

