/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.webservices.ui.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.websvc.core.webservices.ui.panels.ClientExplorerPanel;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ProjectFileExplorer
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private DialogDescriptor descriptor;
    private final ExplorerManager manager;
    private BeanTreeView treeView;
    private DataObject selectedFolder;
    private final Project[] projects;
    private final Children rootChildren;
    private final Node explorerClientRoot;
    private final List<Node> projectNodeList;
    private JCheckBox dontCopyCB;
    private JLabel jLblTreeView;
    private final JPanel eventBlocker = new JPanel(){
        {
            this.enableEvents(16L);
        }
    };

    public ProjectFileExplorer() {
        this.projects = OpenProjects.getDefault().getOpenProjects();
        this.rootChildren = new Children.Array();
        this.explorerClientRoot = new AbstractNode(this.rootChildren);
        this.projectNodeList = new ArrayList<Node>();
        this.manager = new ExplorerManager();
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.dontCopyCB = new JCheckBox();
        this.jLblTreeView = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.dontCopyCB, (String)NbBundle.getMessage(ProjectFileExplorer.class, (String)"TXT_DONOTCOPY"));
        this.dontCopyCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProjectFileExplorer.this.dontCopyCBActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.dontCopyCB, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLblTreeView, (String)NbBundle.getMessage(ProjectFileExplorer.class, (String)"LBL_SelectProjectLocation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.jLblTreeView, gridBagConstraints);
    }

    private String getTreeViewLabel(boolean dontCopy) {
        if (dontCopy) {
            return NbBundle.getMessage(ProjectFileExplorer.class, (String)"TXT_DONOTCOPY_TOOLTIP");
        }
        return NbBundle.getMessage(ProjectFileExplorer.class, (String)"LBL_SelectProjectLocation");
    }

    private void dontCopyCBActionPerformed(ActionEvent evt) {
        if (this.dontCopyCB.isSelected()) {
            this.descriptor.setValid(true);
            this.treeView.setEnabled(false);
            this.jLblTreeView.setText(this.getTreeViewLabel(true));
            this.eventBlocker.setVisible(true);
        } else {
            this.descriptor.setValid(this.getSelectedFile() != null);
            this.treeView.setEnabled(true);
            this.jLblTreeView.setText(this.getTreeViewLabel(false));
            this.eventBlocker.setVisible(false);
        }
    }

    private void initUserComponents() {
        this.treeView = new BeanTreeView();
        this.treeView.setRootVisible(false);
        this.treeView.setPopupAllowed(false);
        this.treeView.setDefaultActionAllowed(false);
        this.treeView.setSelectionMode(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.eventBlocker.setOpaque(false);
        this.eventBlocker.setVisible(this.dontCopyCB.isSelected());
        this.add((Component)this.eventBlocker, gridBagConstraints);
        this.add((Component)this.treeView, gridBagConstraints);
        this.jLblTreeView.setLabelFor(this.treeView.getViewport().getView());
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientExplorerPanel.class, (String)"ACSD_AvailableWebServicesTree"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientExplorerPanel.class, (String)"ACSD_AvailableWebServicesTree"));
        this.dontCopyCB.setToolTipText(NbBundle.getMessage(ProjectFileExplorer.class, (String)"TXT_DONOTCOPY_TOOLTIP"));
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        for (int i = 0; i < this.projects.length; ++i) {
            try {
                Project project = this.projects[i];
                FileObject projectDir = project.getProjectDirectory();
                DataObject projectDirDObj = DataObject.find((FileObject)projectDir);
                Node rootNode = projectDirDObj.getNodeDelegate();
                FilterNode node = new FilterNode(rootNode);
                this.projectNodeList.add((Node)node);
                continue;
            }
            catch (DataObjectNotFoundException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        Node[] projectNodes = new Node[this.projectNodeList.size()];
        this.projectNodeList.toArray(projectNodes);
        this.rootChildren.add(projectNodes);
        this.manager.setRootContext(this.explorerClientRoot);
        this.descriptor.setValid(false);
    }

    @Override
    public void removeNotify() {
        this.manager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public void setDescriptor(DialogDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public boolean dontCopy() {
        return this.dontCopyCB.isSelected();
    }

    public DataObject getSelectedFolder() {
        return this.selectedFolder;
    }

    private DataObject getSelectedFile() {
        Node node;
        DataObject dobj;
        Node[] nodes = this.manager.getSelectedNodes();
        if (nodes != null && nodes.length > 0 && (dobj = (DataObject)(node = nodes[0]).getLookup().lookup(DataObject.class)) != null && dobj.getPrimaryFile().isFolder()) {
            return dobj;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.manager && "selectedNodes".equals(evt.getPropertyName())) {
            DataObject folder = this.getSelectedFile();
            if (folder != null) {
                this.selectedFolder = folder;
                this.descriptor.setValid(true);
            } else {
                this.selectedFolder = null;
                this.descriptor.setValid(false);
            }
        }
    }
}

