/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.actions;

import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.support.AddOperationCookie;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsAddOperation;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.spi.support.AddOperationActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class JaxWsAddOperationProvider
implements AddOperationActionProvider {
    public AddOperationCookie getAddOperationCookie(FileObject fileObject) {
        Service service;
        String packageName;
        if (!fileObject.isValid()) {
            return null;
        }
        JAXWSSupport support = JAXWSSupport.getJAXWSSupport((FileObject)fileObject);
        if (support != null && (packageName = this.getPackageName(fileObject)) != null && (service = this.getService(support, packageName)) != null && service.getWsdlUrl() == null) {
            return new JaxWsAddOperation(fileObject);
        }
        return null;
    }

    private Service getService(JAXWSSupport support, String packageName) {
        List services = support.getServices();
        for (Object service : services) {
            if (!packageName.equals(((Service)service).getImplementationClass())) continue;
            return (Service)service;
        }
        return null;
    }

    private String getPackageName(FileObject fo) {
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        SourceGroup[] groups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (groups != null) {
            for (SourceGroup group : groups) {
                FileObject rootFolder = group.getRootFolder();
                if (!FileUtil.isParentOf((FileObject)rootFolder, (FileObject)fo)) continue;
                String relativePath = FileUtil.getRelativePath((FileObject)rootFolder, (FileObject)fo).replace('/', '.');
                return relativePath.endsWith(".java") ? relativePath.substring(0, relativePath.length() - 5) : relativePath;
            }
        }
        return null;
    }
}

