/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.groovy.extender;

import java.util.List;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMComponentFactory;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.Project;

public class AddMavenCompilerPlugin
implements ModelOperation<POMModel> {
    private POMComponentFactory factory;
    private Project project;

    public void performOperation(POMModel model) {
        Plugin plugin;
        this.factory = model.getFactory();
        this.project = model.getProject();
        Build build = this.project.getBuild();
        if (build == null) {
            build = this.factory.createBuild();
            this.project.setBuild(build);
        }
        if ((plugin = this.searchMavenCompilerPlugin(build)) == null) {
            build.addPlugin(this.createMavenEclipseCompilerPlugin());
        } else {
            Plugin newPlugin = this.createMavenEclipseCompilerPlugin(plugin);
            build.removePlugin(plugin);
            build.addPlugin(newPlugin);
        }
    }

    private Plugin searchMavenCompilerPlugin(Build build) {
        List plugins = build.getPlugins();
        if (plugins != null) {
            for (Plugin plugin : plugins) {
                if (!"org.apache.maven.plugins".equals(plugin.getGroupId()) || !"maven-compiler-plugin".equals(plugin.getArtifactId())) continue;
                return plugin;
            }
        }
        return null;
    }

    private Plugin createMavenEclipseCompilerPlugin() {
        Plugin plugin = this.factory.createPlugin();
        plugin.setGroupId("org.apache.maven.plugins");
        plugin.setArtifactId("maven-compiler-plugin");
        plugin.setVersion("3.3");
        plugin.setConfiguration(this.createConfiguration());
        this.createCompilerDependency(plugin);
        this.createBatchDependency(plugin);
        return plugin;
    }

    private Configuration createConfiguration() {
        Configuration configuration = this.factory.createConfiguration();
        configuration.setSimpleParameter("compilerId", "groovy-eclipse-compiler");
        return configuration;
    }

    private void createCompilerDependency(Plugin plugin) {
        Dependency compilerDependency = this.factory.createDependency();
        compilerDependency.setGroupId("org.codehaus.groovy");
        compilerDependency.setArtifactId("groovy-eclipse-compiler");
        compilerDependency.setVersion("2.9.2-01");
        plugin.addDependency(compilerDependency);
    }

    private void createBatchDependency(Plugin plugin) {
        Dependency batchDependency = this.factory.createDependency();
        batchDependency.setGroupId("org.codehaus.groovy");
        batchDependency.setArtifactId("groovy-eclipse-batch");
        batchDependency.setVersion("2.4.3-01 ");
        plugin.addDependency(batchDependency);
    }

    private Plugin createMavenEclipseCompilerPlugin(Plugin plugin) {
        Plugin newPlugin = this.factory.createPlugin();
        newPlugin.setGroupId(plugin.getGroupId());
        newPlugin.setArtifactId(plugin.getArtifactId());
        newPlugin.setVersion(plugin.getVersion());
        this.updateCompilerDependency(plugin, newPlugin);
        this.updateBatchDependency(plugin, newPlugin);
        this.updateConfiguration(plugin, newPlugin);
        return newPlugin;
    }

    private void updateCompilerDependency(Plugin oldPlugin, Plugin newPlugin) {
        List dependencies = oldPlugin.getDependencies();
        if (dependencies != null) {
            for (Dependency dependency : dependencies) {
                if (!"org.codehaus.groovy".equals(dependency.getGroupId()) || !"groovy-eclipse-compiler".equals(dependency.getArtifactId())) continue;
                Dependency newDependency = this.factory.createDependency();
                newDependency.setGroupId(dependency.getGroupId());
                newDependency.setArtifactId(dependency.getArtifactId());
                newDependency.setVersion(dependency.getVersion());
                newPlugin.addDependency(newDependency);
            }
        }
        this.createCompilerDependency(newPlugin);
    }

    private void updateBatchDependency(Plugin oldPlugin, Plugin newPlugin) {
        List dependencies = oldPlugin.getDependencies();
        if (dependencies != null) {
            for (Dependency dependency : dependencies) {
                if (!"org.codehaus.groovy".equals(dependency.getGroupId()) || !"groovy-eclipse-batch".equals(dependency.getArtifactId())) continue;
                Dependency newDependency = this.factory.createDependency();
                newDependency.setGroupId(dependency.getGroupId());
                newDependency.setArtifactId(dependency.getArtifactId());
                newDependency.setVersion(dependency.getVersion());
                newPlugin.addDependency(newDependency);
            }
        }
        this.createBatchDependency(newPlugin);
    }

    private void updateConfiguration(Plugin oldPlugin, Plugin newPlugin) {
        String compilerId;
        Configuration currentConfiguration = oldPlugin.getConfiguration();
        Configuration newConfiguration = this.factory.createConfiguration();
        if (currentConfiguration != null) {
            for (POMExtensibilityElement element : currentConfiguration.getConfigurationElements()) {
                POMExtensibilityElement newElement = this.factory.createPOMExtensibilityElement(element.getQName());
                newElement.setElementText(element.getElementText());
                int position = 0;
                for (POMExtensibilityElement childElement : element.getAnyElements()) {
                    POMExtensibilityElement newChildElement = this.factory.createPOMExtensibilityElement(childElement.getQName());
                    newChildElement.setElementText(childElement.getElementText());
                    newElement.addAnyElement(newChildElement, position++);
                }
                newConfiguration.addExtensibilityElement(newElement);
            }
        }
        if ((compilerId = newConfiguration.getSimpleParameter("compilerId")) == null) {
            newConfiguration.setSimpleParameter("compilerId", "groovy-eclipse-compiler");
        } else {
            newConfiguration.setSimpleParameter("compilerId", compilerId);
        }
        newPlugin.setConfiguration(newConfiguration);
    }
}

