/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.polyglot.HostInteropErrors;
import com.oracle.truffle.polyglot.HostInteropReflect;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.ToHostNode;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

@ImportStatic(value={HostInteropReflect.class})
abstract class ProxyInvokeNode
extends Node {
    protected static final int LIMIT = Integer.MAX_VALUE;
    @CompilerDirectives.CompilationFinal
    private boolean invokeFailed;

    ProxyInvokeNode() {
    }

    public abstract Object execute(PolyglotLanguageContext var1, Object var2, Method var3, Object[] var4);

    @Specialization(guards={"cachedMethod == method"}, limit="LIMIT")
    protected Object doCachedMethod(PolyglotLanguageContext languageContext, Object receiver, Method method, Object[] arguments, @Cached(value="method") Method cachedMethod, @Cached(value="method.getName()") String name, @Cached(value="getMethodReturnType(method)") Class<?> returnClass, @Cached(value="getMethodGenericReturnType(method)") Type returnType, @CachedLibrary(value="receiver") InteropLibrary receivers, @CachedLibrary(limit="LIMIT") InteropLibrary members, @Cached ConditionProfile branchProfile, @Cached(value="create()") ToHostNode toHost, @Cached BranchProfile error) {
        Object result = this.invokeOrExecute(languageContext, receiver, arguments, name, receivers, members, branchProfile, error);
        return toHost.execute(result, returnClass, returnType, languageContext, true);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean guardReturnType(Method method, Type returnType) {
        return method.getGenericReturnType().equals(returnType);
    }

    private Object invokeOrExecute(PolyglotLanguageContext polyglotContext, Object receiver, Object[] arguments, String member, InteropLibrary receivers, InteropLibrary members, ConditionProfile invokeProfile, BranchProfile error) {
        try {
            boolean localInvokeFailed = this.invokeFailed;
            if (!localInvokeFailed) {
                try {
                    return receivers.invokeMember(receiver, member, arguments);
                }
                catch (UnknownIdentifierException | UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    localInvokeFailed = true;
                    this.invokeFailed = true;
                }
            }
            if (localInvokeFailed) {
                if (invokeProfile.profile(receivers.isMemberInvocable(receiver, member))) {
                    return receivers.invokeMember(receiver, member, arguments);
                }
                if (receivers.isMemberReadable(receiver, member)) {
                    Object readMember = receivers.readMember(receiver, member);
                    if (members.isExecutable(readMember)) {
                        return members.execute(readMember, arguments);
                    }
                    if (arguments.length == 0) {
                        return readMember;
                    }
                }
            }
            error.enter();
            throw HostInteropErrors.invokeUnsupported(polyglotContext, receiver, member);
        }
        catch (UnknownIdentifierException e) {
            error.enter();
            throw HostInteropErrors.invokeUnsupported(polyglotContext, receiver, member);
        }
        catch (UnsupportedTypeException e) {
            error.enter();
            throw HostInteropErrors.invalidExecuteArgumentType(polyglotContext, receiver, e.getSuppliedValues());
        }
        catch (ArityException e) {
            error.enter();
            throw HostInteropErrors.invalidExecuteArity(polyglotContext, receiver, arguments, e.getExpectedArity(), e.getActualArity());
        }
        catch (UnsupportedMessageException e) {
            error.enter();
            throw HostInteropErrors.invokeUnsupported(polyglotContext, receiver, member);
        }
    }
}

