/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.exception;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.TruffleStackTrace;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;

public abstract class AbstractTruffleException
extends RuntimeException
implements TruffleObject,
TruffleException {
    public static final int UNLIMITED_STACK_TRACE = -1;
    private final int stackTraceElementLimit;
    private final Throwable cause;
    private final Node location;
    private Throwable lazyStackTrace;

    protected AbstractTruffleException() {
        this(null, null, -1, null);
    }

    protected AbstractTruffleException(Node location) {
        this(null, null, -1, location);
    }

    protected AbstractTruffleException(String message) {
        this(message, null, -1, null);
    }

    protected AbstractTruffleException(String message, Node location) {
        this(message, null, -1, location);
    }

    @CompilerDirectives.TruffleBoundary
    protected AbstractTruffleException(AbstractTruffleException prototype) {
        this(prototype.getMessage(), prototype.getCause(), prototype.getStackTraceElementLimit(), prototype.getLocation());
        for (Throwable t : prototype.getSuppressed()) {
            this.addSuppressed(t);
        }
        TruffleStackTrace.fillIn(prototype);
        assert (prototype.lazyStackTrace != null) : "Prototype must have a stack trace after fillIn.";
        this.lazyStackTrace = prototype.lazyStackTrace;
    }

    protected AbstractTruffleException(String message, Throwable cause, int stackTraceElementLimit, Node location) {
        super(message, cause);
        this.stackTraceElementLimit = stackTraceElementLimit;
        this.cause = cause;
        this.location = location;
    }

    @Override
    public final Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public final Node getLocation() {
        return this.location;
    }

    @Override
    public final int getStackTraceElementLimit() {
        return this.stackTraceElementLimit;
    }

    @Override
    @Deprecated
    public final SourceSection getSourceLocation() {
        InteropLibrary interop = InteropLibrary.getUncached();
        if (interop.hasSourceLocation(this)) {
            try {
                return interop.getSourceLocation(this);
            }
            catch (UnsupportedMessageException um) {
                throw CompilerDirectives.shouldNotReachHere(um);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public final Object getExceptionObject() {
        return this;
    }

    @Override
    @Deprecated
    public final boolean isSyntaxError() {
        return this.getExceptionType() == ExceptionType.PARSE_ERROR;
    }

    @Override
    @Deprecated
    public final boolean isIncompleteSource() {
        try {
            return InteropLibrary.getUncached().isExceptionIncompleteSource(this);
        }
        catch (UnsupportedMessageException um) {
            throw CompilerDirectives.shouldNotReachHere(um);
        }
    }

    @Override
    @Deprecated
    public final boolean isInternalError() {
        return false;
    }

    @Override
    @Deprecated
    public final boolean isCancelled() {
        return false;
    }

    @Override
    @Deprecated
    public final boolean isExit() {
        return this.getExceptionType() == ExceptionType.EXIT;
    }

    @Override
    @Deprecated
    public final int getExitStatus() {
        try {
            return InteropLibrary.getUncached().getExceptionExitStatus(this);
        }
        catch (UnsupportedMessageException um) {
            throw CompilerDirectives.shouldNotReachHere(um);
        }
    }

    @Override
    @Deprecated
    @CompilerDirectives.TruffleBoundary
    public final Throwable initCause(Throwable throwable) {
        throw new UnsupportedOperationException("Not supported. Pass in the cause using the constructors instead.");
    }

    @Override
    public final Throwable getCause() {
        return this.cause;
    }

    Throwable getLazyStackTrace() {
        return this.lazyStackTrace;
    }

    void setLazyStackTrace(Throwable stackTrace) {
        this.lazyStackTrace = stackTrace;
    }

    private ExceptionType getExceptionType() {
        try {
            return InteropLibrary.getUncached().getExceptionType(this);
        }
        catch (UnsupportedMessageException um) {
            throw CompilerDirectives.shouldNotReachHere(um);
        }
    }

    static boolean isTruffleException(Throwable t) {
        return t instanceof TruffleException;
    }
}

