/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging.api.css;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.netbeans.modules.web.webkit.debugging.api.css.Media;
import org.netbeans.modules.web.webkit.debugging.api.css.RuleId;
import org.netbeans.modules.web.webkit.debugging.api.css.Selector;
import org.netbeans.modules.web.webkit.debugging.api.css.SourceRange;
import org.netbeans.modules.web.webkit.debugging.api.css.Style;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetBody;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetOrigin;

public class Rule {
    private RuleId id;
    private String selector;
    private List<Selector> selectors;
    private final String sourceURL;
    private final int sourceLine;
    private final StyleSheetOrigin origin;
    private final Style style;
    private SourceRange selectorRange;
    private final List<Media> media;
    private StyleSheetBody parentStyleSheet;
    private final JSONObject json;

    Rule(JSONObject rule) {
        this.json = rule;
        boolean isRuleMatch = rule.containsKey((Object)"rule");
        if (isRuleMatch) {
            rule = (JSONObject)this.json.get((Object)"rule");
        }
        if (rule.containsKey((Object)"ruleId")) {
            this.id = new RuleId((JSONObject)rule.get((Object)"ruleId"));
        } else if (rule.containsKey((Object)"styleSheetId")) {
            this.id = new RuleId((String)rule.get((Object)"styleSheetId"));
        }
        this.sourceURL = (String)rule.get((Object)"sourceURL");
        this.sourceLine = rule.containsKey((Object)"sourceLine") ? ((Number)rule.get((Object)"sourceLine")).intValue() : -1;
        String originCode = (String)rule.get((Object)"origin");
        this.origin = StyleSheetOrigin.forCode(originCode);
        this.style = new Style((JSONObject)rule.get((Object)"style"), (String)rule.get((Object)"styleSheetId"));
        if (rule.containsKey((Object)"media")) {
            JSONArray array = (JSONArray)rule.get((Object)"media");
            this.media = new ArrayList<Media>(array.size());
            for (Object o : array) {
                this.media.add(new Media((JSONObject)o));
            }
        } else {
            this.media = Collections.emptyList();
        }
        if (rule.containsKey((Object)"selectorList")) {
            JSONObject selectorList = (JSONObject)rule.get((Object)"selectorList");
            this.selector = (String)selectorList.get((Object)"text");
            if (selectorList.containsKey((Object)"range")) {
                this.selectorRange = new SourceRange((JSONObject)selectorList.get((Object)"range"));
            }
            if (selectorList.containsKey((Object)"selectors")) {
                JSONArray array = (JSONArray)selectorList.get((Object)"selectors");
                this.selectors = new ArrayList<Selector>(array.size());
                for (Object o : array) {
                    Selector nextSelector = o instanceof String ? new Selector((String)o) : new Selector((JSONObject)o);
                    this.selectors.add(nextSelector);
                }
            }
        } else {
            this.selector = (String)rule.get((Object)"selectorText");
            if (rule.containsKey((Object)"selectorRange")) {
                this.selectorRange = new SourceRange((JSONObject)rule.get((Object)"selectorRange"));
            }
        }
    }

    public RuleId getId() {
        return this.id;
    }

    public String getSelector() {
        return this.selector;
    }

    void setSelector(String selector) {
        this.selector = selector;
    }

    public String getSourceURL() {
        String url = this.sourceURL;
        if (url == null && this.parentStyleSheet != null) {
            url = this.parentStyleSheet.getHeader().getSourceURL();
        }
        return url;
    }

    public int getSourceLine() {
        Selector firstSelector;
        SourceRange range;
        if (this.sourceLine == -1 && this.selectors != null && (range = (firstSelector = this.selectors.get(0)).getRange()) != null) {
            return range.getStartLine();
        }
        int line = this.sourceLine == -1 && this.selectorRange != null ? this.selectorRange.getStartLine() : this.sourceLine;
        return line;
    }

    public StyleSheetOrigin getOrigin() {
        return this.origin;
    }

    public Style getStyle() {
        return this.style;
    }

    public SourceRange getSelectorRange() {
        return this.selectorRange;
    }

    public List<Media> getMedia() {
        return Collections.unmodifiableList(this.media);
    }

    public StyleSheetBody getParentStyleSheet() {
        return this.parentStyleSheet;
    }

    void setParentStyleSheet(StyleSheetBody parentStyleSheet) {
        this.parentStyleSheet = parentStyleSheet;
    }

    public String toString() {
        return this.json.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Rule)) {
            return false;
        }
        RuleId ruleId = this.getId();
        if (ruleId == null || ruleId.getOrdinal() == -1) {
            return this == object;
        }
        Rule other = (Rule)object;
        return ruleId.equals(other.getId());
    }

    public int hashCode() {
        RuleId ruleId = this.getId();
        return ruleId == null || ruleId.getOrdinal() == -1 ? super.hashCode() : ruleId.hashCode();
    }
}

