/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.javafx2.platform.api.JavaFXPlatformUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class ChooseOtherPlatformPanel
extends JPanel {
    private JLabel jLabel1;
    private JButton managePlatforms;
    private JComboBox platforms;

    public ChooseOtherPlatformPanel(@NonNull String type) {
        Parameters.notNull((CharSequence)"type", (Object)type);
        this.initComponents();
        this.postInit(type);
    }

    final JavaPlatform getSelectedPlatform() {
        return (JavaPlatform)this.platforms.getSelectedItem();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.platforms = new JComboBox();
        this.managePlatforms = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.platforms);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ChooseOtherPlatformPanel.class, (String)"ChooseOtherPlatformPanel.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.platforms.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 100;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        this.add((Component)this.platforms, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.managePlatforms, (String)NbBundle.getMessage(ChooseOtherPlatformPanel.class, (String)"ChooseOtherPlatformPanel.managePlatforms.text"));
        this.managePlatforms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseOtherPlatformPanel.this.managePlatforms(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.managePlatforms, gridBagConstraints);
    }

    private void managePlatforms(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer(null);
        ((PlatformModel)this.platforms.getModel()).refresh();
    }

    private void postInit(@NonNull String type) {
        this.platforms.setModel(new PlatformModel(type));
        this.platforms.setRenderer(new PlatformRenderer());
    }

    private static class PlatformRenderer
    extends DefaultListCellRenderer {
        private PlatformRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof JavaPlatform) {
                value = ((JavaPlatform)value).getDisplayName();
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    private static final class PlatformModel
    extends DefaultComboBoxModel {
        private final String type;

        PlatformModel(@NonNull String type) {
            this.type = type;
            this.refresh();
        }

        void refresh() {
            JavaPlatform[] platforms;
            this.removeAllElements();
            for (JavaPlatform jp : platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification(this.type, null))) {
                if (!JavaFXPlatformUtils.isJavaFXEnabled((JavaPlatform)jp)) continue;
                this.addElement(jp);
            }
        }
    }
}

