/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.hints.projects.support;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.spi.editor.hints.projects.support.Bundle;
import org.netbeans.spi.editor.hints.projects.support.StandardProjectSettings;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class AdvancedLocationPanel
extends JPanel {
    private final StandardProjectSettings.Standard standard;
    private JButton browse;
    private JTextField fileLocation;
    private JLabel jLabel1;
    private JButton toDefault;

    public AdvancedLocationPanel(String currentHintFileLocation, StandardProjectSettings.Standard standard) {
        this.initComponents();
        this.fileLocation.setText(currentHintFileLocation);
        this.standard = standard;
        this.browse.setEnabled(standard.getProjectLocation() != null);
        this.fileLocation.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AdvancedLocationPanel.this.enableDisable();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AdvancedLocationPanel.this.enableDisable();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.enableDisable();
    }

    public String getHintFileLocation() {
        return this.fileLocation.getText();
    }

    private void enableDisable() {
        this.toDefault.setEnabled(!Objects.equals(this.standard.getDefaultHintLocation(), this.fileLocation.getText()));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.fileLocation = new JTextField();
        this.toDefault = new JButton();
        this.browse = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AdvancedLocationPanel.class, (String)"AdvancedLocationPanel.jLabel1.text"));
        this.fileLocation.setColumns(30);
        this.fileLocation.setText(NbBundle.getMessage(AdvancedLocationPanel.class, (String)"AdvancedLocationPanel.fileLocation.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.toDefault, (String)NbBundle.getMessage(AdvancedLocationPanel.class, (String)"AdvancedLocationPanel.toDefault.text"));
        this.toDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedLocationPanel.this.toDefaultActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.browse, (String)NbBundle.getMessage(AdvancedLocationPanel.class, (String)"AdvancedLocationPanel.browse.text"));
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AdvancedLocationPanel.this.browseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileLocation, -1, 248, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.toDefault).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.browse)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.fileLocation, -2, -1, -2).addComponent(this.toDefault).addComponent(this.browse)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void toDefaultActionPerformed(ActionEvent evt) {
        this.fileLocation.setText(this.standard.getDefaultHintLocation());
    }

    private void browseActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setSelectedFile(new File(this.standard.getProjectLocation(), this.fileLocation.getText()));
        if (jfc.showDialog(this, Bundle.LBL_Select()) == 0) {
            this.fileLocation.setText(this.standard.getProjectLocation().toURI().relativize(jfc.getSelectedFile().toURI()).getPath());
        }
    }
}

