/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.editor.hints.projects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.modules.options.editor.spi.OptionsFilter;
import org.netbeans.spi.editor.hints.projects.PerProjectHintsPanel;
import org.netbeans.spi.editor.hints.settings.FileHintPreferences;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.awt.Mnemonics;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class PerProjectHintsPanelUI
extends JPanel {
    private static final Logger LOG = Logger.getLogger(PerProjectHintsPanelUI.class.getName());
    private PerProjectHintsPanel.MimeType2Preferences globalPreferencesProvider;
    private PerProjectHintsPanel.MimeType2Preferences preferencesProvider;
    private final Map<LanguageDescription, OptionsPanelController> mimeType2OptionsController = new HashMap<LanguageDescription, OptionsPanelController>();
    private final Map<LanguageDescription, JComponent> mimeType2OptionsPanel = new HashMap<LanguageDescription, JComponent>();
    private final Set<String> supportsFiltering = new HashSet<String>();
    private JPanel customPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JComboBox languageCombo;
    private JTextField searchText;

    public PerProjectHintsPanelUI(FileObject customizersFolder) {
        this.globalPreferencesProvider = new PerProjectHintsPanel.MimeType2Preferences(){

            @Override
            public Preferences getPreferences(String mimeType) {
                for (FileHintPreferences.GlobalHintPreferencesProvider p : MimeLookup.getLookup((String)mimeType).lookupAll(FileHintPreferences.GlobalHintPreferencesProvider.class)) {
                    Preferences prefs = p.getGlobalPreferences();
                    if (prefs == null) continue;
                    return prefs;
                }
                throw new IllegalStateException("Must have some working GlobalHintPreferencesProvider!");
            }
        };
        this.initComponents();
        for (FileObject customizer : customizersFolder.getChildren()) {
            try {
                Object value;
                InstanceCookie ic = (InstanceCookie)customizer.getLookup().lookup(InstanceCookie.class);
                if (ic == null || !((value = ic.instanceCreate()) instanceof OptionsPanelController)) continue;
                Object mimeType = customizer.getAttribute("mimeType");
                if (!(mimeType instanceof String)) {
                    LOG.log(Level.WARNING, "{0} does not provide a string-based mimeType!", FileUtil.getFileDisplayName((FileObject)customizer));
                    continue;
                }
                FileObject editorFolder = FileUtil.getConfigFile((String)("Editors/" + (String)mimeType));
                String mimeDN = editorFolder != null ? PerProjectHintsPanelUI.getFileObjectLocalizedName(editorFolder, (String)mimeType) : (String)mimeType;
                this.mimeType2OptionsController.put(new LanguageDescription((String)mimeType, mimeDN), (OptionsPanelController)value);
            }
            catch (IOException | ClassNotFoundException ex) {
                LOG.log(Level.FINE, null, ex);
            }
        }
        LanguageDescription[] mimeTypes = this.mimeType2OptionsController.keySet().toArray(new LanguageDescription[0]);
        Arrays.sort(mimeTypes, new Comparator<LanguageDescription>(){

            @Override
            public int compare(LanguageDescription o1, LanguageDescription o2) {
                return o1.displayName.compareTo(o2.displayName);
            }
        });
        this.customPanel.setLayout(new BorderLayout());
        this.languageCombo.setModel(new DefaultComboBoxModel<LanguageDescription>(mimeTypes));
        if (mimeTypes.length > 0) {
            this.languageCombo.setSelectedIndex(0);
        }
        this.languageCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerProjectHintsPanelUI.this.change();
            }
        });
        this.searchEnableDisable();
    }

    public void setPerProjectSettings(PerProjectHintsPanel.MimeType2Preferences preferences) {
        this.preferencesProvider = preferences;
        this.mimeType2OptionsPanel.clear();
        this.change();
    }

    public void setGlobalSettings() {
        this.preferencesProvider = this.globalPreferencesProvider;
        this.mimeType2OptionsPanel.clear();
        this.change();
    }

    private void change() {
        final LanguageDescription mimeType = (LanguageDescription)this.languageCombo.getSelectedItem();
        this.customPanel.removeAll();
        if (mimeType != null) {
            JComponent panel = this.mimeType2OptionsPanel.get(mimeType);
            if (panel == null) {
                OptionsPanelController c = this.mimeType2OptionsController.get(mimeType);
                panel = c.getComponent(Lookups.fixed((Object[])new Object[]{this.preferencesProvider.getPreferences(mimeType.mimeType), OptionsFilter.create((Document)this.searchText.getDocument(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PerProjectHintsPanelUI.this.supportsFiltering.add(mimeType.mimeType);
                        PerProjectHintsPanelUI.this.searchEnableDisable();
                    }
                })}));
                this.mimeType2OptionsPanel.put(mimeType, panel);
                c.update();
            }
            this.customPanel.add((Component)panel, "Center");
        }
        this.customPanel.invalidate();
        this.customPanel.revalidate();
    }

    private static String getFileObjectLocalizedName(FileObject fo, String mimeType) {
        Object o = fo.getAttribute("SystemFileSystem.localizingBundle");
        if (o instanceof String) {
            String bundleName = (String)o;
            try {
                ResourceBundle rb = NbBundle.getBundle((String)bundleName);
                String localizedName = rb.getString(mimeType);
                return localizedName;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return mimeType;
    }

    private void searchEnableDisable() {
        this.searchText.setEnabled(this.supportsFiltering.contains(((LanguageDescription)this.languageCombo.getSelectedItem()).mimeType));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.languageCombo = new JComboBox();
        this.jLabel2 = new JLabel();
        this.searchText = new JTextField();
        this.customPanel = new JPanel();
        this.jLabel1.setLabelFor(this.languageCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(PerProjectHintsPanelUI.class, (String)"PerProjectHintsPanelUI.jLabel1.text"));
        this.languageCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.languageCombo.setPrototypeDisplayValue("9999999999");
        this.jLabel2.setLabelFor(this.searchText);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(PerProjectHintsPanelUI.class, (String)"PerProjectHintsPanelUI.jLabel2.text"));
        this.searchText.setColumns(10);
        this.searchText.setText(NbBundle.getMessage(PerProjectHintsPanelUI.class, (String)"PerProjectHintsPanelUI.searchText.text"));
        GroupLayout customPanelLayout = new GroupLayout(this.customPanel);
        this.customPanel.setLayout(customPanelLayout);
        customPanelLayout.setHorizontalGroup(customPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        customPanelLayout.setVerticalGroup(customPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 270, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.languageCombo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 61, Short.MAX_VALUE).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchText, -2, -1, -2)).addComponent(this.customPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.languageCombo, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.searchText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.customPanel, -1, -1, Short.MAX_VALUE)));
    }

    public void applyChanges() {
        for (Map.Entry<LanguageDescription, OptionsPanelController> e : this.mimeType2OptionsController.entrySet()) {
            e.getValue().applyChanges();
        }
    }

    private static final class LanguageDescription {
        public final String mimeType;
        public final String displayName;

        public LanguageDescription(String mimeType, String displayName) {
            this.mimeType = mimeType;
            this.displayName = displayName;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

