/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.winsys;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.WizardUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.NewTCIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class NameAndLocationPanel
extends BasicWizardIterator.Panel {
    private NewTCIterator.DataModel data;
    private JButton btnIcon;
    private JComboBox comPackageName;
    private JLabel createdFiles;
    private JTextArea createdFilesValue;
    private JLabel filler;
    private JLabel lblIcon;
    private JLabel lblPackageName;
    private JLabel lblPrefix;
    private JLabel lblProjectName;
    private JLabel modifiedFiles;
    private JTextArea modifiedFilesValue;
    private JTextField txtIcon;
    private JTextField txtPrefix;
    private JTextField txtProjectName;

    public NameAndLocationPanel(WizardDescriptor setting, NewTCIterator.DataModel data) {
        super(setting);
        this.data = data;
        this.initComponents();
        this.initAccessibility();
        this.putClientProperty("NewFileWizard_Title", NameAndLocationPanel.getMessage("LBL_TCWizardTitle"));
        UIUtil.DocumentAdapter dListener = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                if (NameAndLocationPanel.this.checkValidity()) {
                    NameAndLocationPanel.this.updateData();
                }
            }
        };
        this.txtPrefix.getDocument().addDocumentListener((DocumentListener)dListener);
        this.txtIcon.getDocument().addDocumentListener((DocumentListener)dListener);
        if (this.comPackageName.getEditor().getEditorComponent() instanceof JTextField) {
            JTextField txt = (JTextField)this.comPackageName.getEditor().getEditorComponent();
            txt.getDocument().addDocumentListener((DocumentListener)dListener);
        }
    }

    @Override
    protected void storeToDataModel() {
        this.updateData();
    }

    private void updateData() {
        this.data.setPackageName(this.comPackageName.getEditor().getItem().toString());
        String icon = this.txtIcon.getText().trim();
        this.data.setIcon(icon.length() == 0 ? (String)null : icon);
        this.data.setName(this.txtPrefix.getText().trim());
        NewTCIterator.generateFileChanges(this.data);
        this.createdFilesValue.setText(WizardUtils.generateTextAreaContent(this.data.getCreatedModifiedFiles().getCreatedPaths()));
        this.modifiedFilesValue.setText(WizardUtils.generateTextAreaContent(this.data.getCreatedModifiedFiles().getModifiedPaths()));
        String[] invalid = this.data.getCreatedModifiedFiles().getInvalidPaths();
        if (invalid.length > 0) {
            this.setError(NbBundle.getMessage(NameAndLocationPanel.class, (String)"ERR_ToBeCreateFileExists", (Object)invalid[0]));
        }
    }

    private void clearCreatedAndModifiedFilesTextArea() {
        this.createdFilesValue.setText(null);
        this.modifiedFilesValue.setText(null);
    }

    @Override
    protected void readFromDataModel() {
        this.txtPrefix.setText(this.data.getName());
        this.txtIcon.setText(this.data.getIcon());
        if (this.data.getPackageName() != null) {
            this.comPackageName.setSelectedItem(this.data.getPackageName());
        }
        this.checkValidity();
    }

    @Override
    protected String getPanelName() {
        return NameAndLocationPanel.getMessage("LBL_NameLocation_Title");
    }

    private boolean checkValidity() {
        File fil;
        if (this.txtPrefix.getText().trim().length() == 0) {
            this.setInfo(NameAndLocationPanel.getMessage("ERR_Name_Prefix_Empty"), false);
            this.clearCreatedAndModifiedFilesTextArea();
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)this.txtPrefix.getText().trim())) {
            this.setError(NameAndLocationPanel.getMessage("ERR_Name_Prefix_Invalid"));
            return false;
        }
        String path = this.txtIcon.getText().trim();
        if (path.length() != 0 && !(fil = new File(path)).exists()) {
            this.setError(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ERR_Icon_Invalid"));
            return false;
        }
        String packageName = this.comPackageName.getEditor().getItem().toString().trim();
        if (packageName.length() == 0 || !WizardUtils.isValidPackageName(packageName)) {
            this.setError(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ERR_Package_Invalid"));
            return false;
        }
        this.markValid();
        return true;
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(NameAndLocationPanel.class);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(NameAndLocationPanel.class, (String)key);
    }

    private void initComponents() {
        this.lblPrefix = new JLabel();
        this.txtPrefix = new JTextField();
        this.lblIcon = new JLabel();
        this.txtIcon = new JTextField();
        this.btnIcon = new JButton();
        this.lblProjectName = new JLabel();
        this.txtProjectName = new JTextField(ProjectUtils.getInformation((Project)this.data.getProject()).getDisplayName());
        this.lblPackageName = new JLabel();
        this.comPackageName = WizardUtils.createPackageComboBox(this.data.getSourceRootGroup());
        this.createdFiles = new JLabel();
        this.modifiedFiles = new JLabel();
        this.filler = new JLabel();
        this.createdFilesValue = new JTextArea();
        this.modifiedFilesValue = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.lblPrefix.setLabelFor(this.txtPrefix);
        Mnemonics.setLocalizedText((JLabel)this.lblPrefix, (String)NbBundle.getMessage(NameAndLocationPanel.class, (String)"LBL_Prefix"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 0, 6, 12);
        this.add(this.lblPrefix, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 6, 0);
        this.add(this.txtPrefix, gridBagConstraints);
        this.lblIcon.setLabelFor(this.txtIcon);
        Mnemonics.setLocalizedText((JLabel)this.lblIcon, (String)NbBundle.getMessage(NameAndLocationPanel.class, (String)"LBL_Icon"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add(this.lblIcon, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.txtIcon, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.btnIcon, (String)NbBundle.getMessage(NameAndLocationPanel.class, (String)"LBL_Icon_Browse"));
        this.btnIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NameAndLocationPanel.this.btnIconActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add(this.btnIcon, gridBagConstraints);
        this.lblProjectName.setLabelFor(this.txtProjectName);
        Mnemonics.setLocalizedText((JLabel)this.lblProjectName, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_ProjectName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(18, 0, 6, 12);
        this.add(this.lblProjectName, gridBagConstraints);
        this.txtProjectName.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 6, 0);
        this.add(this.txtProjectName, gridBagConstraints);
        this.lblPackageName.setLabelFor(this.comPackageName);
        Mnemonics.setLocalizedText((JLabel)this.lblPackageName, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_PackageName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add(this.lblPackageName, gridBagConstraints);
        this.comPackageName.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.comPackageName, gridBagConstraints);
        this.createdFiles.setLabelFor(this.createdFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.createdFiles, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(36, 0, 6, 12);
        this.add(this.createdFiles, gridBagConstraints);
        this.modifiedFiles.setLabelFor(this.modifiedFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFiles, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add(this.modifiedFiles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.filler, gridBagConstraints);
        this.createdFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.createdFilesValue.setColumns(20);
        this.createdFilesValue.setEditable(false);
        this.createdFilesValue.setRows(5);
        this.createdFilesValue.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(36, 0, 6, 0);
        this.add(this.createdFilesValue, gridBagConstraints);
        this.modifiedFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.modifiedFilesValue.setColumns(20);
        this.modifiedFilesValue.setEditable(false);
        this.modifiedFilesValue.setRows(5);
        this.modifiedFilesValue.setToolTipText("modifiedFilesValue");
        this.modifiedFilesValue.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.modifiedFilesValue, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_NameAndLocationPanel"));
        this.comPackageName.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_PackageName"));
        this.txtIcon.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_Icon"));
        this.txtPrefix.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_Prefix"));
        this.btnIcon.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_IconButton"));
        this.txtProjectName.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_ProjectName"));
        this.createdFilesValue.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_CreatedFilesValue"));
        this.modifiedFilesValue.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_CTL_ModifiedFilesValue"));
    }

    private void btnIconActionPerformed(ActionEvent evt) {
        JFileChooser chooser = WizardUtils.getIconFileChooser(this.txtIcon.getText());
        int ret = chooser.showDialog((Component)((Object)this), NameAndLocationPanel.getMessage("LBL_Select"));
        if (ret == 0) {
            File file = chooser.getSelectedFile();
            this.txtIcon.setText(file.getAbsolutePath());
        }
    }
}

