/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.common.WizardUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor.CreatedModifiedFilesProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor.NewLibraryDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class NameAndLocationPanel
extends BasicWizardIterator.Panel {
    private NewLibraryDescriptor.DataModel data;
    private JLabel createdFiles;
    private JTextArea createdFilesValue;
    private JScrollPane createdFilesValueS;
    private JLabel libraryDisplayName;
    private JTextField libraryDisplayNameValue;
    private JLabel libraryName;
    private JTextField libraryNameVale;
    private JLabel modifiedFiles;
    private JTextArea modifiedFilesValue;
    private JScrollPane modifiedFilesValueS;
    private JLabel projectName;
    private JTextField projectNameValue;

    public NameAndLocationPanel(WizardDescriptor setting, NewLibraryDescriptor.DataModel data) {
        super(setting);
        this.data = data;
        this.initComponents();
        this.initAccessibility();
        this.putClientProperty("NewFileWizard_Title", NbBundle.getMessage(NameAndLocationPanel.class, (String)"LBL_LibraryWizardTitle"));
        UIUtil.DocumentAdapter dListener = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                NewLibraryDescriptor.DataModel _data = NameAndLocationPanel.this.getTemporaryDataModel();
                NameAndLocationPanel.this.setEnabledForFilesInfo(NameAndLocationPanel.this.checkValidity(_data));
                NameAndLocationPanel.this.setFilesInfoIntoTextAreas(_data);
            }
        };
        this.libraryNameVale.getDocument().addDocumentListener((DocumentListener)dListener);
        this.libraryDisplayNameValue.getDocument().addDocumentListener((DocumentListener)dListener);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(NameAndLocationPanel.class, (String)key);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_NameIconLocationPanel"));
        this.createdFilesValue.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_LBL_CreatedFiles"));
        this.modifiedFilesValue.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_LBL_ModifiedFiles"));
        this.libraryDisplayNameValue.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_LBL_DisplayName"));
        this.libraryNameVale.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_LBL_Name"));
        this.projectNameValue.getAccessibleContext().setAccessibleDescription(NameAndLocationPanel.getMessage("ACS_LBL_ProjectName"));
    }

    @Override
    protected void storeToDataModel() {
        NewLibraryDescriptor.DataModel _temp = this.getTemporaryDataModel();
        this.data.setLibraryName(_temp.getLibraryName());
        this.data.setLibraryDisplayName(_temp.getLibraryDisplayName());
        this.data.setCreatedModifiedFiles(_temp.getCreatedModifiedFiles());
    }

    private NewLibraryDescriptor.DataModel getTemporaryDataModel() {
        NewLibraryDescriptor.DataModel _temp = this.data.cloneMe(this.getSettings());
        _temp.setLibraryName(this.libraryNameVale.getText());
        _temp.setLibraryDisplayName(this.libraryDisplayNameValue.getText());
        if (_temp.isValidLibraryDisplayName() && _temp.isValidLibraryName()) {
            CreatedModifiedFiles files = CreatedModifiedFilesProvider.createInstance(_temp);
            _temp.setCreatedModifiedFiles(files);
        }
        return _temp;
    }

    private void setEnabledForFilesInfo(boolean enabled) {
        this.createdFilesValue.setEnabled(enabled);
        this.modifiedFilesValue.setEnabled(enabled);
    }

    private void setFilesInfoIntoTextAreas(NewLibraryDescriptor.DataModel _temp) {
        if (_temp.getCreatedModifiedFiles() != null) {
            this.createdFilesValue.setText(WizardUtils.generateTextAreaContent(_temp.getCreatedModifiedFiles().getCreatedPaths()));
            this.modifiedFilesValue.setText(WizardUtils.generateTextAreaContent(_temp.getCreatedModifiedFiles().getModifiedPaths()));
        }
    }

    @Override
    protected void readFromDataModel() {
        this.libraryNameVale.setText(this.data.getLibrary().getName());
        this.libraryDisplayNameValue.setText(this.data.getLibrary().getDisplayName());
        this.checkValidity(this.getTemporaryDataModel());
    }

    @Override
    protected String getPanelName() {
        return NbBundle.getMessage(NameAndLocationPanel.class, (String)"LBL_NameAndLocation_Title");
    }

    private boolean checkValidity(NewLibraryDescriptor.DataModel _data) {
        if (!_data.isValidLibraryName()) {
            this.setError(NbBundle.getMessage(NameAndLocationPanel.class, (String)"ERR_InvalidName"));
            return false;
        }
        if (!_data.isValidLibraryDisplayName()) {
            this.setError(NbBundle.getMessage(NameAndLocationPanel.class, (String)"ERR_EmptyDescName"));
            return false;
        }
        if (_data.libraryAlreadyExists()) {
            this.setError(NbBundle.getMessage(NameAndLocationPanel.class, (String)"ERR_LibraryExists", (Object)_data.getLibraryName()));
            return false;
        }
        this.markValid();
        return true;
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(NameAndLocationPanel.class);
    }

    public void addNotify() {
        super.addNotify();
        this.checkValidity(this.getTemporaryDataModel());
    }

    private void initComponents() {
        this.libraryName = new JLabel();
        this.libraryNameVale = new JTextField();
        this.libraryDisplayName = new JLabel();
        this.libraryDisplayNameValue = new JTextField();
        this.projectName = new JLabel();
        this.projectNameValue = new JTextField(ProjectUtils.getInformation((Project)this.data.getProject()).getDisplayName());
        this.createdFiles = new JLabel();
        this.modifiedFiles = new JLabel();
        this.createdFilesValueS = new JScrollPane();
        this.createdFilesValue = new JTextArea();
        this.modifiedFilesValueS = new JScrollPane();
        this.modifiedFilesValue = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.libraryName.setLabelFor(this.libraryNameVale);
        Mnemonics.setLocalizedText((JLabel)this.libraryName, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_LibraryName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 0, 6, 12);
        this.add(this.libraryName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 0, 6, 0);
        this.add(this.libraryNameVale, gridBagConstraints);
        this.libraryDisplayName.setLabelFor(this.libraryDisplayNameValue);
        Mnemonics.setLocalizedText((JLabel)this.libraryDisplayName, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_LibraryDisplayName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add(this.libraryDisplayName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.libraryDisplayNameValue, gridBagConstraints);
        this.projectName.setLabelFor(this.projectNameValue);
        Mnemonics.setLocalizedText((JLabel)this.projectName, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_ProjectName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(18, 0, 6, 12);
        this.add(this.projectName, gridBagConstraints);
        this.projectNameValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 6, 0);
        this.add(this.projectNameValue, gridBagConstraints);
        this.createdFiles.setLabelFor(this.createdFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.createdFiles, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(36, 0, 6, 12);
        this.add(this.createdFiles, gridBagConstraints);
        this.modifiedFiles.setLabelFor(this.modifiedFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFiles, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle").getString("LBL_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add(this.modifiedFiles, gridBagConstraints);
        this.createdFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.createdFilesValue.setColumns(20);
        this.createdFilesValue.setEditable(false);
        this.createdFilesValue.setRows(5);
        this.createdFilesValue.setBorder(null);
        this.createdFilesValueS.setViewportView(this.createdFilesValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(36, 0, 6, 0);
        this.add(this.createdFilesValueS, gridBagConstraints);
        this.modifiedFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.modifiedFilesValue.setColumns(20);
        this.modifiedFilesValue.setEditable(false);
        this.modifiedFilesValue.setRows(5);
        this.modifiedFilesValue.setToolTipText("modifiedFilesValue");
        this.modifiedFilesValue.setBorder(null);
        this.modifiedFilesValueS.setViewportView(this.modifiedFilesValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.modifiedFilesValueS, gridBagConstraints);
    }
}

