/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.atoum.ui.options;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.atoum.options.AtoumOptions;
import org.netbeans.modules.php.atoum.options.AtoumOptionsValidator;
import org.netbeans.modules.php.atoum.ui.options.AtoumOptionsPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class AtoumOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    static final String ID = "atoum";
    public static final String OPTIONS_SUB_PATH = "FrameworksAndTools/atoum";
    public static final String OPTIONS_PATH = "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/FrameworksAndTools/atoum";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private AtoumOptionsPanel atoumOptionsPanel = null;
    private volatile boolean changed = false;
    private boolean firstOpening = true;

    public void update() {
        assert (EventQueue.isDispatchThread());
        if (this.firstOpening || !this.isChanged()) {
            this.firstOpening = false;
            this.getPanel().setAtoumPath(this.getAtoumOptions().getAtoumPath());
        }
        this.changed = false;
    }

    public void applyChanges() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AtoumOptionsPanelController.this.getAtoumOptions().setAtoumPath(AtoumOptionsPanelController.this.getPanel().getAtoumPath());
                AtoumOptionsPanelController.this.changed = false;
            }
        });
    }

    public void cancel() {
        if (this.isChanged()) {
            this.getPanel().setAtoumPath(this.getAtoumOptions().getAtoumPath());
        }
    }

    public boolean isValid() {
        assert (EventQueue.isDispatchThread());
        AtoumOptionsPanel panel = this.getPanel();
        ValidationResult result = new AtoumOptionsValidator().validate(panel.getAtoumPath()).getResult();
        if (result.hasErrors()) {
            panel.setError(((ValidationResult.Message)result.getErrors().get(0)).getMessage());
            return false;
        }
        if (result.hasWarnings()) {
            panel.setWarning(((ValidationResult.Message)result.getWarnings().get(0)).getMessage());
            return true;
        }
        panel.setError(" ");
        return true;
    }

    public boolean isChanged() {
        String saved = this.getAtoumOptions().getAtoumPath();
        String current = this.getPanel().getAtoumPath().trim();
        return saved == null ? !current.isEmpty() : !saved.equals(current);
    }

    public JComponent getComponent(Lookup masterLookup) {
        assert (EventQueue.isDispatchThread());
        return this.getPanel();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.atoum.ui.options.AtoumOptionsPanelController");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }

    private AtoumOptionsPanel getPanel() {
        assert (EventQueue.isDispatchThread());
        if (this.atoumOptionsPanel == null) {
            this.atoumOptionsPanel = new AtoumOptionsPanel();
            this.atoumOptionsPanel.addChangeListener(this);
        }
        return this.atoumOptionsPanel;
    }

    private AtoumOptions getAtoumOptions() {
        return AtoumOptions.getInstance();
    }
}

