/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.input.QuickPickItem;
import org.netbeans.modules.java.lsp.server.input.ShowQuickPickParams;
import org.netbeans.modules.java.lsp.server.protocol.Bundle;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.filesystems.FileObject;

public final class ImplementOverrideMethodGenerator
extends CodeActionsProvider {
    private static final String URI = "uri";
    private static final String OFFSET = "offset";
    private static final String IS_IMPLEMET = "isImplement";
    private static final String METHODS = "methods";
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(NbCodeLanguageClient client, ResultIterator resultIterator, CodeActionParams params) throws Exception {
        CompilationController info;
        List only = params.getContext().getOnly();
        if (only == null || !only.contains("source")) {
            return Collections.emptyList();
        }
        CompilationController compilationController = info = resultIterator.getParserResult() != null ? CompilationController.get((Parser.Result)resultIterator.getParserResult()) : null;
        if (info == null) {
            return Collections.emptyList();
        }
        info.toPhase(JavaSource.Phase.RESOLVED);
        int offset = ImplementOverrideMethodGenerator.getOffset((CompilationInfo)info, params.getRange().getStart());
        TreePath tp = info.getTreeUtilities().pathFor(offset);
        tp = info.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
        if (tp == null) {
            return Collections.emptyList();
        }
        TypeElement typeElement = (TypeElement)info.getTrees().getElement(tp);
        if (typeElement == null || typeElement.getKind() == ElementKind.ANNOTATION_TYPE) {
            return Collections.emptyList();
        }
        ArrayList<CodeAction> result = new ArrayList<CodeAction>();
        String uri = Utils.toUri(info.getFileObject());
        ElementUtilities eu = info.getElementUtilities();
        if (typeElement.getKind().isClass() || typeElement.getKind().isInterface() && SourceVersion.RELEASE_8.compareTo(info.getSourceVersion()) <= 0) {
            ArrayList<QuickPickItem> implementMethods = new ArrayList<QuickPickItem>();
            for (ExecutableElement method : eu.findUnimplementedMethods(typeElement, true)) {
                boolean mustImplement = !method.getModifiers().contains((Object)Modifier.DEFAULT);
                Element enclosingElement = method.getEnclosingElement();
                String enclosingTypeName = enclosingElement.getKind().isClass() || enclosingElement.getKind().isInterface() ? Bundle.DN_From(((TypeElement)enclosingElement).getQualifiedName().toString()) : null;
                implementMethods.add(new QuickPickItem(ImplementOverrideMethodGenerator.createLabel((CompilationInfo)info, method), enclosingTypeName, null, mustImplement, new CodeActionsProvider.ElementData(method)));
            }
            if (!implementMethods.isEmpty()) {
                result.add(this.createCodeAction(client, Bundle.DN_GenerateImplementMethod(), "source.generate", ImplementOverrideMethodGenerator.data(uri, offset, true, implementMethods), "workbench.action.focusActiveEditorGroup", new Object[0]));
            }
        }
        if (typeElement.getKind().isClass() || typeElement.getKind().isInterface()) {
            ArrayList<QuickPickItem> overrideMethods = new ArrayList<QuickPickItem>();
            for (ExecutableElement method : eu.findOverridableMethods(typeElement)) {
                Element enclosingElement = method.getEnclosingElement();
                String enclosingTypeName = enclosingElement.getKind().isClass() || enclosingElement.getKind().isInterface() ? Bundle.DN_From(((TypeElement)enclosingElement).getQualifiedName().toString()) : null;
                QuickPickItem item = new QuickPickItem(ImplementOverrideMethodGenerator.createLabel((CompilationInfo)info, method));
                if (enclosingTypeName != null) {
                    item.setDescription(enclosingTypeName);
                }
                item.setUserData(new CodeActionsProvider.ElementData(method));
                overrideMethods.add(item);
            }
            if (!overrideMethods.isEmpty()) {
                result.add(this.createCodeAction(client, Bundle.DN_GenerateOverrideMethod(), "source.generate", ImplementOverrideMethodGenerator.data(uri, offset, false, overrideMethods), "workbench.action.focusActiveEditorGroup", new Object[0]));
            }
        }
        return result;
    }

    @Override
    public CompletableFuture<CodeAction> resolve(NbCodeLanguageClient client, CodeAction codeAction, Object data) {
        CompletableFuture<CodeAction> future = new CompletableFuture<CodeAction>();
        try {
            String uri = ((JsonObject)data).getAsJsonPrimitive(URI).getAsString();
            int offset = ((JsonObject)data).getAsJsonPrimitive(OFFSET).getAsInt();
            boolean isImplement = ((JsonObject)data).getAsJsonPrimitive(IS_IMPLEMET).getAsBoolean();
            List<QuickPickItem> methods = Arrays.asList((QuickPickItem[])this.gson.fromJson(((JsonObject)data).get(METHODS), QuickPickItem[].class));
            String title = isImplement ? Bundle.DN_GenerateImplementMethod() : Bundle.DN_GenerateOverrideMethod();
            String text = isImplement ? Bundle.DN_SelectImplementMethod() : Bundle.DN_SelectOverrideMethod();
            client.showQuickPick(new ShowQuickPickParams(title, text, true, methods)).thenAccept(selected -> {
                try {
                    WorkspaceEdit edit;
                    if (selected != null && !selected.isEmpty() && (edit = this.generate(uri, offset, isImplement, (List<QuickPickItem>)selected)) != null) {
                        codeAction.setEdit(edit);
                    }
                    future.complete(codeAction);
                }
                catch (IOException | IllegalArgumentException ex) {
                    future.completeExceptionally(ex);
                }
            });
        }
        catch (JsonSyntaxException ex) {
            future.completeExceptionally(ex);
        }
        return future;
    }

    private WorkspaceEdit generate(String uri, int offset, boolean isImplement, List<QuickPickItem> methods) throws IOException, IllegalArgumentException {
        FileObject file = Utils.fromUri(uri);
        JavaSource js = JavaSource.forFileObject((FileObject)file);
        if (js == null) {
            throw new IOException("Cannot get JavaSource for: " + uri);
        }
        List<TextEdit> edits = TextDocumentServiceImpl.modify2TextEdits(js, (Task<WorkingCopy>)((Task)wc -> {
            wc.toPhase(JavaSource.Phase.RESOLVED);
            TreePath tp = wc.getTreeUtilities().pathFor(offset);
            tp = wc.getTreeUtilities().getPathElementOfKind(TreeUtilities.CLASS_TREE_KINDS, tp);
            if (tp != null) {
                List selectedMethods = methods.stream().map(item -> {
                    CodeActionsProvider.ElementData data = (CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(item.getUserData()), CodeActionsProvider.ElementData.class);
                    return (ExecutableElement)data.resolve((CompilationInfo)wc);
                }).collect(Collectors.toList());
                if (isImplement) {
                    GeneratorUtils.generateAbstractMethodImplementations((WorkingCopy)wc, (TreePath)tp, selectedMethods, (int)-1);
                } else {
                    GeneratorUtils.generateMethodOverrides((WorkingCopy)wc, (TreePath)tp, selectedMethods, (int)-1);
                }
            }
        }));
        return edits == null ? null : new WorkspaceEdit(Collections.singletonMap(uri, edits));
    }

    private static Map<String, Object> data(String uri, int offset, boolean isImplement, List<QuickPickItem> methods) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(URI, uri);
        data.put(OFFSET, offset);
        data.put(IS_IMPLEMET, isImplement);
        data.put(METHODS, methods);
        return data;
    }
}

