/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.db;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.net.URL;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.java.lsp.server.db.Bundle;
import org.netbeans.modules.java.lsp.server.input.InputBoxStep;
import org.netbeans.modules.java.lsp.server.input.InputCallbackParams;
import org.netbeans.modules.java.lsp.server.input.InputService;
import org.netbeans.modules.java.lsp.server.input.QuickPickItem;
import org.netbeans.modules.java.lsp.server.input.QuickPickStep;
import org.netbeans.modules.java.lsp.server.input.ShowMutliStepInputParams;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;

public class DBAddConnection
extends CodeActionsProvider {
    public static final String DB_ADD_CONNECTION = "nbls.db.add.connection";
    public static final String USER_ID = "userId";
    public static final String PASSWORD = "password";
    public static final String DRIVER = "driver";
    public static final String DB_URL = "url";
    public static final String SCHEMA = "schema";
    public static final String DISPLAY_NAME = "displayName";
    private static final Map<String, String> urlTemplates = new HashMap<String, String>();
    private final Gson gson = new Gson();

    @Override
    public CompletableFuture<Object> processCommand(final NbCodeLanguageClient client, String command, List<Object> arguments) {
        InputService.Registry inputServiceRegistry = (InputService.Registry)Lookup.getDefault().lookup(InputService.Registry.class);
        if (inputServiceRegistry == null) {
            return null;
        }
        if (arguments != null && !arguments.isEmpty()) {
            String driverClass;
            Map m = arguments.get(0) instanceof JsonNull ? Collections.emptyMap() : (Map)this.gson.fromJson((JsonElement)((JsonObject)arguments.get(0)), Map.class);
            String userId = m != null ? (String)m.get(USER_ID) : null;
            String password = m != null ? (String)m.get(PASSWORD) : null;
            String dbUrl = m != null ? (String)m.get(DB_URL) : null;
            String string = driverClass = m != null ? (String)m.get(DRIVER) : null;
            if (dbUrl != null && driverClass != null) {
                JDBCDriver[] driver = JDBCDriverManager.getDefault().getDrivers(driverClass);
                if (driver != null && driver.length > 0) {
                    if (userId == null || password == null) {
                        String inputId = inputServiceRegistry.registerInput(param -> {
                            int totalSteps = 2;
                            switch (param.getStep()) {
                                case 1: {
                                    String userIdVal = userId != null ? userId : "";
                                    return CompletableFuture.completedFuture(Either.forRight((Object)new InputBoxStep(totalSteps, USER_ID, Bundle.MSG_EnterUsername(), userIdVal)));
                                }
                                case 2: {
                                    Map<String, Either<List<QuickPickItem>, String>> data = param.getData();
                                    Either<List<QuickPickItem>, String> userData = data.get(USER_ID);
                                    if (userData != null) {
                                        String passwordVal = password != null ? password : "";
                                        return CompletableFuture.completedFuture(Either.forRight((Object)new InputBoxStep(totalSteps, PASSWORD, null, Bundle.MSG_EnterPassword(), passwordVal, true)));
                                    }
                                    return CompletableFuture.completedFuture(null);
                                }
                            }
                            return CompletableFuture.completedFuture(null);
                        });
                        client.showMultiStepInput(new ShowMutliStepInputParams(inputId, Bundle.MSG_AddDBConnection())).thenAccept(result -> {
                            Either userData = (Either)result.get(USER_ID);
                            Either passwordData = (Either)result.get(PASSWORD);
                            DatabaseConnection dbconn = DatabaseConnection.create((JDBCDriver)driver[0], (String)dbUrl, (String)((String)userData.getRight()), (String)((String)m.get(SCHEMA)), (String)((String)passwordData.getRight()), (boolean)true, (String)((String)m.get(DISPLAY_NAME)));
                            try {
                                ConnectionManager.getDefault().addConnection(dbconn);
                                client.showMessage(new MessageParams(MessageType.Info, Bundle.MSG_ConnectionAdded()));
                            }
                            catch (DatabaseException ex) {
                                client.showMessage(new MessageParams(MessageType.Error, ex.getMessage()));
                            }
                        });
                    } else {
                        DatabaseConnection dbconn = DatabaseConnection.create((JDBCDriver)driver[0], (String)dbUrl, (String)userId, (String)((String)m.get(SCHEMA)), (String)password, (boolean)true, (String)((String)m.get(DISPLAY_NAME)));
                        try {
                            ConnectionManager.getDefault().addConnection(dbconn);
                            client.showMessage(new MessageParams(MessageType.Info, Bundle.MSG_ConnectionAdded()));
                        }
                        catch (DatabaseException ex) {
                            client.showMessage(new MessageParams(MessageType.Error, ex.getMessage()));
                        }
                    }
                }
                return CompletableFuture.completedFuture(null);
            }
        }
        final JDBCDriver[] drivers = JDBCDriverManager.getDefault().getDrivers();
        final ArrayList<QuickPickItem> items = new ArrayList<QuickPickItem>();
        for (int i = 0; i < drivers.length; ++i) {
            FileObject jarFO;
            URL[] jars = drivers[i].getURLs();
            if (jars == null || jars.length <= 0 || (jarFO = URLMapper.findFileObject((URL)jars[0])) == null || !jarFO.isValid()) continue;
            items.add(new QuickPickItem(drivers[i].getName(), null, drivers[i].getDisplayName() + " (" + drivers[i].getClassName() + ")", false, i));
        }
        if (!items.isEmpty()) {
            final ArrayList schemas = new ArrayList();
            String inputId = inputServiceRegistry.registerInput(new InputService.Callback(){

                @Override
                public CompletableFuture<Either<QuickPickStep, InputBoxStep>> step(InputCallbackParams params) {
                    Map<String, Either<List<QuickPickItem>, String>> data = params.getData();
                    int totalSteps = 4;
                    switch (params.getStep()) {
                        case 1: {
                            return CompletableFuture.completedFuture(Either.forLeft((Object)new QuickPickStep(totalSteps, DBAddConnection.DRIVER, Bundle.MSG_SelectDriver(), (List<QuickPickItem>)items)));
                        }
                        case 2: {
                            Either<List<QuickPickItem>, String> driverData = data.get(DBAddConnection.DRIVER);
                            if (driverData != null && !((List)driverData.getLeft()).isEmpty()) {
                                String urlTemplate;
                                int i = ((Double)((QuickPickItem)((List)driverData.getLeft()).get(0)).getUserData()).intValue();
                                JDBCDriver driver = drivers[i];
                                String string = urlTemplate = driver.getClassName() != null ? (String)urlTemplates.get(driver.getClassName()) : "";
                                if (urlTemplate == null) {
                                    urlTemplate = "";
                                }
                                return CompletableFuture.completedFuture(Either.forRight((Object)new InputBoxStep(totalSteps, DBAddConnection.DB_URL, Bundle.MSG_EnterDbUrl(), urlTemplate)));
                            }
                            return CompletableFuture.completedFuture(null);
                        }
                        case 3: {
                            Either<List<QuickPickItem>, String> urlData = data.get(DBAddConnection.DB_URL);
                            if (urlData != null && !((String)urlData.getRight()).isEmpty()) {
                                return CompletableFuture.completedFuture(Either.forRight((Object)new InputBoxStep(totalSteps, DBAddConnection.USER_ID, Bundle.MSG_EnterUsername(), "")));
                            }
                            return CompletableFuture.completedFuture(null);
                        }
                        case 4: {
                            Either<List<QuickPickItem>, String> userData = data.get(DBAddConnection.USER_ID);
                            if (userData != null && !((String)userData.getRight()).isEmpty()) {
                                return CompletableFuture.completedFuture(Either.forRight((Object)new InputBoxStep(totalSteps, DBAddConnection.PASSWORD, null, Bundle.MSG_EnterPassword(), "", true)));
                            }
                            return CompletableFuture.completedFuture(null);
                        }
                        case 5: {
                            Either<List<QuickPickItem>, String> passwordData = data.get(DBAddConnection.PASSWORD);
                            if (passwordData != null) {
                                if (schemas.isEmpty()) {
                                    client.showMessage(new MessageParams(MessageType.Info, Bundle.MSG_ConnectionAdded()));
                                    return CompletableFuture.completedFuture(null);
                                }
                                List<QuickPickItem> schemaItems = schemas.stream().map(schema -> new QuickPickItem((String)schema)).collect(Collectors.toList());
                                return CompletableFuture.completedFuture(Either.forLeft((Object)new QuickPickStep(totalSteps + 1, DBAddConnection.SCHEMA, Bundle.MSG_SelectSchema(), schemaItems)));
                            }
                            return CompletableFuture.completedFuture(null);
                        }
                    }
                    return CompletableFuture.completedFuture(null);
                }

                /*
                 * Exception decompiling
                 */
                @Override
                public CompletableFuture<String> validate(InputCallbackParams params) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
            return client.showMultiStepInput(new ShowMutliStepInputParams(inputId, Bundle.MSG_AddDBConnection())).thenApply(result -> {
                Either driverData = (Either)result.get(DRIVER);
                Either urlData = (Either)result.get(DB_URL);
                Either userData = (Either)result.get(USER_ID);
                Either passwordData = (Either)result.get(PASSWORD);
                Either schemaData = (Either)result.get(SCHEMA);
                if (driverData != null && urlData != null && userData != null && passwordData != null && schemaData != null && !((List)schemaData.getLeft()).isEmpty()) {
                    int i = ((Double)((QuickPickItem)((List)driverData.getLeft()).get(0)).getUserData()).intValue();
                    JDBCDriver driver = drivers[i];
                    String schema = ((QuickPickItem)((List)schemaData.getLeft()).get(0)).getLabel();
                    DatabaseConnection dbconn = DatabaseConnection.create((JDBCDriver)driver, (String)((String)urlData.getRight()), (String)((String)userData.getRight()), (String)schema, (String)((String)passwordData.getRight()), (boolean)true);
                    try {
                        ConnectionManager.getDefault().addConnection(dbconn);
                    }
                    catch (DatabaseException ex) {
                        client.showMessage(new MessageParams(MessageType.Error, ex.getMessage()));
                    }
                    client.showMessage(new MessageParams(MessageType.Info, Bundle.MSG_ConnectionAdded()));
                }
                return null;
            });
        }
        client.showMessage(new MessageParams(MessageType.Error, Bundle.MSG_DriverNotFound()));
        return null;
    }

    private static List<String> getSchemas(DatabaseConnection dbconn) throws SQLException, DatabaseException {
        ResultSet rs;
        DatabaseMetaData dbMetaData;
        ArrayList<String> schemas = new ArrayList<String>();
        if (ConnectionManager.getDefault().connect(dbconn) && (dbMetaData = dbconn.getJDBCConnection().getMetaData()).supportsSchemasInTableDefinitions() && (rs = dbMetaData.getSchemas()) != null) {
            while (rs.next()) {
                schemas.add(rs.getString(1).trim());
            }
        }
        return schemas;
    }

    @Override
    public Set<String> getCommands() {
        return Collections.singleton(DB_ADD_CONNECTION);
    }

    @Override
    public List<CodeAction> getCodeActions(NbCodeLanguageClient client, ResultIterator resultIterator, CodeActionParams params) throws Exception {
        return Collections.emptyList();
    }

    static /* synthetic */ List access$100(DatabaseConnection x0) throws SQLException, DatabaseException {
        return DBAddConnection.getSchemas(x0);
    }

    static {
        urlTemplates.put("org.postgresql.Driver", "jdbc:postgresql://<HOST>:5432/<DB>");
        urlTemplates.put("org.gjt.mm.mysql.Driver", "jdbc:mysql://<HOST>:3306/<DB>");
        urlTemplates.put("com.mysql.cj.jdbc.Driver", "jdbc:mysql://<HOST>:3306/<DB>");
        urlTemplates.put("org.mariadb.jdbc.Driver", "jdbc:mariadb://<HOST>:3306/<DB>");
        urlTemplates.put("oracle.jdbc.OracleDriver", "jdbc:oracle:thin:@//<HOST>[:<PORT>][/<SERVICE>]");
        urlTemplates.put("com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver://<HOST>\\<DB>[:<PORT>]");
    }
}

