/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.ClassElement;
import com.oracle.js.parser.ir.Expression;
import com.oracle.js.parser.ir.IdentNode;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.PropertyNode;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.Collections;
import java.util.List;

public class ClassNode
extends Expression {
    private final IdentNode ident;
    private final Expression classHeritage;
    private final ClassElement constructor;
    private final List<ClassElement> classElements;
    private final List<Expression> decorators;
    private final int line;

    public ClassNode(int line, long token, int finish, IdentNode ident, Expression classHeritage, ClassElement constructor, List<ClassElement> classElements, List<Expression> decorators) {
        super(token, finish);
        this.line = line;
        this.ident = ident;
        this.classHeritage = classHeritage;
        this.constructor = constructor;
        this.classElements = classElements;
        this.decorators = decorators;
    }

    private ClassNode(ClassNode classNode, IdentNode ident, Expression classHeritage, ClassElement constructor, List<ClassElement> classElements, List<Expression> decorators) {
        super(classNode);
        this.line = classNode.getLineNumber();
        this.ident = ident;
        this.classHeritage = classHeritage;
        this.constructor = constructor;
        this.classElements = classElements;
        this.decorators = decorators;
    }

    public IdentNode getIdent() {
        return this.ident;
    }

    private ClassNode setIdent(IdentNode ident) {
        if (this.ident == ident) {
            return this;
        }
        return new ClassNode(this, ident, this.classHeritage, this.constructor, this.classElements, this.decorators);
    }

    public Expression getClassHeritage() {
        return this.classHeritage;
    }

    private ClassNode setClassHeritage(Expression classHeritage) {
        if (this.classHeritage == classHeritage) {
            return this;
        }
        return new ClassNode(this, this.ident, classHeritage, this.constructor, this.classElements, this.decorators);
    }

    public ClassElement getConstructor() {
        return this.constructor;
    }

    private ClassNode setConstructor(ClassElement constructor) {
        if (this.constructor == constructor) {
            return this;
        }
        return new ClassNode(this, this.ident, this.classHeritage, constructor, this.classElements, this.decorators);
    }

    public List<ClassElement> getClassElements() {
        return Collections.unmodifiableList(this.classElements);
    }

    private ClassNode setClassElements(List<ClassElement> classElements) {
        if (this.classElements == classElements) {
            return this;
        }
        return new ClassNode(this, this.ident, this.classHeritage, this.constructor, classElements, this.decorators);
    }

    public List<Expression> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    private ClassNode setDecorators(List<Expression> decorators) {
        if (this.decorators == decorators) {
            return this;
        }
        return new ClassNode(this, this.ident, this.classHeritage, this.constructor, this.classElements, decorators);
    }

    public int getLineNumber() {
        return this.line;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterClassNode(this)) {
            IdentNode newIdent = this.ident == null ? null : (IdentNode)this.ident.accept(visitor);
            Expression newClassHeritage = this.classHeritage == null ? null : (Expression)this.classHeritage.accept(visitor);
            ClassElement newConstructor = this.constructor == null ? null : (ClassElement)this.constructor.accept(visitor);
            return visitor.leaveClassNode(this.setIdent(newIdent).setClassHeritage(newClassHeritage).setConstructor(newConstructor).setClassElements(Node.accept(visitor, this.classElements)).setDecorators(Node.accept(visitor, this.decorators)));
        }
        return this;
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> visitor) {
        return visitor.enterClassNode(this);
    }

    @Override
    public void toString(StringBuilder sb, boolean printType) {
        sb.append("class");
        if (this.ident != null) {
            sb.append(' ');
            this.ident.toString(sb, printType);
        }
        if (this.classHeritage != null) {
            sb.append(" extends");
            this.classHeritage.toString(sb, printType);
        }
        sb.append(" {");
        if (this.constructor != null) {
            this.constructor.toString(sb, printType);
        }
        for (PropertyNode propertyNode : this.classElements) {
            sb.append(" ");
            propertyNode.toString(sb, printType);
        }
        sb.append("}");
    }
}

