/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.ui.tree;

import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.php.ui.tree.FileTreeElement;
import org.netbeans.modules.refactoring.php.ui.tree.FolderTreeElement;
import org.netbeans.modules.refactoring.php.ui.tree.ProjectTreeElement;
import org.netbeans.modules.refactoring.php.ui.tree.RefactoringTreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactoryImplementation;
import org.openide.filesystems.FileObject;

public class TreeElementFactoryImpl
implements TreeElementFactoryImplementation {
    public Map<Object, TreeElement> map = new WeakHashMap<Object, TreeElement>();

    public TreeElement getTreeElement(Object o) {
        Object result = o instanceof SourceGroup ? this.map.get(((SourceGroup)o).getRootFolder()) : this.map.get(o);
        if (result == null) {
            if (o instanceof FileObject) {
                FileObject fo = (FileObject)o;
                result = fo.isFolder() ? new FolderTreeElement(fo) : new FileTreeElement(fo);
            } else if (o instanceof Project) {
                result = new ProjectTreeElement((Project)o);
            } else if (o instanceof RefactoringElement) {
                RefactoringElement refactoringElement = (RefactoringElement)o;
                result = new RefactoringTreeElement(refactoringElement);
            }
            if (result != null) {
                if (o instanceof SourceGroup) {
                    this.map.put(((SourceGroup)o).getRootFolder(), (TreeElement)result);
                } else {
                    this.map.put(o, (TreeElement)result);
                }
            }
        }
        return result;
    }

    public void cleanUp() {
        this.map.clear();
    }
}

