/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.delete;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QuerySupportFactory;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.ConstantElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelFactory;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.openide.filesystems.FileObject;

public final class SafeDeleteSupport {
    private Collection<? extends ClassScope> declaredClasses;
    private Collection<? extends ConstantElement> declaredConstants;
    private Collection<? extends FunctionScope> declaredFunctions;
    private Collection<? extends InterfaceScope> declaredInterfaces;
    private Collection<? extends VariableName> declaredVariables;
    private Set<FileObject> relevantFiles;
    private ElementQuery.Index idx;
    private final Model model;
    private Set<ModelElement> visibleElements;

    private SafeDeleteSupport(ElementQuery.Index idx, Model model) {
        this.idx = idx;
        this.model = model;
    }

    public static SafeDeleteSupport getInstance(PHPParseResult info) {
        Model model = ModelFactory.getModel((PHPParseResult)info);
        ElementQuery.Index indexQuery = ElementQueryFactory.createIndexQuery((QuerySupport)QuerySupportFactory.get((ParserResult)info));
        return new SafeDeleteSupport(indexQuery, model);
    }

    public Model getModel() {
        return this.model;
    }

    public ElementQuery.Index getIdx() {
        return this.idx;
    }

    public boolean hasVisibleElements() {
        return !this.getVisibleElements().isEmpty();
    }

    public Set<ModelElement> getVisibleElements() {
        if (this.visibleElements == null) {
            FileScope fileScope = this.model.getFileScope();
            ElementFilter[] filters = new ElementFilter[]{ElementFilter.forKind((PhpElementKind)PhpElementKind.CLASS), ElementFilter.forKind((PhpElementKind)PhpElementKind.IFACE), ElementFilter.forKind((PhpElementKind)PhpElementKind.FUNCTION), ElementFilter.forKind((PhpElementKind)PhpElementKind.CONSTANT), ElementFilter.forKind((PhpElementKind)PhpElementKind.VARIABLE)};
            this.declaredClasses = ModelUtils.getDeclaredClasses((FileScope)fileScope);
            this.declaredInterfaces = ModelUtils.getDeclaredInterfaces((FileScope)fileScope);
            this.declaredFunctions = ModelUtils.getDeclaredFunctions((FileScope)fileScope);
            this.declaredConstants = ModelUtils.getDeclaredConstants((FileScope)fileScope);
            this.declaredVariables = ModelUtils.getDeclaredVariables((FileScope)fileScope);
            HashSet<Object> elements = new HashSet<Object>();
            elements.addAll(this.declaredClasses);
            elements.addAll(this.declaredInterfaces);
            elements.addAll(this.declaredFunctions);
            elements.addAll(this.declaredConstants);
            elements.addAll(this.declaredConstants);
            this.visibleElements = ElementFilter.anyOf((ElementFilter[])filters).filter(elements);
        }
        return this.visibleElements;
    }

    public FileObject getFile() {
        return this.model.getFileScope().getFileObject();
    }

    Set<FileObject> getRelevantFiles() {
        if (this.relevantFiles == null) {
            this.relevantFiles = new HashSet<FileObject>();
            for (ModelElement element : this.getVisibleElements()) {
                this.relevantFiles.addAll(this.idx.getLocationsForIdentifiers(element.getName()));
            }
            this.relevantFiles.remove(this.getFile());
        }
        return this.relevantFiles;
    }
}

