/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.editor.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.Position;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.prep.editor.refactoring.Bundle;
import org.netbeans.modules.css.prep.editor.refactoring.CPWhereUsedQueryPlugin;
import org.netbeans.modules.css.prep.editor.refactoring.DiffElement;
import org.netbeans.modules.css.prep.editor.refactoring.RefactoringElement;
import org.netbeans.modules.css.prep.editor.refactoring.RefactoringElementContext;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringCommit;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CPRenameRefactoringPlugin
implements RefactoringPlugin {
    private RenameRefactoring refactoring;
    private Lookup lookup;
    private RefactoringElementContext context;
    private boolean cancelled = false;

    public CPRenameRefactoringPlugin(RenameRefactoring refactoring) {
        this.refactoring = refactoring;
        this.lookup = refactoring.getRefactoringSource();
        this.context = (RefactoringElementContext)this.lookup.lookup(RefactoringElementContext.class);
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        String newName = this.refactoring.getNewName();
        if (newName == null || newName.isEmpty()) {
            return new Problem(true, NbBundle.getMessage(CPRenameRefactoringPlugin.class, (String)"MSG_Error_ElementEmpty"));
        }
        Node element = this.context.getElement();
        if (element != null) {
            switch (element.type()) {
                case cp_variable: {
                    break;
                }
            }
        }
        return null;
    }

    public Problem fastCheckParameters() {
        return this.checkParameters();
    }

    public void cancelRequest() {
        this.cancelled = true;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        try {
            if (this.cancelled) {
                return null;
            }
            ModificationResult modificationResult = new ModificationResult();
            Node element = this.context.getElement();
            if (element != null) {
                switch (element.type()) {
                    case cp_variable: {
                        this.refactorElements(modificationResult, this.context, CPWhereUsedQueryPlugin.findVariables(this.context), Bundle.rename_variable());
                        break;
                    }
                    case cp_mixin_name: {
                        this.refactorElements(modificationResult, this.context, CPWhereUsedQueryPlugin.findMixins(this.context), Bundle.rename_mixin());
                    }
                }
                refactoringElements.registerTransaction((Transaction)new RefactoringCommit(Collections.singletonList(modificationResult)));
                for (FileObject fo : modificationResult.getModifiedFileObjects()) {
                    for (ModificationResult.Difference diff : modificationResult.getDifferences(fo)) {
                        refactoringElements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)DiffElement.create(diff, fo, modificationResult));
                    }
                }
            }
            return null;
        }
        catch (IOException | ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new Problem(true, ex.getLocalizedMessage() == null ? ex.toString() : ex.getLocalizedMessage());
        }
    }

    private void refactorElements(ModificationResult modificationResult, RefactoringElementContext context, Collection<RefactoringElement> elementsToRename, String renameMsg) throws IOException, ParseException {
        HashMap<FileObject, ArrayList<ModificationResult.Difference>> file2diffs = new HashMap<FileObject, ArrayList<ModificationResult.Difference>>();
        for (RefactoringElement refactoringElement : elementsToRename) {
            CloneableEditorSupport editor = GsfUtilities.findCloneableEditorSupport((FileObject)refactoringElement.getFile());
            ModificationResult.Difference diff = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, editor.createPositionRef(refactoringElement.getRange().getStart(), Position.Bias.Forward), editor.createPositionRef(refactoringElement.getRange().getEnd(), Position.Bias.Backward), refactoringElement.getName(), this.refactoring.getNewName(), renameMsg);
            ArrayList<ModificationResult.Difference> diffs = (ArrayList<ModificationResult.Difference>)file2diffs.get(refactoringElement.getFile());
            if (diffs == null) {
                diffs = new ArrayList<ModificationResult.Difference>();
                file2diffs.put(refactoringElement.getFile(), diffs);
            }
            diffs.add(diff);
        }
        for (Map.Entry entry : file2diffs.entrySet()) {
            modificationResult.addDifferences((FileObject)entry.getKey(), (List)entry.getValue());
        }
    }
}

