/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade;

import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.ChangeListener;
import org.openide.util.NbBundle;

final class AutoUpgradePanel
extends JPanel {
    private String source;
    private String note;
    private JTextArea txtVersions;
    private static final ResourceBundle bundle = NbBundle.getBundle(AutoUpgradePanel.class);
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>(1);

    public AutoUpgradePanel(String directory, String note) {
        this.source = directory;
        this.note = note;
        this.initComponents();
        this.initAccessibility();
    }

    void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    void addChangeListener(ChangeListener l) {
        if (!this.changeListeners.contains(l)) {
            this.changeListeners.add(l);
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("MSG_Confirmation"));
    }

    private void initComponents() {
        this.txtVersions = new JTextArea();
        this.setPreferredSize(new Dimension(550, this.source != null && !this.note.isEmpty() ? 120 : 60));
        this.txtVersions.setBackground(this.getBackground());
        this.txtVersions.setColumns(50);
        this.txtVersions.setEditable(false);
        this.txtVersions.setFont(new Font("Dialog", 0, 12));
        this.txtVersions.setLineWrap(true);
        this.txtVersions.setRows(this.source != null && !this.note.isEmpty() ? 6 : 3);
        if (this.source != null) {
            this.txtVersions.setText(NbBundle.getMessage(AutoUpgradePanel.class, (String)"MSG_Confirmation", (Object)this.source, (Object)this.note));
        } else {
            this.txtVersions.setText(this.note);
        }
        this.txtVersions.setWrapStyleWord(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtVersions, -1, 583, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtVersions, -1, 60, Short.MAX_VALUE));
    }
}

