/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsstack.api;

public final class WSStackVersion
implements Comparable<WSStackVersion> {
    private final int major;
    private final int minor;
    private final int micro;
    private final int update;

    private WSStackVersion(int major, int minor, int micro, int update) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.update = update;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public int getUpdate() {
        return this.update;
    }

    public static WSStackVersion valueOf(int major, int minor, int micro, int update) {
        if (major < 0 || minor < 0 || micro < 0 || update < 0) {
            throw new IllegalArgumentException("Negative version number");
        }
        return new WSStackVersion(major, minor, micro, update);
    }

    @Override
    public int compareTo(WSStackVersion v2) {
        if (v2 == null) {
            throw new IllegalArgumentException("Cannot pass null as parameter of WSStackVersion.compareTo(WSStackVersion)");
        }
        if (this == v2) {
            return 0;
        }
        int result = this.major - v2.major;
        if (result != 0) {
            return result / Math.abs(result);
        }
        result = this.minor - v2.minor;
        if (result != 0) {
            return result / Math.abs(result);
        }
        result = this.micro - v2.micro;
        if (result != 0) {
            return result / Math.abs(result);
        }
        result = this.update - v2.update;
        if (result != 0) {
            return result / Math.abs(result);
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WSStackVersion other = (WSStackVersion)obj;
        return this.major == other.major && this.minor == other.minor && this.micro == other.micro && this.update == other.update;
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.major;
        hash = 73 * hash + this.minor;
        hash = 73 * hash + this.micro;
        hash = 73 * hash + this.update;
        return hash;
    }

    public String toString() {
        return String.valueOf(this.major) + "." + String.valueOf(this.minor) + "." + String.valueOf(this.micro) + "." + String.valueOf(this.update);
    }
}

