/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.persistence;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceLocationProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class PersistenceLocationProviderImpl
implements PersistenceLocationProvider,
PropertyChangeListener {
    static final String REL_PERSISTENCE = "META-INF/persistence.xml";
    static final String REL_LOCATION = "META-INF";
    private final Project project;
    private FileObject location = null;
    private File persistenceXml = null;
    private boolean initialized = false;

    public PersistenceLocationProviderImpl(Project proj) {
        this.project = proj;
    }

    public FileObject getLocation() {
        this.initPXmlLocation(false);
        return this.location;
    }

    public FileObject createLocation() throws IOException {
        FileObject ret = null;
        GradleJavaProject gjp = GradleJavaProject.get((Project)this.project);
        if (gjp != null && gjp.getMainSourceSet() != null) {
            GradleJavaSourceSet main = gjp.getMainSourceSet();
            File metaInf = main.findResource(REL_LOCATION, false, new GradleJavaSourceSet.SourceType[]{GradleJavaSourceSet.SourceType.RESOURCES, GradleJavaSourceSet.SourceType.JAVA, GradleJavaSourceSet.SourceType.GROOVY, GradleJavaSourceSet.SourceType.SCALA});
            if (metaInf == null) {
                if (!main.getResourcesDirs().isEmpty()) {
                    metaInf = new File((File)main.getResourcesDirs().iterator().next(), REL_LOCATION);
                } else if (!main.getGroovyDirs().isEmpty()) {
                    metaInf = new File((File)main.getGroovyDirs().iterator().next(), REL_LOCATION);
                } else if (!main.getScalaDirs().isEmpty()) {
                    metaInf = new File((File)main.getScalaDirs().iterator().next(), REL_LOCATION);
                }
            }
            if (metaInf != null) {
                ret = metaInf.exists() ? FileUtil.toFileObject((File)metaInf) : FileUtil.createFolder((File)metaInf);
            }
        }
        return ret;
    }

    protected File getPersistenceXml() {
        this.initPXmlLocation(false);
        return this.persistenceXml;
    }

    private void initPXmlLocation(boolean forced) {
        if (!this.initialized || forced) {
            this.persistenceXml = this.findPersistenceXml();
            this.location = this.persistenceXml != null ? FileUtil.toFileObject((File)this.persistenceXml.getParentFile()) : null;
            this.initialized = true;
        }
    }

    private File findPersistenceXml() {
        File ret = null;
        GradleJavaProject gjp = GradleJavaProject.get((Project)this.project);
        if (gjp != null && gjp.getMainSourceSet() != null && (ret = gjp.getMainSourceSet().findResource(REL_PERSISTENCE, false, new GradleJavaSourceSet.SourceType[]{GradleJavaSourceSet.SourceType.RESOURCES, GradleJavaSourceSet.SourceType.JAVA, GradleJavaSourceSet.SourceType.GROOVY, GradleJavaSourceSet.SourceType.SCALA})) == null && !gjp.getMainSourceSet().getResourcesDirs().isEmpty()) {
            File resDir = (File)gjp.getMainSourceSet().getResourcesDirs().iterator().next();
            ret = new File(resDir, REL_PERSISTENCE);
        }
        return ret;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("GradlePersistence".equals(evt.getPropertyName())) {
            this.initPXmlLocation(true);
        }
    }
}

