/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;

public final class InputStreamWithCloseDetection
extends FilterInputStream {
    private final CountDownLatch closed = new CountDownLatch(1);

    public InputStreamWithCloseDetection(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int r;
        try {
            r = super.read();
        }
        catch (IOException ex) {
            this.notifyClosed();
            throw ex;
        }
        if (r == -1) {
            this.notifyClosed();
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int l;
        try {
            l = super.read(b);
        }
        catch (IOException ex) {
            this.notifyClosed();
            throw ex;
        }
        if (l == -1) {
            this.notifyClosed();
        }
        return l;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int l;
        try {
            l = super.read(b, off, len);
        }
        catch (IOException ex) {
            this.notifyClosed();
            throw ex;
        }
        if (l == -1) {
            this.notifyClosed();
        }
        return l;
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.notifyClosed();
        }
    }

    private void notifyClosed() {
        this.closed.countDown();
    }

    public void waitForClose() throws InterruptedException {
        this.closed.await();
    }
}

