/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.execute;

import java.awt.Color;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.execute.RunConfig;
import org.netbeans.modules.gradle.api.output.OutputDisplayer;
import org.netbeans.modules.gradle.api.output.OutputProcessor;
import org.netbeans.modules.gradle.api.output.OutputProcessorFactory;
import org.netbeans.modules.gradle.execute.EscapeProcessor;
import org.openide.util.Lookup;
import org.openide.windows.IOColorPrint;
import org.openide.windows.IOColors;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class GradlePlainEscapeProcessor
implements EscapeProcessor {
    final InputOutput io;
    final OutputDisplayer output;
    IOColors.OutputType outType;
    StringBuilder line = new StringBuilder(80);
    final Set<OutputProcessor> processors = new LinkedHashSet<OutputProcessor>();
    private static final OutputProcessor TASK_LINE_PROCESSOR = new OutputProcessor(){
        final Pattern TASK_LINE = Pattern.compile("> Task (:[\\w:\\-]+)( [\\w\\-]+)?");

        @Override
        public boolean processLine(OutputDisplayer out, String line) {
            Matcher m = this.TASK_LINE.matcher(line);
            boolean ret = m.matches();
            if (ret) {
                String task = m.group(1);
                String state = m.group(2);
                out.print("> Task ");
                out.print(task);
                if (state != null) {
                    IOColors.OutputType type = IOColors.OutputType.LOG_WARNING;
                    if (state.endsWith("EXECUTED") || state.endsWith("UP-TO-DATE") || state.endsWith("FROM-CACHE")) {
                        type = IOColors.OutputType.LOG_SUCCESS;
                    } else if (state.endsWith("FAILED")) {
                        type = IOColors.OutputType.LOG_FAILURE;
                    }
                    out.print(state, null, type);
                }
            }
            return ret;
        }
    };
    private static final OutputProcessor STATIC_STRING_PROCESSOR = new OutputProcessor(){
        private static final String BUILD_FAILED_MSG = "BUILD FAILED";
        private static final String BUILD_SUCCESS_MSG = "BUILD SUCCESSFUL";
        private static final String COD_INCUBATION_MSG = "Configuration on demand is an incubating feature.";
        private static final String CONFIG_CACHE_MGS = "Configuration cache ";

        @Override
        public boolean processLine(OutputDisplayer out, String line) {
            IOColors.OutputType type = null;
            if (line.startsWith(COD_INCUBATION_MSG) || line.startsWith(CONFIG_CACHE_MGS)) {
                type = IOColors.OutputType.LOG_DEBUG;
            } else if (line.startsWith(BUILD_SUCCESS_MSG)) {
                type = IOColors.OutputType.LOG_SUCCESS;
            } else if (line.startsWith(BUILD_FAILED_MSG)) {
                type = IOColors.OutputType.LOG_FAILURE;
            }
            if (type != null) {
                out.print(line, null, type);
            }
            return type != null;
        }
    };

    public GradlePlainEscapeProcessor(InputOutput io, RunConfig cfg, boolean error) {
        this.io = io;
        this.output = new IODisplayer();
        Project prj = cfg.getProject();
        if (prj != null) {
            this.processorsFromLookup(prj.getLookup(), cfg);
        }
        this.outType = error ? IOColors.OutputType.ERROR : IOColors.OutputType.OUTPUT;
        this.processors.add(TASK_LINE_PROCESSOR);
        this.processors.add(STATIC_STRING_PROCESSOR);
    }

    private void processorsFromLookup(Lookup lookup, RunConfig cfg) {
        Collection factories = lookup.lookupAll(OutputProcessorFactory.class);
        for (OutputProcessorFactory factory : factories) {
            this.processors.addAll(factory.createOutputProcessors(cfg));
        }
    }

    @Override
    public void processCommand(String sequence, char command, int ... a) {
    }

    @Override
    public void processText(String text, boolean forceOutput) {
        this.line.append(text);
        boolean eol = text.endsWith("\n");
        if (eol) {
            this.line.setLength(this.line.length() - 1);
        }
        if (eol) {
            String out = this.line.toString();
            boolean processed = false;
            Iterator<OutputProcessor> it = this.processors.iterator();
            while (!processed && it.hasNext()) {
                processed = it.next().processLine(this.output, out);
            }
            if (!processed) {
                this.output.print(out, null, this.outType);
            }
            this.output.print("\n");
            this.line.setLength(0);
        } else if (forceOutput && this.line.length() > 0) {
            this.output.print(this.line.toString());
            this.line.setLength(0);
        }
    }

    private class IODisplayer
    extends OutputDisplayer {
        private IODisplayer() {
        }

        @Override
        protected void doPrint(CharSequence text, final Runnable action, IOColors.OutputType type) {
            OutputListener l = null;
            if (action != null) {
                l = new OutputListener(){

                    public void outputLineCleared(OutputEvent ev) {
                    }

                    public void outputLineSelected(OutputEvent ev) {
                    }

                    public void outputLineAction(OutputEvent ev) {
                        action.run();
                    }
                };
            }
            if (type == null) {
                type = action == null ? GradlePlainEscapeProcessor.this.outType : IOColors.OutputType.HYPERLINK;
            }
            try {
                IOColorPrint.print((InputOutput)GradlePlainEscapeProcessor.this.io, (CharSequence)text, (OutputListener)l, (boolean)false, (Color)IOColors.getColor((InputOutput)GradlePlainEscapeProcessor.this.io, (IOColors.OutputType)type));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

