/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.api.model;

import java.net.URISyntaxException;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;

public class ModelUnit {
    private final ClasspathInfo myClassPathInfo;
    private final ClassPath myBootPath;
    private final ClassPath myCompilePath;
    private final ClassPath mySourcePath;
    private final Project myProject;

    private ModelUnit(ClassPath bootPath, ClassPath compilePath, ClassPath sourcePath, Project project) {
        this.myBootPath = bootPath;
        this.myCompilePath = compilePath;
        this.mySourcePath = sourcePath;
        this.myProject = project;
        this.myClassPathInfo = ClasspathInfo.create((ClassPath)bootPath, (ClassPath)compilePath, (ClassPath)sourcePath);
    }

    public ClassPath getBootPath() {
        return this.myBootPath;
    }

    public ClassPath getCompilePath() {
        return this.myCompilePath;
    }

    public ClassPath getSourcePath() {
        return this.mySourcePath;
    }

    public Project getProject() {
        return this.myProject;
    }

    public int hashCode() {
        return 37 * (37 * this.myBootPath.hashCode() + this.myCompilePath.hashCode()) + this.mySourcePath.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelUnit) {
            ModelUnit unit = (ModelUnit)obj;
            return this.myBootPath.equals((Object)unit.myBootPath) && this.myCompilePath.equals((Object)unit.myCompilePath) && this.mySourcePath.equals((Object)this.mySourcePath);
        }
        return false;
    }

    public static ModelUnit create(ClassPath bootPath, ClassPath compilePath, ClassPath sourcePath, Project project) {
        return new ModelUnit(bootPath, compilePath, sourcePath, project);
    }

    public ClasspathInfo getClassPathInfo() {
        return this.myClassPathInfo;
    }

    private static boolean equals(ClassPath cp1, ClassPath cp2) {
        if (cp1.entries().size() != cp2.entries().size()) {
            return false;
        }
        for (int i = 0; i < cp1.entries().size(); ++i) {
            try {
                if (((ClassPath.Entry)cp1.entries().get(i)).getURL().toURI().equals(((ClassPath.Entry)cp2.entries().get(i)).getURL().toURI())) continue;
                return false;
            }
            catch (URISyntaxException e) {
                if (((ClassPath.Entry)cp1.entries().get(i)).equals(cp2.entries().get(i))) continue;
                return false;
            }
        }
        return true;
    }

    private static int computeClassPathHash(ClassPath classPath) {
        int hashCode = 0;
        for (ClassPath.Entry entry : classPath.entries()) {
            hashCode = 37 * hashCode + entry.getURL().getPath().hashCode();
        }
        return hashCode;
    }

    FileObject getSourceFileObject() {
        FileObject[] roots = this.mySourcePath.getRoots();
        if (roots != null && roots.length > 0) {
            return roots[0];
        }
        return null;
    }
}

