/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.analysis.analyzer;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.jakarta.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.ElementAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.annotation.InterceptorBindingMembersAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.annotation.QualifierAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.annotation.ScopeAnalyzer;

public class AnnotationElementAnalyzer
implements ElementAnalyzer {
    private static final List<AnnotationAnalyzer> ANALYZERS = new LinkedList<AnnotationAnalyzer>();

    @Override
    public void analyze(Element element, TypeElement parent, AtomicBoolean cancel, CdiAnalysisResult result) {
        TypeElement subject = (TypeElement)element;
        for (AnnotationAnalyzer analyzer : ANALYZERS) {
            if (cancel.get()) {
                return;
            }
            analyzer.analyze(subject, cancel, result);
        }
    }

    static {
        ANALYZERS.add(new ScopeAnalyzer());
        ANALYZERS.add(new QualifierAnalyzer());
        ANALYZERS.add(new InterceptorBindingMembersAnalyzer());
    }

    public static interface AnnotationAnalyzer {
        public static final String INCORRECT_RUNTIME = "ERR_IncorrectRuntimeRetention";

        public void analyze(TypeElement var1, AtomicBoolean var2, CdiAnalysisResult var3);
    }
}

