/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.Set;
import org.ice4j.socket.DelegatingSocket;

public class BaseDelegatingSocketChannel<T extends SocketChannel>
extends SocketChannel {
    protected final T delegate;
    private Socket socket;
    private final Object socketSyncRoot = new Object();

    public BaseDelegatingSocketChannel(T delegate) {
        super(((AbstractSelectableChannel)delegate).provider());
        this.delegate = delegate;
    }

    @Override
    public SocketChannel bind(SocketAddress local) throws IOException {
        ((SocketChannel)this.delegate).bind(local);
        return this;
    }

    @Override
    public boolean connect(SocketAddress remote) throws IOException {
        return ((SocketChannel)this.delegate).connect(remote);
    }

    @Override
    public boolean finishConnect() throws IOException {
        return ((SocketChannel)this.delegate).finishConnect();
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return ((SocketChannel)this.delegate).getLocalAddress();
    }

    public <U> U getOption(SocketOption<U> name) throws IOException {
        return this.delegate.getOption(name);
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return ((SocketChannel)this.delegate).getRemoteAddress();
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        ((AbstractInterruptibleChannel)this.delegate).close();
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        ((AbstractSelectableChannel)this.delegate).configureBlocking(block);
    }

    protected Socket implSocket(Socket socket) throws IOException {
        return new DelegatingSocket(socket, this);
    }

    @Override
    public boolean isConnected() {
        return ((SocketChannel)this.delegate).isConnected();
    }

    @Override
    public boolean isConnectionPending() {
        return ((SocketChannel)this.delegate).isConnectionPending();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return ((SocketChannel)this.delegate).read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return ((SocketChannel)this.delegate).read(dsts, offset, length);
    }

    public <U> SocketChannel setOption(SocketOption<U> name, U value2) throws IOException {
        ((SocketChannel)this.delegate).setOption((SocketOption)name, value2);
        return this;
    }

    @Override
    public SocketChannel shutdownInput() throws IOException {
        ((SocketChannel)this.delegate).shutdownInput();
        return this;
    }

    @Override
    public SocketChannel shutdownOutput() throws IOException {
        ((SocketChannel)this.delegate).shutdownOutput();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket socket() {
        Socket socket = ((SocketChannel)this.delegate).socket();
        Object object = this.socketSyncRoot;
        synchronized (object) {
            if (this.socket == null) {
                if (socket != null) {
                    try {
                        this.socket = this.implSocket(socket);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
            } else if (socket == null) {
                this.socket = null;
            }
            return this.socket;
        }
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.delegate.supportedOptions();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return ((SocketChannel)this.delegate).write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return ((SocketChannel)this.delegate).write(srcs, offset, length);
    }
}

