/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.consanguinity;

import ancestris.modules.gedcom.consanguinity.ConsanguiniteInfo;
import ancestris.modules.gedcom.consanguinity.SortedData;
import ancestris.modules.gedcom.consanguinity.VisitedSatus;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;

public class ComputeConsanguinity {
    private Indi root;
    private final Gedcom gedcom;
    private final Map<String, ConsanguiniteInfo> mapConsanguinityCommonIndi = new HashMap<String, ConsanguiniteInfo>();
    private final List<ConsanguiniteInfo> listConsanguinityNotNull = new ArrayList<ConsanguiniteInfo>();
    private Optional<ConsanguiniteInfo> potentialLoop = Optional.empty();

    public ComputeConsanguinity(Indi theRoot) {
        this.root = theRoot;
        this.gedcom = this.root.getGedcom();
    }

    public ComputeConsanguinity(Gedcom theGedcom) {
        this.gedcom = theGedcom;
    }

    public float compute() {
        assert (this.root != null);
        SortedData sorted = this.getTopologicalSort();
        this.potentialLoop = this.hasLoop(sorted);
        if (this.potentialLoop.isPresent()) {
            return -1.0f;
        }
        return this.computeConsang(this.root, sorted);
    }

    public float compute(Indi theRoot) {
        this.root = theRoot;
        return this.compute();
    }

    public Optional<ConsanguiniteInfo> hasLoop() {
        SortedData sorted = this.getTopologicalSort();
        this.potentialLoop = this.hasLoop(sorted);
        return this.potentialLoop;
    }

    public Collection<ConsanguiniteInfo> getCommonAncestors() {
        return this.mapConsanguinityCommonIndi.values();
    }

    public Collection<ConsanguiniteInfo> getCoefficientNotNul() {
        return this.listConsanguinityNotNull;
    }

    public Optional<ConsanguiniteInfo> getPotentialLoop() {
        return this.potentialLoop;
    }

    private SortedData getTopologicalSort() {
        HashMap<String, Integer> indiSorted = new HashMap<String, Integer>();
        this.gedcom.getIndis().forEach(p -> indiSorted.put(p.getId(), p.getBiologicalChildren().length));
        ArrayList<String> currentLoop = new ArrayList<String>();
        for (String id : indiSorted.keySet()) {
            if ((Integer)indiSorted.get(id) != 0) continue;
            currentLoop.add(id);
        }
        int currentLevel = 0;
        int maxSorted = 0;
        while (!currentLoop.isEmpty()) {
            ArrayList<String> nextLoop = new ArrayList<String>();
            for (String id : currentLoop) {
                indiSorted.put(id, currentLevel);
                Indi current = (Indi)this.gedcom.getEntity("INDI", id);
                Fam famc = current.getFamilyWhereBiologicalChild();
                if (famc == null) continue;
                Indi husb = famc.getHusband();
                Indi wife = famc.getWife();
                if (husb != null) {
                    Integer husbValue = (Integer)indiSorted.get(husb.getId());
                    husbValue = husbValue - 1;
                    indiSorted.put(husb.getId(), husbValue);
                    if (husbValue == 0) {
                        nextLoop.add(husb.getId());
                    }
                }
                if (wife == null) continue;
                Integer wifeValue = (Integer)indiSorted.get(wife.getId());
                wifeValue = wifeValue - 1;
                indiSorted.put(wife.getId(), wifeValue);
                if (wifeValue != 0) continue;
                nextLoop.add(wife.getId());
            }
            currentLoop = nextLoop;
            maxSorted = ++currentLevel;
        }
        SortedData sorted = this.sortData(indiSorted);
        sorted.setMaxGeneration(maxSorted);
        return sorted;
    }

    private SortedData sortData(Map<String, Integer> sortedIndi) {
        SortedData datas = new SortedData();
        sortedIndi.entrySet().forEach(e -> {
            Indi currentIndi = (Indi)this.gedcom.getEntity("INDI", (String)e.getKey());
            ConsanguiniteInfo current = new ConsanguiniteInfo(currentIndi, (Integer)e.getValue());
            current.setBiologicalFamily(currentIndi.getFamilyWhereBiologicalChild());
            if (current.getBiologicalFamily() != null) {
                current.setFather(current.getBiologicalFamily().getHusband());
                current.setMother(current.getBiologicalFamily().getWife());
            }
            datas.getSortedSet().add(current);
            datas.getIndiMap().put((String)e.getKey(), current);
        });
        return datas;
    }

    private float computeConsang(Indi i, SortedData sorted) {
        HashMap<String, Float> famConsang = new HashMap<String, Float>();
        TreeSet<ConsanguiniteInfo> ancetres = new TreeSet<ConsanguiniteInfo>();
        ConsanguiniteInfo current = sorted.getIndiMap().get(i.getId());
        if (current.getBiologicalFamily() == null) {
            current.setCoefficient(0.0f);
            current.setIsCoefCalulated(true);
            return current.getCoefficient();
        }
        ancetres.add(current);
        this.addCommonAncestors(current.getFather(), sorted, ancetres);
        this.addCommonAncestors(current.getMother(), sorted, ancetres);
        for (ConsanguiniteInfo c : ancetres) {
            if (c.isIsCoefCalulated()) continue;
            if (c.getBiologicalFamily() == null) {
                c.setCoefficient(0.0f);
                c.setIsCoefCalulated(true);
                continue;
            }
            if (famConsang.containsKey(c.getBiologicalFamily().getId())) {
                c.setCoefficient(((Float)famConsang.get(c.getBiologicalFamily().getId())).floatValue());
                c.setIsCoefCalulated(true);
                continue;
            }
            Indi father = c.getFather();
            Indi mother = c.getMother();
            if (father == null || mother == null) {
                c.setCoefficient(0.0f);
                c.setIsCoefCalulated(true);
                continue;
            }
            float coef = this.computeParente(sorted, father, mother);
            c.setCoefficient(coef);
            c.setIsCoefCalulated(true);
            famConsang.put(c.getBiologicalFamily().getId(), Float.valueOf(coef));
            if (c.getCoefficient() == 0.0f) continue;
            this.listConsanguinityNotNull.add(c);
        }
        for (ConsanguiniteInfo c : ancetres) {
            ConsanguiniteInfo motherCi;
            Indi currentMother;
            ConsanguiniteInfo fatherCi;
            if (c.isIsAncX() && c.isIsAncY() || c.getBiologicalFamily() == null) continue;
            Indi currentFather = c.getFather();
            if (currentFather != null && (fatherCi = sorted.getIndiMap().get(currentFather.getId())).isIsAncX() && fatherCi.isIsAncY()) {
                this.mapConsanguinityCommonIndi.put(fatherCi.getId(), fatherCi);
            }
            if ((currentMother = c.getMother()) == null || !(motherCi = sorted.getIndiMap().get(currentMother.getId())).isIsAncX() || !motherCi.isIsAncY()) continue;
            this.mapConsanguinityCommonIndi.put(motherCi.getId(), motherCi);
        }
        return current.getCoefficient();
    }

    private float computeParente(SortedData sorted, Indi father, Indi mother) {
        sorted.cleanGeneration();
        float retour = 0.0f;
        if (father.getId().equals(mother.getId())) {
            return 1.0f;
        }
        this.insertGeneration(sorted, father);
        this.insertGeneration(sorted, mother);
        ConsanguiniteInfo fatherCi = sorted.getIndiMap().get(father.getId());
        fatherCi.setIsAncY(true);
        fatherCi.setZy(1.0f);
        ConsanguiniteInfo motherCi = sorted.getIndiMap().get(mother.getId());
        motherCi.setZx(1.0f);
        motherCi.setIsAncX(true);
        for (int i = 0; i <= sorted.getMaxGeneration(); ++i) {
            List<ConsanguiniteInfo> listC = sorted.getGeneration().get(i);
            for (ConsanguiniteInfo current : listC) {
                float contribution = current.getZx() * current.getZy() - current.getZc() * (1.0f + current.getCoefficient());
                retour += contribution;
                if (current.getBiologicalFamily() == null) continue;
                Indi papaEnCours = current.getFather();
                Indi mamanEnCours = current.getMother();
                if (papaEnCours != null) {
                    this.manageParent(sorted.getIndiMap().get(papaEnCours.getId()), sorted, current);
                }
                if (mamanEnCours == null) continue;
                this.manageParent(sorted.getIndiMap().get(mamanEnCours.getId()), sorted, current);
            }
        }
        return retour / 2.0f;
    }

    private void manageParent(ConsanguiniteInfo parent, SortedData sorted, ConsanguiniteInfo enfant) {
        List<ConsanguiniteInfo> listParent = sorted.getGeneration().get(parent.getGeneration());
        if (!listParent.contains(parent)) {
            this.insertGeneration(sorted, parent.getIndi());
        }
        parent.setIsAncX(enfant.isIsAncX() || parent.isIsAncX());
        parent.setIsAncY(enfant.isIsAncY() || parent.isIsAncY());
        parent.setZx(parent.getZx() + enfant.getZx() / 2.0f);
        parent.setZy(parent.getZy() + enfant.getZy() / 2.0f);
        parent.setZc(parent.getZc() + enfant.getZx() * enfant.getZy() / 4.0f);
    }

    private void insertGeneration(SortedData sorted, Indi indi) {
        ConsanguiniteInfo theIndi = sorted.getIndiMap().get(indi.getId());
        theIndi.setIsAncX(false);
        theIndi.setIsAncY(false);
        theIndi.setZx(0.0f);
        theIndi.setZy(0.0f);
        theIndi.setZc(0.0f);
        List<ConsanguiniteInfo> listC = sorted.getGeneration().get(theIndi.getGeneration());
        listC.add(theIndi);
    }

    private void addCommonAncestors(Indi i, SortedData sorted, Set<ConsanguiniteInfo> ancetres) {
        if (i == null) {
            return;
        }
        ConsanguiniteInfo currentCi = sorted.getIndiMap().get(i.getId());
        if (ancetres.contains(currentCi)) {
            return;
        }
        ancetres.add(currentCi);
        if (currentCi.getBiologicalFamily() != null) {
            this.addCommonAncestors(currentCi.getFather(), sorted, ancetres);
            this.addCommonAncestors(currentCi.getMother(), sorted, ancetres);
        }
    }

    private Optional<ConsanguiniteInfo> hasLoop(SortedData datas) {
        for (ConsanguiniteInfo current : datas.getSortedSet()) {
            current.setStatus(VisitedSatus.NOT_VISITED);
            Optional<ConsanguiniteInfo> retour = this.iterateLoop(current, datas.getIndiMap());
            if (!retour.isPresent()) continue;
            return retour;
        }
        return Optional.empty();
    }

    private Optional<ConsanguiniteInfo> iterateLoop(ConsanguiniteInfo currentIndi, Map<String, ConsanguiniteInfo> indiMap) {
        Optional<ConsanguiniteInfo> retour = Optional.empty();
        switch (currentIndi.getStatus()) {
            case BEING_VISITED: {
                return Optional.of(currentIndi);
            }
            case NOT_VISITED: {
                Indi husb = currentIndi.getFather();
                Indi wife = currentIndi.getMother();
                currentIndi.setStatus(VisitedSatus.BEING_VISITED);
                if (husb != null && (retour = this.iterateLoop(indiMap.get(husb.getId()), indiMap)).isPresent()) {
                    return retour;
                }
                if (wife != null && (retour = this.iterateLoop(indiMap.get(wife.getId()), indiMap)).isPresent()) {
                    return retour;
                }
                currentIndi.setStatus(VisitedSatus.VISITED);
                break;
            }
        }
        return retour;
    }
}

