/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.panels;

import ancestris.modules.editors.aries.AriesTopComponent;
import ancestris.modules.editors.aries.editors.EntityEditor;
import ancestris.modules.editors.aries.editors.FamilyEditor;
import ancestris.modules.editors.aries.editors.IndividualEditor;
import ancestris.modules.editors.aries.editors.MultiMediaObjectEditor;
import ancestris.modules.editors.aries.editors.NoteEditor;
import ancestris.modules.editors.aries.editors.RepositoryEditor;
import ancestris.modules.editors.aries.editors.SourceEditor;
import ancestris.modules.editors.aries.editors.SubmitterEditor;
import ancestris.modules.editors.aries.models.ReferencesTableModel;
import ancestris.modules.editors.aries.table.EditorTable;
import genj.gedcom.AbstractNote;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import genj.gedcom.Submitter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;

public class ReferencesTablePanel
extends JPanel {
    private Entity mRoot;
    private final ReferencesTableModel mReferencesTableModel = new ReferencesTableModel();
    private EditorTable referencesTable;
    private JScrollPane referencesTableScrollPane;
    private JToolBar referencesToolBar;

    public ReferencesTablePanel() {
        this.initComponents();
        this.referencesTable.setID(ReferencesTablePanel.class.getName());
    }

    private void initComponents() {
        this.referencesToolBar = new JToolBar();
        this.referencesTableScrollPane = new JScrollPane();
        this.referencesTable = new EditorTable();
        this.referencesToolBar.setFloatable(false);
        this.referencesToolBar.setRollover(true);
        this.referencesTable.setModel(this.mReferencesTableModel);
        this.referencesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ReferencesTablePanel.this.referencesTableMouseClicked(evt);
            }
        });
        this.referencesTableScrollPane.setViewportView(this.referencesTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.referencesToolBar, -1, 539, Short.MAX_VALUE).addComponent(this.referencesTableScrollPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.referencesToolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.referencesTableScrollPane, -1, 154, Short.MAX_VALUE)));
    }

    private void referencesTableMouseClicked(MouseEvent evt) {
        int selectedRow;
        if (evt.getClickCount() >= 2 && (selectedRow = this.referencesTable.getSelectedRow()) != -1) {
            int rowIndex = this.referencesTable.convertRowIndexToModel(selectedRow);
            Entity entity = this.mReferencesTableModel.getValueAt(rowIndex);
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(this.mRoot.getGedcom());
            EntityEditor editor = this.getEditor(entity);
            if (editor != null) {
                editor.setContext(new Context(this.mReferencesTableModel.getValueAt(rowIndex)));
                atc.getOpenEditors().add(editor);
                editor.showPanel();
                atc.getOpenEditors().remove((Object)editor);
            }
        }
    }

    public void set(Entity rootEntity, List<Entity> referencesList) {
        this.mRoot = rootEntity;
        this.mReferencesTableModel.clear();
        this.mReferencesTableModel.addAll(referencesList);
    }

    private EntityEditor getEditor(Entity entity) {
        if (entity instanceof Indi) {
            return new IndividualEditor();
        }
        if (entity instanceof Fam) {
            return new FamilyEditor();
        }
        if (entity instanceof AbstractNote) {
            return new NoteEditor();
        }
        if (entity instanceof Media) {
            return new MultiMediaObjectEditor();
        }
        if (entity instanceof Source) {
            return new SourceEditor();
        }
        if (entity instanceof Repository) {
            return new RepositoryEditor();
        }
        if (entity instanceof Submitter) {
            return new SubmitterEditor();
        }
        return null;
    }
}

