/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.pedigreevertical;

import ancestris.core.TextOptions;
import ancestris.reports.FormatDateOptions;
import ancestris.reports.FormatIDOptions;
import ancestris.reports.FormatPlaceOptions;
import ancestris.reports.FormattingMainOptions;
import ancestris.reports.FormattingPedigreeOptions;
import ancestris.reports.PedigreeColorsOptions;
import ancestris.reports.ScopeIndiMiniOptions;
import ancestris.reports.utils.SvgUtils;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.report.Report;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class ReportPedigreeVertical
extends Report {
    public MyFormattingOptions formattingOptions = new MyFormattingOptions();
    public MyScope scope = new MyScope();
    public Events events = new Events();
    public MyDataFormatOptions dataFormatOptions = new MyDataFormatOptions();
    public MyColours colors = new MyColours();
    private static final Charset SVG_CHARSET = Charset.forName("UTF-8");
    private static final int MAX_GENERATIONS = 4;
    private static final int BORDER_TOP = 10;
    private static final int BORDER_LEFT = 10;
    private static final int SVG_HEIGHT = 1240;
    private static final int SVG_WIDTH = 1754;
    private static final int BOX_PADDING = 10;
    private static final int TEXT_PADDING = 5;
    private static final int INDI_FAM_RATIO = 3;
    private Document document;
    private SVGGraphics2D svgGenerator;
    private String reportTitle;
    private int pageWidth = 0;
    private int pageHeight = 0;
    private int colWidth = 0;
    private int colWidthSpace = 0;
    private int lineHeight = 0;
    private int lineHeightSpace = 0;
    private int fullTitleHeight = 0;
    private int indiBoxHeight = 0;
    private int famBoxHeight = 0;
    private int boxWidth = 0;
    private List<Indibox> indiboxes;
    private List<Fambox> famboxes;

    public String accepts(Object context) {
        if (context instanceof Gedcom || context instanceof Indi) {
            return super.getName();
        }
        return null;
    }

    public File start(Gedcom gedcom) {
        Indi indi = this.scope.common.getScope(gedcom, this);
        return indi != null ? this.main(indi) : null;
    }

    public File start(Indi indi) {
        return indi != null ? this.main(indi) : null;
    }

    public File main(Indi indi) {
        File file;
        try {
            file = File.createTempFile("ancestris_svg", ".svg");
            file.deleteOnExit();
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, this.translate("output.error.creation"), ex);
            return null;
        }
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        this.document = domImpl.createDocument("http://www.w3.org/2000/svg", "svg", null);
        this.svgGenerator = new SVGGraphics2D(this.document);
        this.svgGenerator.getGeneratorContext().setComment("Generated by Ancestris with Batik SVG Generator");
        this.drawPedigree(indi);
        try {
            PrintWriter writer = this.getWriter(new FileOutputStream(file));
            this.svgGenerator.stream((Writer)writer);
            writer.flush();
            writer.close();
        }
        catch (FileNotFoundException | SVGGraphics2DIOException ex) {
            LOG.log(Level.INFO, this.translate("output.error.writing"), ex);
            return null;
        }
        return file;
    }

    private PrintWriter getWriter(OutputStream out) {
        return new PrintWriter(new OutputStreamWriter(out, SVG_CHARSET));
    }

    private void drawPedigree(Indi indi) {
        this.scope.nbGenerations = Math.max(1, Math.min(4, this.scope.nbGenerations));
        int gridCols = (int)Math.pow(2.0, this.scope.nbGenerations);
        int gridRows = this.scope.nbGenerations;
        this.reportTitle = indi.getDisplayTitle(true);
        this.pageWidth = this.formattingOptions.common.isPortraitOrientation() ? 1240 : 1754;
        this.pageHeight = this.formattingOptions.common.isPortraitOrientation() ? 1754 : 1240;
        this.svgGenerator.setSVGCanvasSize(new Dimension(this.pageWidth, this.pageHeight));
        this.svgGenerator.setPaint((Paint)this.colors.common.canvasColor);
        this.svgGenerator.fill((Shape)new Rectangle(0, 0, this.pageWidth, this.pageHeight));
        BasicStroke line = new BasicStroke(1.0f);
        this.svgGenerator.setColor(this.colors.common.borderColor);
        this.svgGenerator.setStroke((Stroke)line);
        this.svgGenerator.drawRect(10, 10, this.pageWidth - 20, this.pageHeight - 20);
        this.svgGenerator.setColor(this.colors.common.titleColor);
        Font titleFont = this.formattingOptions.common.getTitleFont();
        this.svgGenerator.setFont(titleFont);
        String title = this.translate("title", new Object[]{this.reportTitle});
        Rectangle2D rectTitle = SvgUtils.getTextSize(title, titleFont);
        int titleW = (int)rectTitle.getWidth();
        int titleH = (int)rectTitle.getHeight();
        this.svgGenerator.drawString(title, this.pageWidth / 2 - titleW / 2, 20 + titleH);
        this.fullTitleHeight = 30 + titleH;
        int width = this.pageWidth - 20;
        int height = this.pageHeight - this.fullTitleHeight - 10;
        this.colWidth = width / gridCols;
        this.lineHeight = height / gridRows;
        this.boxWidth = 2 * this.colWidth * 9 / 10;
        this.colWidthSpace = this.colWidth / 5;
        this.famBoxHeight = this.lineHeight / 4 * 9 / 10;
        this.indiBoxHeight = 3 * this.famBoxHeight;
        this.lineHeightSpace = this.lineHeight / 10;
        this.indiboxes = new ArrayList<Indibox>();
        this.famboxes = new ArrayList<Fambox>();
        this.buildTree(1, indi, 1, null);
        this.drawTree();
    }

    private void buildTree(int level, Indi indi, Integer sosa, Box previous) {
        Fam famc;
        if (level > this.scope.nbGenerations) {
            return;
        }
        Indibox indibox = new Indibox(level, indi, sosa, this.scope.nbGenerations, previous);
        this.indiboxes.add(indibox);
        Indi father = null;
        Indi mother = null;
        Fambox fambox = null;
        if (indi != null && (famc = indi.getFamilyWhereBiologicalChild()) != null) {
            father = famc.getHusband();
            mother = famc.getWife();
            if (level < this.scope.nbGenerations) {
                fambox = new Fambox(level, famc, sosa, this.scope.nbGenerations, indibox);
                this.famboxes.add(fambox);
            }
        }
        this.buildTree(level + 1, father, 2 * sosa, fambox);
        this.buildTree(level + 1, mother, 2 * sosa + 1, fambox);
    }

    private void drawTree() {
        for (Indibox indibox : this.indiboxes) {
            this.drawBox(indibox);
        }
        for (Fambox fambox : this.famboxes) {
            this.drawBox(fambox);
        }
        for (int level = this.scope.nbGenerations; level > 0; --level) {
            if (level > 1) {
                for (Indibox indibox : this.indiboxes) {
                    if (indibox.level != level) continue;
                    this.drawConnector(indibox, indibox.previous);
                }
            }
            for (Fambox fambox : this.famboxes) {
                if (fambox.level != level) continue;
                this.drawConnector(fambox, fambox.previous);
            }
        }
    }

    private Point getPoint(int gen, int sosa) {
        int x = (int)(Math.log(sosa) / Math.log(2.0));
        int y = (2 * sosa - (int)Math.pow(2.0, x + 1) + 1) * (int)Math.pow(2.0, gen - x - 1) - 1;
        return new Point(x, y);
    }

    private void drawBox(Box box) {
        boolean isFam = box instanceof Fambox;
        int x = 10 + box.p.y * this.colWidth + this.colWidthSpace / 2;
        int y = 10 + (this.scope.nbGenerations - box.p.x - 1) * this.lineHeight + this.fullTitleHeight + this.lineHeightSpace;
        int w = this.boxWidth;
        int h = this.indiBoxHeight;
        if (isFam) {
            y = y - this.famBoxHeight - this.lineHeightSpace * 4 / 5;
            h = this.famBoxHeight;
        }
        this.svgGenerator.setPaint((Paint)(!isFam ? this.colors.common.boxBackgroundColor : this.colors.boxBackgroundFamColor));
        if (this.formattingOptions.pedigree.roundedRect) {
            this.svgGenerator.fillRoundRect(x, y, w, h, 20, 20);
        } else {
            this.svgGenerator.fillRect(x, y, w, h);
        }
        this.svgGenerator.setColor(!isFam ? this.colors.common.boxBorderColor : this.colors.boxBorderFamColor);
        if (this.formattingOptions.pedigree.roundedRect) {
            this.svgGenerator.drawRoundRect(x, y, w, h, 20, 20);
        } else {
            this.svgGenerator.drawRect(x, y, w, h);
        }
        this.svgGenerator.setColor(this.colors.common.boxTextColor);
        Font font = this.formattingOptions.common.getFont().deriveFont(1);
        Rectangle2D rectTitle = SvgUtils.getTextSize(box.labelLines[0], font);
        int textH = (int)rectTitle.getHeight();
        int textY = y + textH;
        this.svgGenerator.setFont(this.formattingOptions.common.getFont().deriveFont(1));
        this.svgGenerator.drawString(SvgUtils.getText(box.labelLines[0], font, this.boxWidth - 20), x + 10, textY);
        for (int l = 1; l < box.labelLines.length && box.labelLines[l] != null; ++l) {
            font = this.formattingOptions.common.getFont();
            if (!isFam && l < 3) {
                font = font.deriveFont(1);
            }
            this.svgGenerator.setFont(font);
            if (y + h <= textY + 10 + textH + 5) break;
            textY = textY + 5 + textH;
            this.svgGenerator.drawString(SvgUtils.getText(box.labelLines[l], font, this.boxWidth - 20), x + 10, textY);
        }
        box.setCoord(x, y);
    }

    private void drawConnector(Box box, Box previous) {
        if (previous == null) {
            return;
        }
        BasicStroke line = new BasicStroke(1.0f);
        if (this.formattingOptions.pedigree.dashed) {
            line = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f}, 0.0f);
        }
        this.svgGenerator.setStroke((Stroke)line);
        this.svgGenerator.setColor(this.colors.common.lineColor);
        boolean isFam = box instanceof Fambox;
        int attach = this.boxWidth / 2;
        if (isFam) {
            this.svgGenerator.drawLine(box.coord.x + attach, box.coord.y + this.famBoxHeight, box.coord.x + attach, previous.coord.y);
        } else {
            int w = this.indiBoxHeight;
            if (box.coord.x < previous.coord.x) {
                this.svgGenerator.drawLine(box.coord.x + attach, box.coord.y + this.indiBoxHeight, box.coord.x + attach, previous.coord.y + this.famBoxHeight / 2);
                this.svgGenerator.drawLine(box.coord.x + attach, previous.coord.y + this.famBoxHeight / 2, previous.coord.x, previous.coord.y + this.famBoxHeight / 2);
            } else {
                this.svgGenerator.drawLine(box.coord.x + attach, box.coord.y + this.indiBoxHeight, box.coord.x + attach, previous.coord.y + this.famBoxHeight / 2);
                this.svgGenerator.drawLine(box.coord.x + attach, previous.coord.y + this.famBoxHeight / 2, previous.coord.x + this.boxWidth, previous.coord.y + this.famBoxHeight / 2);
            }
        }
    }

    public class MyFormattingOptions {
        public FormattingMainOptions common = new FormattingMainOptions();
        public FormattingPedigreeOptions pedigree = new FormattingPedigreeOptions();
    }

    public class MyScope {
        public ScopeIndiMiniOptions common = new ScopeIndiMiniOptions();
        private int nbGenerations = 4;
    }

    public class Events {
        public boolean displayOccupation = true;
        public boolean displayResidence = true;
    }

    public class MyDataFormatOptions {
        public FormatIDOptions id = new FormatIDOptions();
        public FormatPlaceOptions place = new FormatPlaceOptions();
        public FormatDateOptions date = new FormatDateOptions();
    }

    public class MyColours {
        public PedigreeColorsOptions common = new PedigreeColorsOptions();
        public Color boxBackgroundFamColor = new Color(255, 255, 204);
        public Color boxBorderFamColor = new Color(255, 204, 0);
    }

    private abstract class Box {
        public int level;
        public Point p;
        public Box previous;
        public String[] labelLines;
        public Point coord;

        private Box() {
        }

        public abstract void setCoord(int var1, int var2);
    }

    private class Indibox
    extends Box {
        public Indibox(int level, Indi indi, Integer sosa, int nbGen, Box previous) {
            this.level = level;
            this.p = ReportPedigreeVertical.this.getPoint(nbGen, sosa);
            this.previous = previous;
            this.labelLines = new String[9];
            if (indi != null) {
                String id = ReportPedigreeVertical.this.dataFormatOptions.id.getId(indi);
                int i = 0;
                this.labelLines[i++] = String.valueOf(sosa) + (String)(id.isBlank() ? "" : " - " + id);
                this.labelLines[i++] = indi.getLastName();
                this.labelLines[i++] = indi.getFirstName();
                this.labelLines[i++] = TextOptions.getInstance().getBirthSymbol() + " " + ReportPedigreeVertical.this.dataFormatOptions.date.getDate((Property)indi.getBirthDateOption());
                this.labelLines[i++] = TextOptions.getInstance().getBirthSymbol() + " " + ReportPedigreeVertical.this.dataFormatOptions.place.getPlace((Property)indi.getBirthPlaceOption());
                this.labelLines[i++] = TextOptions.getInstance().getDeathSymbol() + " " + ReportPedigreeVertical.this.dataFormatOptions.date.getDate((Property)indi.getDeathDateOption());
                this.labelLines[i++] = TextOptions.getInstance().getDeathSymbol() + " " + ReportPedigreeVertical.this.dataFormatOptions.place.getPlace((Property)indi.getDeathPlaceOption());
                if (ReportPedigreeVertical.this.events.displayOccupation) {
                    Property[] occus = indi.getProperties("OCCU");
                    Property occu = occus.length > 0 ? occus[occus.length - 1] : null;
                    this.labelLines[i++] = TextOptions.getInstance().getOccuSymbol() + " " + (occu == null ? "" : occu.getDisplayValue());
                }
                if (ReportPedigreeVertical.this.events.displayResidence) {
                    Property[] resis = indi.getProperties("RESI");
                    Property resi = resis.length > 0 ? resis[resis.length - 1] : null;
                    this.labelLines[i++] = TextOptions.getInstance().getResiSymbol() + " " + (resi == null ? "" : ReportPedigreeVertical.this.dataFormatOptions.place.getPlace(resi.getProperty("PLAC")));
                }
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(String.valueOf(sosa));
                sb.append(" - ");
                sb.append(" ".repeat(5));
                this.labelLines[0] = sb.toString();
                this.labelLines[1] = "";
                this.labelLines[2] = "";
                this.labelLines[3] = "";
                this.labelLines[4] = "";
            }
        }

        @Override
        public void setCoord(int x, int y) {
            this.coord = new Point(x, y);
        }
    }

    private class Fambox
    extends Box {
        public Fambox(int level, Fam fam, Integer sosa, int nbGen, Box previous) {
            this.level = level;
            this.p = ReportPedigreeVertical.this.getPoint(nbGen, sosa);
            this.previous = previous;
            this.labelLines = new String[3];
            if (fam != null) {
                String id;
                int i = 0;
                String string = id = ReportPedigreeVertical.this.dataFormatOptions.id.displayId == 1 ? fam.getId() : "";
                if (!id.isBlank()) {
                    this.labelLines[i] = id;
                    ++i;
                }
                this.labelLines[i] = ReportPedigreeVertical.this.dataFormatOptions.date.getDate((Property)fam.getMarriageDate());
                this.labelLines[++i] = ReportPedigreeVertical.this.dataFormatOptions.place.getPlace((Property)fam.getMarriagePlace());
            } else {
                this.labelLines[0] = "";
            }
        }

        @Override
        public void setCoord(int x, int y) {
            this.coord = new Point(x, y);
        }
    }
}

