#!/bin/bash
# Tint2 toolbar quick settings- toggle toobar and menu colors, by PPC

        TEXTDOMAINDIR=/usr/share/locale
        TEXTDOMAIN=ft10_colors

dark(){
	FILE="$HOME/.config/tint2/tint2rc"
         sed -i 's:background_color =.*:\background_color = \#000000 95 \#ft10 toolbar background:' $FILE
         sed -i 's/task_font_color =.*/task_font_color = \#ffffff 100/' $FILE
         sed -i 's/clock_font_color =.*/clock_font_color = \#ffffff 100/' $FILE
         sed -i 's/execp_font_color =.*/execp_font_color = \#ffffff 100/' $FILE
         sed -i 's/tooltip_font_color =.*/tooltip_font_color = \#ffffff 100/' $FILE
         sed -i 's/battery_font_color =.*/battery_font_color = \#ffffff 100/' $FILE
         killall -9 tint2
		 nohup tint2 &
}

light(){
	FILE="$HOME/.config/tint2/tint2rc"
		##Original: #F0F0F0 ;  #BFC7C9 #C0C0C0 #c3c3c3 #818181 
	     sed -i 's:background_color =.*:\background_color = \#c3c3c3 95 \#ft10 toolbar background:' $FILE
         sed -i 's/task_font_color =.*/task_font_color = \#000000 100/' $FILE
         sed -i 's/clock_font_color =.*/clock_font_color = \#000000 100/' $FILE
         sed -i 's/execp_font_color =.*/execp_font_color = \#000000 100/' $FILE
         sed -i 's/tooltip_font_color =.*/tooltip_font_color = \#000000 100/' $FILE
         sed -i 's/battery_font_color =.*/battery_font_color = \#000000 100/' $FILE
         killall -9 tint2
		 nohup tint2 &
}

blue(){
	FILE="$HOME/.config/tint2/tint2rc"
	     sed -i 's:background_color =.*:\background_color = \#012B4E 95 \#ft10 toolbar background:' $FILE
         sed -i 's/task_font_color =.*/task_font_color = \#ffffff 100/' $FILE
         sed -i 's/clock_font_color =.*/clock_font_color = \#ffffff 100/' $FILE
         sed -i 's/execp_font_color =.*/execp_font_color = \#ffffff 100/' $FILE
         sed -i 's/tooltip_font_color =.*/tooltip_font_color = \#ffffff 100/' $FILE
         sed -i 's/battery_font_color =.*/battery_font_color = \#ffffff 100/' $FILE
         killall -9 tint2
		 nohup tint2 &
}

gray(){

	FILE="$HOME/.config/tint2/tint2rc"
	 sed -i 's:background_color =.*:\background_color = \#2D2D2D 95 \#ft10 toolbar background:' $FILE
         sed -i 's/task_font_color =.*/task_font_color = \#ffffff 100/' $FILE
         sed -i 's/clock_font_color =.*/clock_font_color = \#ffffff 100/' $FILE
         sed -i 's/execp_font_color =.*/execp_font_color = \#ffffff 100/' $FILE
         sed -i 's/tooltip_font_color =.*/tooltip_font_color = \#ffffff 100/' $FILE
         sed -i 's/battery_font_color =.*/battery_font_color = \#ffffff 100/' $FILE
         killall -9 tint2
		 nohup tint2 &
}

yellow(){

	FILE="$HOME/.config/tint2/tint2rc"
	 sed -i 's:background_color =.*:\background_color = \#FF8C00 95 \#ft10 toolbar background:' $FILE
         sed -i 's/task_font_color =.*/task_font_color = \#ffffff 100/' $FILE
         sed -i 's/clock_font_color =.*/clock_font_color = \#ffffff 100/' $FILE
         sed -i 's/execp_font_color =.*/execp_font_color = \#ffffff 100/' $FILE
         sed -i 's/tooltip_font_color =.*/tooltip_font_color = \#ffffff 100/' $FILE
         sed -i 's/battery_font_color =.*/battery_font_color = \#ffffff 100/' $FILE
         killall -9 tint2
		 nohup tint2 &
}

pink(){

	FILE="$HOME/.config/tint2/tint2rc"
	 sed -i 's:background_color =.*:\background_color = \#BF0077 95 \#ft10 toolbar background:' $FILE
         sed -i 's/task_font_color =.*/task_font_color = \#ffffff 100/' $FILE
         sed -i 's/clock_font_color =.*/clock_font_color = \#ffffff 100/' $FILE
         sed -i 's/execp_font_color =.*/execp_font_color = \#ffffff 100/' $FILE
         sed -i 's/tooltip_font_color =.*/tooltip_font_color = \#ffffff 100/' $FILE
         sed -i 's/battery_font_color =.*/battery_font_color = \#ffffff 100/' $FILE
         killall -9 tint2
		 nohup tint2 &
}

green(){

	FILE="$HOME/.config/tint2/tint2rc"
	 sed -i 's:background_color =.*:\background_color = \#0F883D 95 \#ft10 toolbar background:' $FILE
         sed -i 's/task_font_color =.*/task_font_color = \#ffffff 100/' $FILE
         sed -i 's/clock_font_color =.*/clock_font_color = \#ffffff 100/' $FILE
         sed -i 's/execp_font_color =.*/execp_font_color = \#ffffff 100/' $FILE
         sed -i 's/tooltip_font_color =.*/tooltip_font_color = \#ffffff 100/' $FILE
         sed -i 's/battery_font_color =.*/battery_font_color = \#ffffff 100/' $FILE
         killall -9 tint2
		 nohup tint2 &
}

red(){

	FILE="$HOME/.config/tint2/tint2rc"
	 sed -i 's:background_color =.*:\background_color = \#E71022 95 \#ft10 toolbar background:' $FILE
         sed -i 's/task_font_color =.*/task_font_color = \#ffffff 100/' $FILE
         sed -i 's/clock_font_color =.*/clock_font_color = \#ffffff 100/' $FILE
         sed -i 's/execp_font_color =.*/execp_font_color = \#ffffff 100/' $FILE
         sed -i 's/tooltip_font_color =.*/tooltip_font_color = \#ffffff 100/' $FILE
         sed -i 's/battery_font_color =.*/battery_font_color = \#ffffff 100/' $FILE
         killall -9 tint2
		 nohup tint2 &
}

pick_color() {
FILE="$HOME/.config/tint2/tint2rc"
value=$(yad-color)

if [ -n "$value" ]; then
    echo "not empty"
    sed -i "s:background_color =.*:\background_color = $value:" $FILE
killall -9 tint2
nohup tint2 &
else
    echo "empty"
fi

}

#BF0077
export -f dark light blue gray yellow pink green red pick_color

#get localization for the title of the window
export TEXTDOMAIN=ft10_tint2_manager;  colors_title=$(gettext 'Toolbar and menu color')

#Main menu
choice=$(yad  --width=400 --title="FT10 - $colors_title" --center  --form \
	--window-icon="/usr/share/icons/papirus-antix/48x48/actions/cm_options.png"\
	--columns=2 \
	--field="!/usr/local/lib/ft10/icons/Dark-mode.png!":BTN "bash -c dark" \
    --field="!/usr/local/lib/ft10/icons/Light-mode.png!":BTN "bash -c light" \
	--field="!/usr/local/lib/ft10/icons/Blue.png!":BTN "bash -c blue" \
	--field="!/usr/local/lib/ft10/icons/yellow.png!":BTN "bash -c yellow" \
	--field="...!/usr/share/icons/papirus-antix/48x48/categories/color-picker.png!":BTN "bash -c pick_color" \
	--field="!/usr/local/lib/ft10/icons/DarkGray.png!":BTN "bash -c gray" \
	--field="!/usr/local/lib/ft10/icons/pink.png!":BTN "bash -c pink" \
	--field="!/usr/local/lib/ft10/icons/green.png!":BTN "bash -c green" \
	--field="!/usr/local/lib/ft10/icons/red.png!":BTN "bash -c red" \
	--button=' lxappearance ':"bash -c lxappearance")
