/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import com.google.common.collect.ImmutableSet;
import org.kohsuke.args4j.Option;
import org.zanata.client.commands.ConfigurableProjectOptionsImpl;
import org.zanata.client.commands.PushPullCommand;
import org.zanata.client.commands.PushPullOptions;
import org.zanata.client.config.LocaleList;

public abstract class AbstractPushPullOptionsImpl<O extends PushPullOptions>
extends ConfigurableProjectOptionsImpl
implements PushPullOptions {
    protected static final String PROJECT_TYPE_FILE = "file";
    private static final String DEF_FROM_DOC = null;
    private static final boolean DEFAULT_DRY_RUN = false;
    protected String[] locales;
    private LocaleList effectiveLocales;
    private String fromDoc = DEF_FROM_DOC;
    private boolean dryRun = false;

    @Override
    public LocaleList getLocaleMapList() {
        if (this.effectiveLocales == null) {
            this.effectiveLocales = PushPullCommand.getLocaleMapList(super.getLocaleMapList(), this.locales);
        }
        return this.effectiveLocales;
    }

    @Override
    public String getSrcDirParameterName() {
        return "--src-dir";
    }

    @Override
    public String getFromDoc() {
        return this.fromDoc;
    }

    @Override
    public String buildFromDocArgument(String argValue) {
        return "--from-doc \"" + argValue + "\"";
    }

    @Option(name="--from-doc", metaVar="DOCID", required=false, usage="Specifies a document from which to begin the operation. Documents before this document (sorted alphabetically) will be skipped.\nUse this option to resume a failed operation.")
    public void setFromDoc(String fromDoc) {
        this.fromDoc = fromDoc;
    }

    @Override
    public boolean isDryRun() {
        return this.dryRun;
    }

    @Option(aliases={"-n"}, name="--dry-run", usage="Dry run: don't change any data, on the server or on the filesystem.")
    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    @Override
    public boolean getEnableModules() {
        return false;
    }

    @Override
    public String getDocNameRegex() {
        return null;
    }

    @Override
    public String getModuleSuffix() {
        return null;
    }

    @Override
    public boolean isRootModule() {
        return false;
    }

    @Override
    public String getCurrentModule() {
        return "";
    }

    @Override
    public String getCurrentModule(boolean canonicalName) {
        return "";
    }

    @Override
    public ImmutableSet<String> getAllModules() {
        return ImmutableSet.of();
    }
}

