/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.adapter.xliff;

import com.google.common.base.Charsets;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.zanata.adapter.xliff.XliffCommon;
import org.zanata.common.ContentState;
import org.zanata.common.ContentType;
import org.zanata.common.LocaleId;
import org.zanata.rest.dto.ExtensionValue;
import org.zanata.rest.dto.extensions.comment.SimpleComment;
import org.zanata.rest.dto.resource.ExtensionSet;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TextFlow;
import org.zanata.rest.dto.resource.TextFlowTarget;
import org.zanata.rest.dto.resource.TranslationsResource;
import org.zanata.util.HashUtil;

public class XliffReader
extends XliffCommon {
    private static final Logger log = LoggerFactory.getLogger(XliffReader.class);
    private final SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private final XMLInputFactory xmlif = XMLInputFactory.newInstance();
    private LocaleId srcLang;
    private XliffCommon.ValidationType validationType;

    public Resource extractTemplate(File file, LocaleId sourceLocaleId, String docName, String validationType) throws FileNotFoundException {
        Resource document = new Resource(docName);
        document.setContentType(ContentType.TextPlain);
        document.setLang(sourceLocaleId);
        this.srcLang = sourceLocaleId;
        this.validationType = XliffCommon.ValidationType.valueOf(validationType.toUpperCase());
        this.extractXliff(file, document, null);
        return document;
    }

    public TranslationsResource extractTarget(File file) throws FileNotFoundException {
        TranslationsResource document = new TranslationsResource();
        this.extractXliff(file, null, document);
        return document;
    }

    private void validateXliffFile(StreamSource source) {
        try {
            StreamSource schemaSource = new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream("schema/xliff-core-1.1.xsd"));
            this.factory.setResourceResolver(new LSResourceResolver(){

                @Override
                public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                    InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream("schema/" + systemId);
                    return new Input(publicId, systemId, resourceAsStream);
                }
            });
            Schema schema = this.factory.newSchema(schemaSource);
            Validator validator = schema.newValidator();
            validator.validate(source);
        }
        catch (SAXException saxException) {
            throw new RuntimeException("Invalid XLIFF file format", saxException);
        }
        catch (IOException ioException) {
            throw new RuntimeException("Invalid XLIFF file format", ioException);
        }
    }

    private void extractXliff(@Nonnull File file, @Nullable Resource document, @Nullable TranslationsResource transDoc) throws FileNotFoundException {
        assert (document != null || transDoc != null);
        if (this.validationType == XliffCommon.ValidationType.XSD) {
            this.validateXliffFile(new StreamSource(file));
        }
        try {
            this.xmlif.setProperty("javax.xml.stream.isCoalescing", true);
            InputSource inputSource = new InputSource(new FileInputStream(file));
            inputSource.setEncoding("utf8");
            XMLStreamReader xmlr = this.xmlif.createXMLStreamReader(inputSource.getByteStream());
            int fileCount = 0;
            boolean inFile = false;
            while (xmlr.hasNext()) {
                xmlr.next();
                if (XliffReader.isStartElement(xmlr, "file")) {
                    inFile = true;
                    if (++fileCount > 1) {
                        log.warn("multiple 'file' elements not supported: ignoring the rest of the file '{}'", (Object)file);
                        break;
                    }
                    log.debug("start file element");
                    continue;
                }
                if (XliffReader.isStartElement(xmlr, "trans-unit")) {
                    TextFlowTarget tfTarget;
                    if (!inFile) {
                        throw new RuntimeException("'trans-unit' must appear inside 'file' element: ignoring the rest of the file " + file);
                    }
                    if (document != null) {
                        TextFlow textFlow = this.extractTransUnit(xmlr);
                        document.getTextFlows().add(textFlow);
                        continue;
                    }
                    if (transDoc == null || (tfTarget = this.extractTransUnitTarget(xmlr)).getState() == ContentState.New) continue;
                    transDoc.getTextFlowTargets().add(tfTarget);
                    continue;
                }
                if (!XliffReader.isEndElement(xmlr, "file")) continue;
                inFile = false;
                log.debug("end file element");
            }
            xmlr.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Invalid XLIFF file format", e);
        }
    }

    private TextFlow extractTransUnit(XMLStreamReader xmlr) throws XMLStreamException {
        TextFlow textFlow = new TextFlow();
        Boolean endTransUnit = false;
        String id = this.getAttributeValue(xmlr, "id");
        textFlow.setId(id);
        while (xmlr.hasNext() && !endTransUnit.booleanValue()) {
            xmlr.next();
            if (XliffReader.isEndElement(xmlr, "trans-unit")) {
                endTransUnit = true;
                continue;
            }
            if (XliffReader.isStartElement(xmlr, "source")) {
                String content = this.getElementValue(xmlr, "source", XliffReader.getContentElementList());
                textFlow.setContents(new String[]{content});
                continue;
            }
            if (!XliffReader.isStartElement(xmlr, "context-group")) continue;
            textFlow.getExtensions(true).addAll(this.extractContextList(xmlr));
        }
        textFlow.setLang(this.srcLang);
        return textFlow;
    }

    private TextFlowTarget extractTransUnitTarget(XMLStreamReader xmlr) throws XMLStreamException {
        TextFlowTarget textFlowTarget = new TextFlowTarget();
        textFlowTarget.setResId(this.getAttributeValue(xmlr, "id"));
        String sourceContent = "";
        String targetContent = "";
        boolean endTransUnit = false;
        while (xmlr.hasNext() && !endTransUnit) {
            xmlr.next();
            if (XliffReader.isEndElement(xmlr, "trans-unit")) {
                endTransUnit = true;
                continue;
            }
            if (XliffReader.isStartElement(xmlr, "source")) {
                sourceContent = this.getElementValue(xmlr, "source", XliffReader.getContentElementList());
                String sourceHash = HashUtil.sourceHash((String)sourceContent);
                textFlowTarget.setSourceHash(sourceHash);
                continue;
            }
            if (XliffReader.isStartElement(xmlr, "target")) {
                targetContent = this.getElementValue(xmlr, "target", XliffReader.getContentElementList());
                textFlowTarget.setContents(Arrays.asList(targetContent));
                continue;
            }
            if (!XliffReader.isStartElement(xmlr, "context-group")) continue;
            textFlowTarget.getExtensions(true).addAll(this.extractContextList(xmlr));
        }
        if (targetContent.isEmpty()) {
            textFlowTarget.setState(ContentState.New);
        } else {
            textFlowTarget.setState(ContentState.Translated);
        }
        return textFlowTarget;
    }

    private ExtensionSet<SimpleComment> extractContextList(XMLStreamReader xmlr) throws XMLStreamException {
        ExtensionSet contextList = new ExtensionSet();
        Boolean endContextGroup = false;
        String contextGroup = this.getAttributeValue(xmlr, "name");
        while (xmlr.hasNext() && !endContextGroup.booleanValue()) {
            xmlr.next();
            if (XliffReader.isEndElement(xmlr, "context-group")) {
                endContextGroup = true;
                continue;
            }
            if (!XliffReader.isStartElement(xmlr, "context")) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(contextGroup);
            sb.append("::");
            sb.append(this.getAttributeValue(xmlr, "context-type"));
            sb.append("::");
            sb.append(this.getElementValue(xmlr, "context", null));
            contextList.add((ExtensionValue)new SimpleComment(sb.toString()));
        }
        return contextList;
    }

    private String getElementValue(XMLStreamReader reader, String elementName, Collection<String> legalElements) throws XMLStreamException {
        boolean keepReading = true;
        StringBuilder contents = new StringBuilder();
        reader.next();
        if (XliffReader.isElement(reader, elementName)) {
            keepReading = false;
        }
        while (keepReading) {
            if (reader.hasText()) {
                contents.append(reader.getText());
            } else if (reader.isStartElement() || reader.isEndElement()) {
                String localName = XliffReader.getLocalName(reader);
                if (legalElements == null || legalElements.contains(localName)) {
                    throw new RuntimeException("Sorry, Zanata does not support elements inside " + elementName + ": " + localName);
                }
                throw new RuntimeException("Invalid XLIFF: " + localName + " is not legal inside " + elementName);
            }
            reader.next();
            if (!XliffReader.isElement(reader, elementName)) continue;
            keepReading = false;
        }
        return contents.toString();
    }

    private static String getLocalName(XMLStreamReader xmlr) {
        if (xmlr.isCharacters()) {
            return "";
        }
        return xmlr.getLocalName();
    }

    private static boolean isElement(XMLStreamReader xmlr, String elementLocalName) {
        return (xmlr.isStartElement() || xmlr.isEndElement()) && XliffReader.getLocalName(xmlr).equals(elementLocalName);
    }

    private static boolean isEndElement(XMLStreamReader xmlr, String elementLocalName) {
        return xmlr.isEndElement() && XliffReader.getLocalName(xmlr).equals(elementLocalName);
    }

    private static boolean isStartElement(XMLStreamReader xmlr, String elementLocalName) {
        return xmlr.isStartElement() && XliffReader.getLocalName(xmlr).equals(elementLocalName);
    }

    private String getAttributeValue(XMLStreamReader xmlr, String attrKey) {
        int count = xmlr.getAttributeCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                if (!xmlr.getAttributeLocalName(i).equals(attrKey)) continue;
                return xmlr.getAttributeValue(i);
            }
        }
        return null;
    }

    public static class Input
    implements LSInput {
        private String publicId;
        private String systemId;
        private BufferedInputStream inputStream;

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public InputStream getByteStream() {
            return null;
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getStringData() {
            BufferedInputStream bufferedInputStream = this.inputStream;
            synchronized (bufferedInputStream) {
                try {
                    byte[] input = new byte[this.inputStream.available()];
                    this.inputStream.read(input);
                    String contents = new String(input, Charsets.UTF_8);
                    return contents;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.out.println("Exception " + e);
                    return null;
                }
            }
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        public BufferedInputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(BufferedInputStream inputStream) {
            this.inputStream = inputStream;
        }

        public Input(String publicId, String sysId, InputStream input) {
            this.publicId = publicId;
            this.systemId = sysId;
            this.inputStream = new BufferedInputStream(input);
        }
    }
}

