/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import java.net.URI;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.zanata.rest.RestUtil;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.stats.ContainerTranslationStatistics;
import org.zanata.rest.dto.stats.contribution.ContributionStatistics;
import org.zanata.rest.service.StatisticsResource;

public class StatisticsResourceClient
implements StatisticsResource {
    private final RestClientFactory factory;
    private final URI baseUri;

    StatisticsResourceClient(RestClientFactory factory) {
        this.factory = factory;
        this.baseUri = factory.getBaseUri();
    }

    public ContainerTranslationStatistics getStatistics(String projectSlug, String iterationSlug, @DefaultValue(value="false") boolean includeDetails, @DefaultValue(value="false") boolean includeWordStats, String[] locales) {
        WebTarget webResource = this.factory.getClient().target(this.baseUri).path("stats").path("proj").path(projectSlug).path("iter").path(iterationSlug).queryParam("detail", new Object[]{includeDetails}).queryParam("word", new Object[]{includeWordStats}).queryParam("locale", (Object[])locales);
        return (ContainerTranslationStatistics)webResource.request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(ContainerTranslationStatistics.class);
    }

    @Deprecated
    public ContainerTranslationStatistics getStatistics(String projectSlug, String iterationSlug, String docId, @DefaultValue(value="false") boolean includeWordStats, String[] locales) {
        return this.getStatisticsWithDocId(projectSlug, iterationSlug, docId, includeWordStats, locales);
    }

    public ContainerTranslationStatistics getStatisticsWithDocId(String projectSlug, String iterationSlug, String docId, boolean includeWordStats, String[] locales) {
        WebTarget webResource = this.factory.getClient().target(this.baseUri).path("stats").path("proj").path(projectSlug).path("iter").path(iterationSlug).path("doc").queryParam("docId", new Object[]{docId}).queryParam("word", new Object[]{String.valueOf(includeWordStats)}).queryParam("locale", (Object[])locales);
        try {
            return (ContainerTranslationStatistics)webResource.request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(ContainerTranslationStatistics.class);
        }
        catch (ResponseProcessingException e) {
            if (RestUtil.isNotFound((Response)e.getResponse())) {
                webResource = this.factory.getClient().target(this.baseUri).path("stats").path("proj").path(projectSlug).path("iter").path(iterationSlug).path("doc").path(docId).queryParam("word", new Object[]{String.valueOf(includeWordStats)}).queryParam("locale", (Object[])locales);
                return (ContainerTranslationStatistics)webResource.request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(ContainerTranslationStatistics.class);
            }
            throw e;
        }
    }

    public ContributionStatistics getContributionStatistics(String projectSlug, String versionSlug, String username, String dateRange, boolean includeAutomatedEntry) {
        WebTarget webResource = this.factory.getClient().target(this.baseUri).path("stats").path("project").path(projectSlug).path("version").path(versionSlug).path("contributor").path(username).path(dateRange).queryParam("includeAutomatedEntry", new Object[]{includeAutomatedEntry});
        return (ContributionStatistics)webResource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(ContributionStatistics.class);
    }

    public Response getProjectStatisticsMatrix(String projectSlug, String versionSlug, String dateRangeParam, String timeZoneID) {
        throw new UnsupportedOperationException("This method is not supported in client");
    }
}

