/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import java.net.URI;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.ProjectIteration;

public class ProjectIterationClient {
    private final RestClientFactory factory;
    private final String projectSlug;
    private final String versionSlug;
    private URI baseUri;

    ProjectIterationClient(RestClientFactory factory, String projectSlug, String versionSlug) {
        this.factory = factory;
        this.projectSlug = projectSlug;
        this.versionSlug = versionSlug;
        this.baseUri = factory.getBaseUri();
    }

    public ProjectIteration get() {
        return (ProjectIteration)this.webResource().request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(ProjectIteration.class);
    }

    private WebTarget webResource() {
        return this.factory.getClient().target(this.baseUri).path("projects").path("p").path(this.projectSlug).path("iterations").path("i").path(this.versionSlug);
    }

    public Response put(ProjectIteration projectVersion) {
        Response response = this.webResource().request().put(Entity.xml((Object)projectVersion));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            throw new RuntimeException(response.getStatusInfo().toString());
        }
        response.close();
        return response;
    }

    public String sampleConfiguration() {
        return (String)this.webResource().path("config").request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(String.class);
    }
}

