/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.zanata.common.LocaleId;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.GlossaryEntry;
import org.zanata.rest.dto.QualifiedName;

public class GlossaryClient {
    private final RestClientFactory factory;
    private final URI baseUri;

    GlossaryClient(RestClientFactory factory) {
        this.factory = factory;
        this.baseUri = factory.getBaseUri();
    }

    public Response post(List<GlossaryEntry> glossaryEntries, LocaleId localeId, String qualifiedName) {
        Entity entity = Entity.json(glossaryEntries);
        Response response = this.webResource().path("entries").queryParam("locale", new Object[]{localeId.getId()}).queryParam("qualifiedName", new Object[]{qualifiedName}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(entity);
        response.close();
        return response;
    }

    public Response downloadFile(String fileType, ImmutableList<String> transLang, String qualifiedName) {
        if (transLang != null && !transLang.isEmpty()) {
            return this.webResource().path("file").queryParam("fileType", new Object[]{fileType}).queryParam("locales", new Object[]{Joiner.on((String)",").join(transLang)}).queryParam("qualifiedName", new Object[]{qualifiedName}).request(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).get();
        }
        return this.webResource().path("file").queryParam("fileType", new Object[]{fileType}).queryParam("qualifiedName", new Object[]{qualifiedName}).request(new MediaType[]{MediaType.APPLICATION_OCTET_STREAM_TYPE}).get();
    }

    public void delete(String id, String qualifiedName) {
        this.webResource().path("entries/" + id).queryParam("qualifiedName", new Object[]{qualifiedName}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete().close();
    }

    public int deleteAll(String qualifiedName) {
        return (Integer)this.webResource().queryParam("qualifiedName", new Object[]{qualifiedName}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).delete(Integer.class);
    }

    public String getProjectQualifiedName(String projectSlug) {
        return ((QualifiedName)this.projectGlossaryWebResource(projectSlug).path("qualifiedName").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(QualifiedName.class)).getName();
    }

    public String getGlobalQualifiedName() {
        return ((QualifiedName)this.webResource().path("qualifiedName").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(QualifiedName.class)).getName();
    }

    private WebTarget webResource() {
        return this.factory.getClient().target(this.baseUri).path("/glossary");
    }

    private WebTarget projectGlossaryWebResource(String projectSlug) {
        return this.factory.getClient().target(this.factory.getBaseUri()).path("projects").path("p").path(projectSlug).path("glossary");
    }
}

