/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import java.net.URI;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.CopyTransStatus;
import org.zanata.rest.service.CopyTransResource;

public class CopyTransClient
implements CopyTransResource {
    private final RestClientFactory factory;
    private final URI baseUri;

    CopyTransClient(RestClientFactory factory) {
        this.factory = factory;
        this.baseUri = factory.getBaseUri();
    }

    public CopyTransStatus startCopyTrans(String projectSlug, String iterationSlug, String docId) {
        Client client = this.factory.getClient();
        Response response = this.webResource(client, projectSlug, iterationSlug, docId).post(Entity.json((Object)""));
        response.bufferEntity();
        return (CopyTransStatus)response.readEntity(CopyTransStatus.class);
    }

    private Invocation.Builder webResource(Client client, String projectSlug, String iterationSlug, String docId) {
        return client.target(this.baseUri).path("/copytrans").path("/proj").path(projectSlug).path("iter").path(iterationSlug).path("doc").path(docId).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE});
    }

    public CopyTransStatus getCopyTransStatus(String projectSlug, String iterationSlug, String docId) {
        return (CopyTransStatus)this.webResource(this.factory.getClient(), projectSlug, iterationSlug, docId).get(CopyTransStatus.class);
    }
}

