/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.rest.client;

import java.net.URI;
import java.util.Set;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.zanata.common.LocaleId;
import org.zanata.rest.RestUtil;
import org.zanata.rest.client.RestClientFactory;
import org.zanata.rest.dto.ProcessStatus;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;
import org.zanata.rest.service.AsynchronousProcessResource;

public class AsyncProcessClient
implements AsynchronousProcessResource {
    private final RestClientFactory factory;
    private final URI baseUri;

    AsyncProcessClient(RestClientFactory factory) {
        this.factory = factory;
        this.baseUri = factory.getBaseUri();
    }

    @Deprecated
    public ProcessStatus startSourceDocCreation(String idNoSlash, String projectSlug, String iterationSlug, Resource resource, Set<String> extensions, @DefaultValue(value="true") boolean copytrans) {
        throw new UnsupportedOperationException("Not supported. Use startSourceDocCreationOrUpdate instead.");
    }

    @Deprecated
    public ProcessStatus startSourceDocCreationOrUpdate(String idNoSlash, String projectSlug, String iterationSlug, Resource resource, Set<String> extensions, @DefaultValue(value="true") boolean copytrans) {
        Client client = this.factory.getClient();
        WebTarget webResource = client.target(this.baseUri).path("/async").path("projects").path("p").path(projectSlug).path("iterations").path("i").path(iterationSlug).path("r").path(idNoSlash);
        Response response = webResource.queryParam("ext", extensions.toArray()).queryParam("copyTrans", new Object[]{String.valueOf(copytrans)}).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).put(Entity.xml((Object)resource));
        response.bufferEntity();
        return (ProcessStatus)response.readEntity(ProcessStatus.class);
    }

    public ProcessStatus startSourceDocCreationOrUpdateWithDocId(String projectSlug, String iterationSlug, Resource resource, Set<String> extensions, String docId) {
        Client client = this.factory.getClient();
        WebTarget webResource = client.target(this.baseUri).path("/async").path("projects").path("p").path(projectSlug).path("iterations").path("i").path(iterationSlug).path("resource");
        try {
            Response response = webResource.queryParam("docId", new Object[]{docId}).queryParam("ext", extensions.toArray()).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).put(Entity.xml((Object)resource));
            response.bufferEntity();
            return (ProcessStatus)response.readEntity(ProcessStatus.class);
        }
        catch (ResponseProcessingException e) {
            if (RestUtil.isNotFound((Response)e.getResponse())) {
                String idNoSlash = RestUtil.convertToDocumentURIId((String)docId);
                return this.startSourceDocCreationOrUpdate(idNoSlash, projectSlug, iterationSlug, resource, extensions, false);
            }
            throw e;
        }
    }

    @Deprecated
    public ProcessStatus startTranslatedDocCreationOrUpdate(String idNoSlash, String projectSlug, String iterationSlug, LocaleId locale, TranslationsResource translatedDoc, Set<String> extensions, String merge, @DefaultValue(value="false") boolean myTrans) {
        Client client = this.factory.getClient();
        WebTarget webResource = client.target(this.baseUri).path("/async").path("projects").path("p").path(projectSlug).path("iterations").path("i").path(iterationSlug).path("r").path(idNoSlash).path("translations").path(locale.toString());
        Response response = webResource.queryParam("ext", extensions.toArray()).queryParam("merge", new Object[]{merge}).queryParam("assignCreditToUploader", new Object[]{String.valueOf(myTrans)}).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).put(Entity.xml((Object)translatedDoc));
        response.bufferEntity();
        return (ProcessStatus)response.readEntity(ProcessStatus.class);
    }

    public ProcessStatus startTranslatedDocCreationOrUpdateWithDocId(String projectSlug, String iterationSlug, LocaleId locale, TranslationsResource translatedDoc, String docId, Set<String> extensions, String merge, boolean assignCreditToUploader) {
        Client client = this.factory.getClient();
        WebTarget webResource = client.target(this.baseUri).path("/async").path("projects").path("p").path(projectSlug).path("iterations").path("i").path(iterationSlug).path("resource").path("translations").path(locale.toString());
        try {
            Response response = webResource.queryParam("docId", new Object[]{docId}).queryParam("ext", extensions.toArray()).queryParam("merge", new Object[]{merge}).queryParam("assignCreditToUploader", new Object[]{String.valueOf(assignCreditToUploader)}).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).put(Entity.xml((Object)translatedDoc));
            response.bufferEntity();
            return (ProcessStatus)response.readEntity(ProcessStatus.class);
        }
        catch (ResponseProcessingException e) {
            if (RestUtil.isNotFound((Response)e.getResponse())) {
                String idNoSlash = RestUtil.convertToDocumentURIId((String)docId);
                return this.startTranslatedDocCreationOrUpdate(idNoSlash, projectSlug, iterationSlug, locale, translatedDoc, extensions, merge, assignCreditToUploader);
            }
            throw e;
        }
    }

    public ProcessStatus getProcessStatus(String processId) {
        return (ProcessStatus)this.factory.getClient().target(this.baseUri).path("/async").path(processId).request(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(ProcessStatus.class);
    }
}

