/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.unit.actions;

import com.unciv.GUI;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.transients.CivInfoTransientCache;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.UncivSound;
import com.unciv.models.UnitAction;
import com.unciv.models.UnitActionType;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u001f\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u0012"}, d2={"Lcom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsPillage;", "", "<init>", "()V", "getPillageActions", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/UnitAction;", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "getPillageActions$core", "getPillageAction", "getPillageAction$core", "pillageLooting", "", "canPillage", "", "core"})
@SourceDebugExtension(value={"SMAP\nUnitActionsPillage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitActionsPillage.kt\ncom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsPillage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n1#2:155\n2423#3,14:156\n*S KotlinDebug\n*F\n+ 1 UnitActionsPillage.kt\ncom/unciv/ui/screens/worldscreen/unit/actions/UnitActionsPillage\n*L\n83#1:156,14\n*E\n"})
public final class UnitActionsPillage {
    @NotNull
    public static final UnitActionsPillage INSTANCE = new UnitActionsPillage();

    private UnitActionsPillage() {
    }

    @NotNull
    public final Sequence<UnitAction> getPillageActions$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        UnitAction unitAction = this.getPillageAction$core(unit, tile);
        if (unitAction == null) {
            return SequencesKt.emptySequence();
        }
        UnitAction pillageAction = unitAction;
        if (pillageAction.getAction() == null || unit.getCiv().isAIOrAutoPlaying()) {
            return SequencesKt.sequenceOf(pillageAction);
        }
        return SequencesKt.sequenceOf(new UnitAction(UnitActionType.Pillage, 65.0f, pillageAction.getTitle(), false, null, null, () -> UnitActionsPillage.getPillageActions$lambda$0(tile, pillageAction), 56, null));
    }

    @Nullable
    public final UnitAction getPillageAction$core(@NotNull MapUnit unit, @NotNull Tile tile) {
        Function0<Unit> function0;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        String improvementName = unit.getCurrentTile().getImprovementToPillageName();
        if (unit.isCivilian() || improvementName == null || Intrinsics.areEqual(tile.getOwner(), unit.getCiv())) {
            return null;
        }
        Function0<Unit> function02 = function0 = () -> UnitActionsPillage.getPillageAction$lambda$0(unit, tile);
        Unique unique = null;
        UncivSound uncivSound = null;
        boolean bl = false;
        String string = (Object)((Object)UnitActionType.Pillage) + " [" + improvementName + ']';
        float f = 65.0f;
        UnitActionType unitActionType = UnitActionType.Pillage;
        boolean bl2 = false;
        boolean bl3 = unit.hasMovement() && INSTANCE.canPillage(unit, tile);
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 56;
        Function0<Unit> function03 = bl3 ? function0 : null;
        Unique unique2 = unique;
        UncivSound uncivSound2 = uncivSound;
        boolean bl4 = bl;
        String string2 = string;
        float f2 = f;
        UnitActionType unitActionType2 = unitActionType;
        return new UnitAction(unitActionType2, f2, string2, bl4, uncivSound2, unique2, function03, n, defaultConstructorMarker);
    }

    private final void pillageLooting(Tile tile, MapUnit unit) {
        float value;
        Stat stat;
        Unique unique;
        Object v0;
        Iterable $this$minByOrNull$iv = unit.getCiv().getCities();
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                City it = (City)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getCenterTile().aerialDistanceTo(tile);
                do {
                    Object e$iv = iterator$iv.next();
                    City it2 = (City)e$iv;
                    $i$a$-minByOrNull-UnitActionsPillage$pillageLooting$closestCity$1 = false;
                    int v$iv = it2.getCenterTile().aerialDistanceTo(tile);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        City closestCity = v0;
        TileImprovement tileImprovement = tile.getImprovementToPillage();
        Intrinsics.checkNotNull(tileImprovement);
        TileImprovement improvement = tileImprovement;
        Stats pillageYield = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        GameContext stateForConditionals = unit.getCache().getState();
        Random random = RandomKt.Random((long)unit.getCiv().getGameInfo().getTurns() * (long)unit.getTile().getPosition().hashCode());
        Iterator<Unique> minValue$iv = improvement.getMatchingUniques(UniqueType.PillageYieldRandom, stateForConditionals).iterator();
        while (minValue$iv.hasNext()) {
            unique = minValue$iv.next();
            for (Stats.StatValuePair statValuePair : unique.getStats()) {
                stat = statValuePair.component1();
                value = statValuePair.component2();
                Stats yieldsToAdd = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
                yieldsToAdd.add(stat, (float)random.nextInt((int)(value + 1.0f)) + (float)random.nextInt((int)(value + 1.0f)));
                if (unique.isModifiedByGameSpeed()) {
                    yieldsToAdd = yieldsToAdd.times(unit.getCiv().getGameInfo().getSpeed().getModifier());
                }
                if (unique.isModifiedByGameProgress()) {
                    yieldsToAdd = yieldsToAdd.times(unique.getGameProgressModifier(unit.getCiv()));
                }
                pillageYield.add(yieldsToAdd);
            }
        }
        minValue$iv = improvement.getMatchingUniques(UniqueType.PillageYieldFixed, stateForConditionals).iterator();
        while (minValue$iv.hasNext()) {
            unique = minValue$iv.next();
            Stats yieldsToAdd = unique.getStats();
            if (unique.isModifiedByGameSpeed()) {
                yieldsToAdd = yieldsToAdd.times(unit.getCiv().getGameInfo().getSpeed().getModifier());
            }
            if (unique.isModifiedByGameProgress()) {
                yieldsToAdd = yieldsToAdd.times(unique.getGameProgressModifier(unit.getCiv()));
            }
            pillageYield.add(yieldsToAdd);
        }
        minValue$iv = MapUnit.getMatchingUniques$default(unit, UniqueType.PercentYieldFromPillaging, null, true, 2, null).iterator();
        while (minValue$iv.hasNext()) {
            unique = minValue$iv.next();
            pillageYield = pillageYield.times(FormattingExtensionsKt.toPercent(unique.getParams().get(0)));
        }
        if (pillageYield.isEmpty()) {
            return;
        }
        Stats globalPillageYield = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        Stats toCityPillageYield = new Stats(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 127, null);
        for (Stats.StatValuePair statValuePair : pillageYield) {
            stat = statValuePair.component1();
            value = statValuePair.component2();
            if (Stat.Companion.getStatsWithCivWideField().contains(stat)) {
                unit.getCiv().addStat(stat, (int)value);
                globalPillageYield.set(stat, globalPillageYield.get(stat) + value);
                continue;
            }
            if (closestCity == null) continue;
            closestCity.addStat(stat, (int)value);
            toCityPillageYield.set(stat, toCityPillageYield.get(stat) + value);
        }
        City city = closestCity;
        UnitActionsPillage.pillageLooting$notify(toCityPillageYield, improvement, unit, tile, " which has been sent to [" + (city != null ? city.getName() : null) + ']');
        UnitActionsPillage.pillageLooting$notify(globalPillageYield, improvement, unit, tile, "");
    }

    @Readonly
    public final boolean canPillage(@NotNull MapUnit unit, @NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (unit.isTransported()) {
            return false;
        }
        if (!tile.canPillageTile()) {
            return false;
        }
        if (MapUnit.hasUnique$default(unit, UniqueType.CannotPillage, null, true, 2, null)) {
            return false;
        }
        Civilization tileOwner = tile.getOwner();
        return tileOwner == null || unit.getCiv().isAtWarWith(tileOwner);
    }

    private static final Unit getPillageActions$lambda$0(Tile $tile, UnitAction $pillageAction) {
        StringBuilder stringBuilder = new StringBuilder().append("Are you sure you want to pillage this [");
        String string = $tile.getImprovementToPillageName();
        Intrinsics.checkNotNull(string);
        String pillageText = stringBuilder.append(string).append("]?").toString();
        Popup.open$default(new ConfirmPopup(GUI.INSTANCE.getWorldScreen(), pillageText, "Pillage", true, null, () -> UnitActionsPillage.getPillageActions$lambda$0$0($pillageAction), 16, null), false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit getPillageActions$lambda$0$0(UnitAction $pillageAction) {
        $pillageAction.getAction().invoke();
        GUI.INSTANCE.setUpdateWorldOnNextRender();
        return Unit.INSTANCE;
    }

    private static final Unit getPillageAction$lambda$0(MapUnit $unit, Tile $tile) {
        boolean freePillage;
        Object object;
        String string = $unit.getCurrentTile().getImprovementToPillageName();
        Intrinsics.checkNotNull(string);
        String pillagedImprovement = string;
        boolean pillagingImprovement = $unit.getCurrentTile().canPillageTileImprovement();
        String pillageText = "An enemy [" + $unit.getBaseUnit().getName() + "] has pillaged our [" + pillagedImprovement + ']';
        String icon = "ImprovementIcons/" + pillagedImprovement;
        Civilization civilization = $tile.getOwner();
        if (civilization != null) {
            String[] stringArray = new String[]{icon, "OtherIcons/Pillage", $unit.getBaseUnit().getName()};
            civilization.addNotification(pillageText, $tile.getPosition(), Notification.NotificationCategory.War, stringArray);
        }
        INSTANCE.pillageLooting($tile, $unit);
        $tile.setPillaged();
        if ($tile.getResource() != null && (object = $tile.getOwner()) != null && (object = ((Civilization)object).getCache()) != null) {
            ((CivInfoTransientCache)object).updateCivResources();
        }
        if (!(freePillage = MapUnit.hasUnique$default($unit, UniqueType.NoMovementToPillage, null, true, 2, null))) {
            $unit.useMovementPoints(1.0f);
        }
        if (pillagingImprovement) {
            float healAmount = 25.0f;
            Iterator iterator2 = MapUnit.getMatchingUniques$default($unit, UniqueType.PercentHealthFromPillaging, null, true, 2, null).iterator();
            while (iterator2.hasNext()) {
                Unique unique = (Unique)iterator2.next();
                healAmount *= FormattingExtensionsKt.toPercent(unique.getParams().get(0));
            }
            $unit.healBy((int)healAmount);
        }
        TileImprovement tileImprovement = $tile.getImprovementToPillage();
        boolean bl = tileImprovement != null ? IHasUniques.hasUnique$default(tileImprovement, UniqueType.DestroyedWhenPillaged, null, 2, null) : false;
        if (bl) {
            $tile.removeImprovement();
        }
        return Unit.INSTANCE;
    }

    private static final void pillageLooting$notify(Stats $this$pillageLooting_u24notify, TileImprovement improvement, MapUnit $unit, Tile $tile, String suffix) {
        if ($this$pillageLooting_u24notify.isEmpty()) {
            return;
        }
        String text2 = "We have looted [" + $this$pillageLooting_u24notify.toStringWithoutIcons() + "] from a [" + improvement.getName() + ']' + suffix;
        String[] stringArray = new String[]{"ImprovementIcons/" + improvement.getName(), "OtherIcons/Pillage"};
        $unit.getCiv().addNotification(text2, $tile.getPosition(), Notification.NotificationCategory.War, stringArray);
    }
}

