/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.layers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.NeighborDirection;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.TileSetStrings;
import com.unciv.ui.components.tilegroups.layers.EdgeTileImage;
import com.unciv.ui.components.tilegroups.layers.TileLayer;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.RandomKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001CB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001d0#H\u0002J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001d0#H\u0002J\u001a\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u0018\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001d0#H\u0002J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001d0#2\u0006\u00100\u001a\u00020-H\u0002J\u0012\u00101\u001a\u00020\t2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u0012\u00102\u001a\u00020\t2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J \u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u00102\u0006\u00106\u001a\u00020\u0010H\u0002J$\u00107\u001a\u0004\u0018\u00010\u00172\b\u00108\u001a\u0004\u0018\u00010\u00172\u0006\u00109\u001a\u00020\u00102\u0006\u0010:\u001a\u00020\u001dH\u0002J\u000e\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\u0005J\u001a\u0010=\u001a\u00020\t2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010>\u001a\u00020?H\u0014J\u0006\u0010@\u001a\u00020\tJ0\u0010A\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u0016j\b\u0012\u0004\u0012\u00020\u001d`\u00182\u0016\u0010B\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u0016j\b\u0012\u0004\u0012\u00020\u001d`\u0018H\u0002R!\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0016j\b\u0012\u0004\u0012\u00020\u0017`\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020-0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayerTerrain;", "Lcom/unciv/ui/components/tilegroups/layers/TileLayer;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "size", "", "<init>", "(Lcom/unciv/ui/components/tilegroups/TileGroup;F)V", "act", "", "delta", "hit", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "x", "y", "touchable", "", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "tileBaseImages", "Ljava/util/ArrayList;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "Lkotlin/collections/ArrayList;", "getTileBaseImages", "()Ljava/util/ArrayList;", "tileImageIdentifiers", "", "", "bottomRightRiverImage", "bottomRiverImage", "bottomLeftRiverImage", "getTerrainImageLocations", "terrainSequence", "Lkotlin/sequences/Sequence;", "getImprovementAndResourceImages", "resourceAndImprovementSequence", "usePillagedImprovementImage", "tile", "Lcom/unciv/logic/map/tile/Tile;", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "getTileBaseImageLocations", "neighborEdgeDataList", "Lcom/unciv/ui/components/tilegroups/layers/TileLayerTerrain$NeighborEdgeData;", "getEdgeTileLocations", "getMatchingEdges", "neighborEdgeData", "updateTileImage", "updateTileColor", "updateRivers", "displayBottomRight", "displayBottom", "displayBottomLeft", "updateRiver", "currentImage", "shouldDisplay", "imageName", "dim", "brightness", "doUpdate", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "reset", "getNaturalWonderBackupImage", "baseHexagon", "NeighborEdgeData", "core"})
@SourceDebugExtension(value={"SMAP\nTileLayerTerrain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileLayerTerrain.kt\ncom/unciv/ui/components/tilegroups/layers/TileLayerTerrain\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,282:1\n11561#2:283\n11896#2,3:284\n11561#2:288\n11896#2,3:289\n1#3:287\n774#4:292\n865#4,2:293\n1563#4:295\n1634#4,3:296\n1740#4,3:299\n621#5,6:302\n*S KotlinDebug\n*F\n+ 1 TileLayerTerrain.kt\ncom/unciv/ui/components/tilegroups/layers/TileLayerTerrain\n*L\n33#1:283\n33#1:284,3\n91#1:288\n91#1:289,3\n141#1:292\n141#1:293,2\n145#1:295\n145#1:296,3\n158#1:299,3\n193#1:302,6\n*E\n"})
public final class TileLayerTerrain
extends TileLayer {
    @NotNull
    private final ArrayList<Image> tileBaseImages;
    @NotNull
    private List<String> tileImageIdentifiers;
    @Nullable
    private Image bottomRightRiverImage;
    @Nullable
    private Image bottomRiverImage;
    @Nullable
    private Image bottomLeftRiverImage;
    @NotNull
    private final Sequence<NeighborEdgeData> neighborEdgeDataList;

    public TileLayerTerrain(@NotNull TileGroup tileGroup, float size) {
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        super(tileGroup, size);
        this.tileBaseImages = new ArrayList();
        this.tileImageIdentifiers = CollectionsKt.emptyList();
        this.neighborEdgeDataList = !this.getTile().isTilemapInitialized() ? SequencesKt.emptySequence() : CollectionsKt.asSequence((Iterable)SequencesKt.toList(SequencesKt.map(this.getTile().getNeighbors(), arg_0 -> TileLayerTerrain.neighborEdgeDataList$lambda$0(this, arg_0))));
    }

    @Override
    public void act(float delta) {
    }

    @Override
    @Nullable
    public Actor hit(float x, float y, boolean touchable) {
        return null;
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    @NotNull
    public final ArrayList<Image> getTileBaseImages() {
        return this.tileBaseImages;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getTerrainImageLocations(Sequence<String> terrainSequence) {
        String allTerrains = SequencesKt.joinToString$default(terrainSequence, "+", null, null, 0, null, null, 62, null);
        if (this.getStrings().getTileSetConfig().getRuleVariants().containsKey(allTerrains)) {
            void $this$mapTo$iv$iv;
            String[] stringArray = this.getStrings().getTileSetConfig().getRuleVariants().get(allTerrains);
            Intrinsics.checkNotNull(stringArray);
            Object[] $this$map$iv = stringArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.getStrings().getTile((String)it));
            }
            return (List)destination$iv$iv;
        }
        String allTerrainTile = this.getStrings().getTile(allTerrains);
        return ImageGetter.INSTANCE.imageExists(allTerrainTile) ? CollectionsKt.listOf(allTerrainTile) : SequencesKt.toList(SequencesKt.map(terrainSequence, arg_0 -> TileLayerTerrain.getTerrainImageLocations$lambda$1(this, arg_0)));
    }

    private final List<String> getImprovementAndResourceImages(Sequence<String> resourceAndImprovementSequence2) {
        String it = SequencesKt.joinToString$default(resourceAndImprovementSequence2, "+", null, null, 0, null, null, 62, null);
        boolean bl = false;
        String altogether = this.getStrings().getTile(it);
        return ImageGetter.INSTANCE.imageExists(altogether) ? CollectionsKt.listOf(altogether) : SequencesKt.toList(SequencesKt.map(resourceAndImprovementSequence2, arg_0 -> TileLayerTerrain.getImprovementAndResourceImages$lambda$1(this, arg_0)));
    }

    private final boolean usePillagedImprovementImage(Tile tile, Civilization viewingCiv) {
        if (!tile.getImprovementIsPillaged() || !UncivGame.Companion.getCurrent().getSettings().getShowPixelImprovements()) {
            return false;
        }
        String string = tile.getShownImprovement(viewingCiv);
        if (string == null) {
            return false;
        }
        String shownImprovement = string;
        return ImageGetter.INSTANCE.imageExists(this.getStrings().getTile(shownImprovement + "-Pillaged"));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getTileBaseImageLocations(Civilization viewingCiv) {
        List list2;
        Sequence<String> sequence;
        ArrayList<String> arrayList;
        boolean isForceVisible = this.getTileGroup().isForceVisible();
        if (viewingCiv == null && !isForceVisible) {
            return this.getStrings().getHexagonList();
        }
        if (this.getStrings().getTileSetConfig().getUseColorAsBaseTerrain()) {
            ArrayList<String> arrayList2;
            ArrayList<String> $this$getTileBaseImageLocations_u24lambda_u240 = arrayList2 = new ArrayList<String>();
            boolean bl = false;
            $this$getTileBaseImageLocations_u24lambda_u240.add(this.getStrings().getHexagon());
            arrayList = arrayList2;
        } else {
            arrayList = new ArrayList<String>();
        }
        ArrayList<String> baseHexagon = arrayList;
        Tile tile = this.getTileGroup().getTile();
        String shownImprovement = tile.getShownImprovement(viewingCiv);
        boolean shouldShowImprovement = shownImprovement != null && UncivGame.Companion.getCurrent().getSettings().getShowPixelImprovements();
        boolean shouldShowResource = UncivGame.Companion.getCurrent().getSettings().getShowPixelImprovements() && tile.getResource() != null && (isForceVisible || viewingCiv == null || viewingCiv.canSeeResource(tile.getTileResource()));
        Sequence<String> resourceAndImprovementSequence2 = SequencesKt.sequence((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(shouldShowResource, tile, shouldShowImprovement, this, viewingCiv, shownImprovement, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ boolean $shouldShowResource;
            final /* synthetic */ Tile $tile;
            final /* synthetic */ boolean $shouldShowImprovement;
            final /* synthetic */ TileLayerTerrain this$0;
            final /* synthetic */ Civilization $viewingCiv;
            final /* synthetic */ String $shownImprovement;
            {
                this.$shouldShowResource = $shouldShowResource;
                this.$tile = $tile;
                this.$shouldShowImprovement = $shouldShowImprovement;
                this.this$0 = $receiver;
                this.$viewingCiv = $viewingCiv;
                this.$shownImprovement = $shownImprovement;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        if (this.$shouldShowResource) {
                            v0 = this.$tile.getResource();
                            Intrinsics.checkNotNull(v0);
                            this.L$0 = $this$sequence;
                            this.label = 1;
                            v1 = $this$sequence.yield(v0, this);
                            if (v1 == var3_3) {
                                return var3_3;
                            }
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
lbl18:
                        // 2 sources

                        if (this.$shouldShowImprovement) {
                            if (!TileLayerTerrain.access$usePillagedImprovementImage(this.this$0, this.$tile, this.$viewingCiv)) break;
                            this.L$0 = SpillingKt.nullOutSpilledVariable($this$sequence);
                            this.label = 2;
                            v2 = $this$sequence.yield(this.$shownImprovement + "-Pillaged", this);
                            if (v2 == var3_3) {
                                return var3_3;
                            }
                        }
                        ** GOTO lbl41
                    }
                    case 2: {
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
                        ** GOTO lbl41
                    }
                }
                v3 = this.$shownImprovement;
                Intrinsics.checkNotNull(v3);
                this.L$0 = SpillingKt.nullOutSpilledVariable($this$sequence);
                this.label = 3;
                v4 = $this$sequence.yield(v3, this);
                if (v4 == var3_3) {
                    return var3_3;
                }
                ** GOTO lbl41
                {
                    case 3: {
                        ResultKt.throwOnFailure($result);
                        v4 = $result;
lbl41:
                        // 4 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super String> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
        if (tile.getNaturalWonder() != null) {
            String[] stringArray = new String[2];
            stringArray[0] = tile.getBaseTerrain();
            Intrinsics.checkNotNull(tile.getNaturalWonder());
            sequence = SequencesKt.sequenceOf(stringArray);
        } else {
            sequence = SequencesKt.plus(SequencesKt.sequenceOf(tile.getBaseTerrain()), CollectionsKt.asSequence((Iterable)tile.getTerrainFeatures()));
        }
        Sequence<String> terrainImages = sequence;
        Sequence<String> edgeImages = this.getEdgeTileLocations();
        String allTogether = SequencesKt.joinToString$default(SequencesKt.plus(terrainImages, resourceAndImprovementSequence2), "+", null, null, 0, null, null, 62, null);
        String allTogetherLocation = this.getStrings().getTile(allTogether);
        if (this.getStrings().getTileSetConfig().getRuleVariants().get(allTogether) != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            ArrayList<String> arrayList3;
            ArrayList<String> $this$getTileBaseImageLocations_u24lambda_u241 = arrayList3 = baseHexagon;
            boolean bl = false;
            String[] stringArray = this.getStrings().getTileSetConfig().getRuleVariants().get(allTogether);
            Intrinsics.checkNotNull(stringArray);
            Object[] objectArray = stringArray;
            ArrayList<String> arrayList4 = $this$getTileBaseImageLocations_u24lambda_u241;
            boolean $i$f$map = false;
            void var19_25 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this.getStrings().getTile((String)it));
            }
            arrayList4.addAll((List)destination$iv$iv);
            CollectionsKt.addAll((Collection)$this$getTileBaseImageLocations_u24lambda_u241, edgeImages);
            list2 = arrayList3;
        } else if (ImageGetter.INSTANCE.imageExists(allTogetherLocation)) {
            ArrayList<String> arrayList5;
            ArrayList<String> $this$getTileBaseImageLocations_u24lambda_u242 = arrayList5 = baseHexagon;
            boolean bl = false;
            $this$getTileBaseImageLocations_u24lambda_u242.add(allTogetherLocation);
            CollectionsKt.addAll((Collection)$this$getTileBaseImageLocations_u24lambda_u242, edgeImages);
            list2 = arrayList5;
        } else if (tile.getNaturalWonder() != null) {
            list2 = CollectionsKt.plus((Collection)this.getNaturalWonderBackupImage(baseHexagon), edgeImages);
        } else {
            ArrayList<String> arrayList6;
            ArrayList<String> $this$getTileBaseImageLocations_u24lambda_u243 = arrayList6 = baseHexagon;
            boolean bl = false;
            $this$getTileBaseImageLocations_u24lambda_u243.addAll((Collection<String>)this.getTerrainImageLocations(terrainImages));
            CollectionsKt.addAll((Collection)$this$getTileBaseImageLocations_u24lambda_u243, edgeImages);
            $this$getTileBaseImageLocations_u24lambda_u243.addAll((Collection<String>)this.getImprovementAndResourceImages(resourceAndImprovementSequence2));
            list2 = arrayList6;
        }
        return list2;
    }

    private final Sequence<String> getEdgeTileLocations() {
        if (!this.getTile().isTilemapInitialized()) {
            return SequencesKt.emptySequence();
        }
        return SequencesKt.flatMap(this.neighborEdgeDataList, arg_0 -> TileLayerTerrain.getEdgeTileLocations$lambda$0(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final Sequence<String> getMatchingEdges(NeighborEdgeData neighborEdgeData) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        EdgeTileImage it;
        void $this$filterTo$iv$iv;
        if (Intrinsics.areEqual(neighborEdgeData.getOurTerrains(), this.getTile().getCachedTerrainData().getTerrainNameSet()) && Intrinsics.areEqual(neighborEdgeData.getNeighborTerrains(), neighborEdgeData.getNeighbor().getCachedTerrainData().getTerrainNameSet())) {
            return neighborEdgeData.getEdgeFiles();
        }
        if (neighborEdgeData.getDirection() == null) {
            return SequencesKt.emptySequence();
        }
        List<EdgeTileImage> list2 = this.getStrings().getEdgeImagesByPosition().get((Object)neighborEdgeData.getDirection());
        if (list2 == null) {
            return SequencesKt.emptySequence();
        }
        List<EdgeTileImage> possibleEdgeImages = list2;
        Iterable $this$filter$iv = possibleEdgeImages;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (EdgeTileImage)element$iv$iv;
            boolean bl = false;
            if (!(!TileLayerTerrain.getMatchingEdges$matchesFilterMinimal(this.getTile(), it.getOriginTileFilter()) ? false : TileLayerTerrain.getMatchingEdges$matchesFilterMinimal(neighborEdgeData.getNeighbor(), it.getDestinationTileFilter()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (EdgeTileImage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFileName());
        }
        Sequence<String> cachedSequence = CollectionsKt.asSequence((List)destination$iv$iv);
        neighborEdgeData.setOurTerrains(this.getTile().getCachedTerrainData().getTerrainNameSet());
        neighborEdgeData.setNeighborTerrains(neighborEdgeData.getNeighbor().getCachedTerrainData().getTerrainNameSet());
        neighborEdgeData.setEdgeFiles(cachedSequence);
        return cachedSequence;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateTileImage(Civilization viewingCiv) {
        List<String> tileBaseImageLocations = this.getTileBaseImageLocations(viewingCiv);
        if (tileBaseImageLocations.size() == this.tileImageIdentifiers.size()) {
            boolean bl;
            block12: {
                Iterable $this$all$iv = CollectionsKt.withIndex((Iterable)tileBaseImageLocations);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator2 = $this$all$iv.iterator();
                    while (iterator2.hasNext()) {
                        IndexedValue element$iv;
                        IndexedValue indexedValue = element$iv = iterator2.next();
                        boolean bl2 = false;
                        int i = indexedValue.component1();
                        String imageLocation = (String)indexedValue.component2();
                        if (Intrinsics.areEqual(this.tileImageIdentifiers.get(i), imageLocation)) continue;
                        bl = false;
                        break block12;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return;
            }
        }
        this.tileImageIdentifiers = tileBaseImageLocations;
        Iterator<Image> iterator3 = this.tileBaseImages.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
        Iterator<Object> iterator4 = iterator3;
        while (iterator4.hasNext()) {
            Image image;
            Intrinsics.checkNotNullExpressionValue(iterator4.next(), "next(...)");
            image.remove();
        }
        this.tileBaseImages.clear();
        for (String baseLocation : tileBaseImageLocations) {
            Image image;
            String tileVariant;
            String string;
            if (!ImageGetter.INSTANCE.imageExists(baseLocation)) continue;
            if (this.getTileGroup().getTile().getOwningCity() != null) {
                TileSetStrings tileSetStrings = this.getStrings();
                Civilization civilization = this.getTileGroup().getTile().getOwner();
                Intrinsics.checkNotNull(civilization);
                string = tileSetStrings.getOwnedTileImageLocation(baseLocation, civilization);
            } else {
                string = baseLocation;
            }
            String locationToCheck = string;
            ArrayList<String> existingImages = new ArrayList<String>();
            existingImages.add(locationToCheck);
            int i = 2;
            while (ImageGetter.INSTANCE.imageExists(tileVariant = locationToCheck + i)) {
                existingImages.add(tileVariant);
                ++i;
            }
            String finalLocation = (String)CollectionsKt.random((Collection)existingImages, RandomKt.Random(this.getTileGroup().getTile().getPosition().hashCode() + locationToCheck.hashCode()));
            Image image2 = ImageGetter.getImage$default(ImageGetter.INSTANCE, finalLocation, null, 2, null);
            image2.setName(finalLocation);
            this.tileBaseImages.add(image2);
            this.addActor(image2);
            if (!((Map)this.getStrings().getTileSetConfig().getTileScales()).isEmpty()) {
                String string2;
                HashMap<String, Float> hashMap;
                block13: {
                    void $this$takeLastWhile$iv;
                    String string3 = baseLocation;
                    hashMap = this.getStrings().getTileSetConfig().getTileScales();
                    boolean $i$f$takeLastWhile = false;
                    for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                        char it = $this$takeLastWhile$iv.charAt(index$iv);
                        boolean bl = false;
                        if (it != '/') continue;
                        void var14_20 = $this$takeLastWhile$iv;
                        int n = index$iv + 1;
                        String string4 = var14_20.substring(n);
                        string2 = string4;
                        Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
                        break block13;
                    }
                    string2 = $this$takeLastWhile$iv;
                }
                Float scale = hashMap.get(string2);
                image = this.setHexagonSize(image2, scale);
                continue;
            }
            image = TileLayer.setHexagonSize$default(this, image2, null, 1, null);
        }
    }

    private final void updateTileColor(Civilization viewingCiv) {
        boolean isViewable = viewingCiv == null || this.isViewable(viewingCiv);
        Tile tile = this.getTileGroup().getTile();
        boolean colorPillagedTile = isViewable && tile.isPillaged() && !this.usePillagedImprovementImage(tile, viewingCiv);
        Color baseTerrainColor = colorPillagedTile && this.getStrings().getTileSetConfig().getUseColorAsBaseTerrain() ? tile.getBaseTerrain().getColor().lerp(Color.BROWN, 0.6f) : (colorPillagedTile ? Color.WHITE.cpy().lerp(Color.BROWN, 0.6f) : (this.getStrings().getTileSetConfig().getUseColorAsBaseTerrain() && !isViewable ? tile.getBaseTerrain().getColor().lerp(this.getStrings().getTileSetConfig().getFogOfWarColor(), 0.6f) : (this.getStrings().getTileSetConfig().getUseColorAsBaseTerrain() ? tile.getBaseTerrain().getColor() : (!isViewable ? Color.WHITE.cpy().lerp(this.getStrings().getTileSetConfig().getFogOfWarColor(), 0.6f) : Color.WHITE.cpy()))));
        Color color = colorPillagedTile ? Color.WHITE.cpy().lerp(Color.RED.cpy(), 0.5f) : (!isViewable ? Color.WHITE.cpy().lerp(this.getStrings().getTileSetConfig().getFogOfWarColor(), 0.6f) : Color.WHITE.cpy());
        Iterator iterator2 = ((Iterable)this.tileBaseImages).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int index = n++;
            Image image = (Image)iterator2.next();
            image.setColor(index == 0 ? baseTerrainColor : color);
        }
    }

    private final void updateRivers(boolean displayBottomRight, boolean displayBottom, boolean displayBottomLeft) {
        this.bottomRightRiverImage = this.updateRiver(this.bottomRightRiverImage, displayBottomRight, this.getStrings().getBottomRightRiver());
        this.bottomRiverImage = this.updateRiver(this.bottomRiverImage, displayBottom, this.getStrings().getBottomRiver());
        this.bottomLeftRiverImage = this.updateRiver(this.bottomLeftRiverImage, displayBottomLeft, this.getStrings().getBottomLeftRiver());
    }

    private final Image updateRiver(Image currentImage, boolean shouldDisplay, String imageName) {
        if (!shouldDisplay) {
            Image image = currentImage;
            if (image != null) {
                image.remove();
            }
            return null;
        }
        if (currentImage != null) {
            currentImage.toFront();
            return currentImage;
        }
        if (!ImageGetter.INSTANCE.imageExists(imageName)) {
            return null;
        }
        Image newImage = ImageGetter.getImage$default(ImageGetter.INSTANCE, imageName, null, 2, null);
        this.addActor(TileLayer.setHexagonSize$default(this, newImage, null, 1, null));
        return newImage;
    }

    public final void dim(float brightness) {
        Iterator<Image> iterator2 = this.tileBaseImages.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Image> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Image image;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            image.getColor().lerp(BaseScreen.Companion.getClearColor(), 1.0f - brightness);
        }
    }

    @Override
    protected void doUpdate(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        this.updateTileImage(viewingCiv);
        this.updateRivers(this.getTileGroup().getTile().getHasBottomRightRiver(), this.getTileGroup().getTile().getHasBottomRiver(), this.getTileGroup().getTile().getHasBottomLeftRiver());
        this.updateTileColor(viewingCiv);
    }

    public final void reset() {
        this.setVisible(false);
        this.updateRivers(false, false, false);
    }

    private final ArrayList<String> getNaturalWonderBackupImage(ArrayList<String> baseHexagon) {
        ArrayList<String> arrayList;
        if (this.getStrings().getTileSetConfig().getUseSummaryImages()) {
            ArrayList<String> arrayList2;
            ArrayList<String> $this$getNaturalWonderBackupImage_u24lambda_u240 = arrayList2 = baseHexagon;
            boolean bl = false;
            $this$getNaturalWonderBackupImage_u24lambda_u240.add(this.getStrings().getNaturalWonder());
            arrayList = arrayList2;
        } else {
            ArrayList<String> arrayList3;
            ArrayList<String> $this$getNaturalWonderBackupImage_u24lambda_u241 = arrayList3 = baseHexagon;
            boolean bl = false;
            $this$getNaturalWonderBackupImage_u24lambda_u241.add(this.getStrings().orFallback(arg_0 -> TileLayerTerrain.getNaturalWonderBackupImage$lambda$1$0(this, arg_0)));
            arrayList = arrayList3;
        }
        return arrayList;
    }

    private static final String getTerrainImageLocations$lambda$1(TileLayerTerrain this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.getStrings().orFallback(arg_0 -> TileLayerTerrain.getTerrainImageLocations$lambda$1$0(it, arg_0));
    }

    private static final String getTerrainImageLocations$lambda$1$0(String $it, TileSetStrings $this$orFallback) {
        Intrinsics.checkNotNullParameter($this$orFallback, "$this$orFallback");
        return $this$orFallback.getTile($it);
    }

    private static final String getImprovementAndResourceImages$lambda$1(TileLayerTerrain this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.getStrings().orFallback(arg_0 -> TileLayerTerrain.getImprovementAndResourceImages$lambda$1$0(it, arg_0));
    }

    private static final String getImprovementAndResourceImages$lambda$1$0(String $it, TileSetStrings $this$orFallback) {
        Intrinsics.checkNotNullParameter($this$orFallback, "$this$orFallback");
        return $this$orFallback.getTile($it);
    }

    private static final NeighborEdgeData neighborEdgeDataList$lambda$0(TileLayerTerrain this$0, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        int clockPosition = this$0.getTile().getTileMap().getNeighborTileClockPosition(this$0.getTile(), it);
        NeighborDirection direction = NeighborDirection.Companion.getByClockPosition().get(clockPosition);
        return new NeighborEdgeData(it, direction);
    }

    private static final Sequence getEdgeTileLocations$lambda$0(TileLayerTerrain this$0, NeighborEdgeData it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.getMatchingEdges(it);
    }

    @Readonly
    private static final boolean getMatchingEdges$matchesFilterMinimal(Tile originTile, String filter2) {
        if (originTile.getCachedTerrainData().getTerrainNameSet().contains(filter2)) {
            return true;
        }
        return Intrinsics.areEqual(originTile.getBaseTerrain().getType().name(), filter2);
    }

    private static final String getNaturalWonderBackupImage$lambda$1$0(TileLayerTerrain this$0, TileSetStrings $this$orFallback) {
        Intrinsics.checkNotNullParameter($this$orFallback, "$this$orFallback");
        String string = this$0.getTileGroup().getTile().getNaturalWonder();
        Intrinsics.checkNotNull(string);
        return $this$orFallback.getTile(string);
    }

    public static final /* synthetic */ boolean access$usePillagedImprovementImage(TileLayerTerrain $this, Tile tile, Civilization viewingCiv) {
        return $this.usePillagedImprovementImage(tile, viewingCiv);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayerTerrain$NeighborEdgeData;", "", "neighbor", "Lcom/unciv/logic/map/tile/Tile;", "direction", "Lcom/unciv/logic/map/NeighborDirection;", "<init>", "(Lcom/unciv/logic/map/tile/Tile;Lcom/unciv/logic/map/NeighborDirection;)V", "getNeighbor", "()Lcom/unciv/logic/map/tile/Tile;", "getDirection", "()Lcom/unciv/logic/map/NeighborDirection;", "ourTerrains", "", "", "getOurTerrains", "()Ljava/util/Set;", "setOurTerrains", "(Ljava/util/Set;)V", "neighborTerrains", "getNeighborTerrains", "setNeighborTerrains", "edgeFiles", "Lkotlin/sequences/Sequence;", "getEdgeFiles", "()Lkotlin/sequences/Sequence;", "setEdgeFiles", "(Lkotlin/sequences/Sequence;)V", "core"})
    private static final class NeighborEdgeData {
        @NotNull
        private final Tile neighbor;
        @Nullable
        private final NeighborDirection direction;
        @NotNull
        private Set<String> ourTerrains;
        @NotNull
        private Set<String> neighborTerrains;
        @NotNull
        private Sequence<String> edgeFiles;

        public NeighborEdgeData(@NotNull Tile neighbor, @Nullable NeighborDirection direction) {
            Intrinsics.checkNotNullParameter(neighbor, "neighbor");
            this.neighbor = neighbor;
            this.direction = direction;
            this.ourTerrains = SetsKt.emptySet();
            this.neighborTerrains = SetsKt.emptySet();
            this.edgeFiles = SequencesKt.emptySequence();
        }

        @NotNull
        public final Tile getNeighbor() {
            return this.neighbor;
        }

        @Nullable
        public final NeighborDirection getDirection() {
            return this.direction;
        }

        @NotNull
        public final Set<String> getOurTerrains() {
            return this.ourTerrains;
        }

        public final void setOurTerrains(@NotNull Set<String> set) {
            Intrinsics.checkNotNullParameter(set, "<set-?>");
            this.ourTerrains = set;
        }

        @NotNull
        public final Set<String> getNeighborTerrains() {
            return this.neighborTerrains;
        }

        public final void setNeighborTerrains(@NotNull Set<String> set) {
            Intrinsics.checkNotNullParameter(set, "<set-?>");
            this.neighborTerrains = set;
        }

        @NotNull
        public final Sequence<String> getEdgeFiles() {
            return this.edgeFiles;
        }

        public final void setEdgeFiles(@NotNull Sequence<String> sequence) {
            Intrinsics.checkNotNullParameter(sequence, "<set-?>");
            this.edgeFiles = sequence;
        }
    }
}

