/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.badlogic.gdx.math.Vector2;
import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.city.CityConstructions;
import com.unciv.logic.city.CityStats;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.DiplomacyAction;
import com.unciv.logic.civilization.LocationAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.logic.civilization.Proximity;
import com.unciv.logic.civilization.diplomacy.CityStatePersonality;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.managers.AssignedQuest;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Quest;
import com.unciv.models.ruleset.QuestName;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.utils.CollectionExtensionsKt;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Pure;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u001c\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 t2\u00020\u0001:\u0002tuB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0007J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u001b\u001a\u00020\u0012H\u0007J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u0004\u001a\u00020\u0005H\u0007J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0003J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0012H\u0007J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0007J\u0006\u0010$\u001a\u00020\u0000J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010'\u001a\u00020&J\b\u0010(\u001a\u00020&H\u0002J\b\u0010)\u001a\u00020&H\u0002J\b\u0010*\u001a\u00020&H\u0002J\u0010\u0010+\u001a\u00020&2\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\"\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u001700H\u0003J\b\u00101\u001a\u000202H\u0003J\b\u00103\u001a\u00020&H\u0002J\b\u00104\u001a\u00020&H\u0002J\b\u00105\u001a\u00020&H\u0002J\b\u00106\u001a\u00020&H\u0002J\u0010\u00107\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u00108\u001a\u00020&J\u0010\u00109\u001a\u00020\u00172\u0006\u0010:\u001a\u00020\fH\u0002J\u001e\u0010;\u001a\u00020&2\u0006\u0010<\u001a\u00020.2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00050>H\u0002J\u0010\u0010?\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0003J\u0018\u0010@\u001a\u00020\u00172\u0006\u0010<\u001a\u00020.2\u0006\u0010\u0018\u001a\u00020\u0005H\u0003J\u0010\u0010A\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0003J\u001a\u0010B\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00052\b\u0010C\u001a\u0004\u0018\u00010\u0012H\u0003J\u0010\u0010D\u001a\u00020\u00172\u0006\u0010:\u001a\u00020\fH\u0003J\u0010\u0010E\u001a\u00020\u00172\u0006\u0010:\u001a\u00020\fH\u0003J\u0010\u0010F\u001a\u00020&2\u0006\u0010:\u001a\u00020\fH\u0002J \u0010G\u001a\u00020&2\u0006\u0010:\u001a\u00020\f2\u000e\b\u0002\u0010H\u001a\b\u0012\u0004\u0012\u00020\f0-H\u0002J\u0010\u0010I\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\fH\u0003J\u0010\u0010J\u001a\u00020\u00122\u0006\u0010K\u001a\u00020\fH\u0007J\u0016\u0010L\u001a\u00020&2\u0006\u0010M\u001a\u00020\u00052\u0006\u0010N\u001a\u00020OJ\u0016\u0010P\u001a\u00020&2\u0006\u0010Q\u001a\u00020\u00052\u0006\u0010R\u001a\u00020\u0005J\u0016\u0010S\u001a\u00020&2\u0006\u0010Q\u001a\u00020\u00052\u0006\u0010T\u001a\u00020\u0005J\u000e\u0010U\u001a\u00020&2\u0006\u0010R\u001a\u00020\u0005J*\u0010V\u001a\u00020&2\u0006\u0010W\u001a\u00020\u00052\u0006\u0010X\u001a\u00020\u00122\u0006\u0010Y\u001a\u00020\u000f2\b\u0010N\u001a\u0004\u0018\u00010ZH\u0002J\u0016\u0010[\u001a\u00020&2\u0006\u0010\\\u001a\u00020\u00052\u0006\u0010]\u001a\u00020\u0005J\u000e\u0010^\u001a\u00020&2\u0006\u0010_\u001a\u00020\u0005J\b\u0010`\u001a\u00020&H\u0002J\u0010\u0010a\u001a\u00020&2\u0006\u0010R\u001a\u00020\u0005H\u0002J\u0010\u0010b\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0005H\u0007J\u0010\u0010Y\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0005H\u0007J\u0018\u0010c\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010d\u001a\u00020\u0005H\u0007J\u000e\u0010e\u001a\u00020&2\u0006\u0010f\u001a\u00020\u0005J\u0010\u0010g\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u0012H\u0003J\n\u0010h\u001a\u0004\u0018\u00010iH\u0003J\u0012\u0010j\u001a\u0004\u0018\u00010k2\u0006\u0010\u0018\u001a\u00020\u0005H\u0003J\u0012\u0010l\u001a\u0004\u0018\u00010m2\u0006\u0010\u0018\u001a\u00020\u0005H\u0003J\u0012\u0010n\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0018\u001a\u00020\u0005H\u0003J\u0012\u0010o\u001a\u0004\u0018\u00010p2\u0006\u0010\u0018\u001a\u00020\u0005H\u0003J\u0012\u0010q\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0003J\u0012\u0010r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0003J\n\u0010s\u001a\u0004\u0018\u00010\u0012H\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u0011j\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u0011j\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000Rb\u0010\u0015\u001aV\u0012\u0004\u0012\u00020\u0012\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u0011j\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f`\u00130\u0011j*\u0012\u0004\u0012\u00020\u0012\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u0011j\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f`\u0013`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006v"}, d2={"Lcom/unciv/logic/civilization/managers/QuestManager;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "<init>", "()V", "civ", "Lcom/unciv/logic/civilization/Civilization;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "assignedQuests", "Ljava/util/ArrayList;", "Lcom/unciv/logic/civilization/managers/AssignedQuest;", "Lkotlin/collections/ArrayList;", "globalQuestCountdown", "", "individualQuestCountdown", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "unitsToKillForCiv", "unitsKilledFromCiv", "haveQuestsFor", "", "challenger", "getAssignedQuestsFor", "Lkotlin/sequences/Sequence;", "civName", "getAssignedQuestsOfName", "questName", "Lcom/unciv/models/ruleset/QuestName;", "wantsDead", "target", "getInvestmentMultiplier", "", "donor", "clone", "setTransients", "", "endTurn", "decrementQuestCountdowns", "seedGlobalQuestCountdown", "seedIndividualQuestsCountdowns", "seedIndividualQuestsCountdown", "getQuests", "", "Lcom/unciv/models/ruleset/Quest;", "predicate", "Lkotlin/Function1;", "getRandom", "Lkotlin/random/Random;", "tryStartNewGlobalQuest", "tryStartNewIndividualQuests", "tryBarbarianInvasion", "handleGlobalQuests", "handleGlobalQuest", "handleIndividualQuests", "handleIndividualQuest", "assignedQuest", "assignNewQuest", "quest", "assignees", "", "canAssignAQuestTo", "isQuestValid", "isRouteQuestValid", "isDenounceCivQuestValid", "mostRecentBully", "isComplete", "isObsolete", "giveReward", "notifyExpired", "winners", "getScoreForQuest", "getScoreStringForGlobalQuest", "inquiringAssignedQuest", "barbarianCampCleared", "civInfo", "location", "Lcom/badlogic/gdx/math/Vector2;", "cityStateConquered", "cityState", "attacker", "cityStateBullied", "bully", "wasAttackedBy", "notifyAskForAssistance", "assignee", "attackerName", "unitsToKill", "Lcom/unciv/logic/map/HexCoord;", "militaryUnitKilledBy", "killer", "killed", "justMet", "otherCiv", "tryEndWarWithMajorQuests", "endWarWithMajorQuest", "isWarWithMajorActive", "unitsKilledSoFar", "viewingCiv", "receivedGoldGift", "donorCiv", "getQuestWeight", "getBarbarianEncampmentForQuest", "Lcom/unciv/logic/map/tile/Tile;", "getResourceForQuest", "Lcom/unciv/models/ruleset/tile/TileResource;", "getWonderToBuildForQuest", "Lcom/unciv/models/ruleset/Building;", "getNaturalWonderToFindForQuest", "getGreatPersonForQuest", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "getCivilizationToFindForQuest", "getCityStateTarget", "getMostRecentBully", "Companion", "WinnersAndLosers", "core"})
@SourceDebugExtension(value={"SMAP\nQuestManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuestManager.kt\ncom/unciv/logic/civilization/managers/QuestManager\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1013:1\n1255#2,2:1014\n183#2,2:1016\n1276#2,3:1032\n1255#2,2:1048\n1255#2,2:1062\n1255#2,2:1064\n1276#2,3:1066\n2275#2,2:1090\n1276#2,3:1147\n1563#3:1018\n1634#3,3:1019\n774#3:1022\n865#3,2:1023\n1788#3,4:1025\n774#3:1029\n865#3,2:1030\n774#3:1035\n865#3,2:1036\n1563#3:1038\n1634#3,3:1039\n1869#3,2:1042\n1869#3,2:1044\n230#3,2:1046\n295#3,2:1050\n1761#3,3:1052\n1563#3:1055\n1634#3,3:1056\n1761#3,3:1059\n1563#3:1076\n1634#3,3:1077\n1563#3:1080\n1634#3,3:1081\n1563#3:1084\n1634#3,3:1085\n774#3:1088\n865#3:1089\n866#3:1092\n1563#3:1093\n1634#3,3:1094\n827#3:1097\n855#3,2:1098\n1617#3,9:1100\n1869#3:1109\n1870#3:1111\n1626#3:1112\n774#3:1113\n865#3,2:1114\n2423#3,14:1116\n774#3:1130\n865#3,2:1131\n1999#3,14:1133\n382#4,7:1069\n1#5:1110\n*S KotlinDebug\n*F\n+ 1 QuestManager.kt\ncom/unciv/logic/civilization/managers/QuestManager\n*L\n106#1:1014,2\n111#1:1016,2\n241#1:1032,3\n396#1:1048,2\n453#1:1062,2\n469#1:1064,2\n656#1:1066,3\n820#1:1090,2\n220#1:1147,3\n120#1:1018\n120#1:1019,3\n208#1:1022\n208#1:1023,2\n216#1:1025,4\n227#1:1029\n227#1:1030,2\n280#1:1035\n280#1:1036,2\n280#1:1038\n280#1:1039,3\n287#1:1042,2\n288#1:1044,2\n353#1:1046,2\n413#1:1050,2\n429#1:1052,3\n451#1:1055\n451#1:1056,3\n452#1:1059,3\n711#1:1076\n711#1:1077,3\n791#1:1080\n791#1:1081,3\n792#1:1084\n792#1:1085,3\n811#1:1088\n811#1:1089\n811#1:1092\n851#1:1093\n851#1:1094,3\n855#1:1097\n855#1:1098,2\n880#1:1100,9\n880#1:1109\n880#1:1111\n880#1:1112\n880#1:1113\n880#1:1114,2\n880#1:1116,14\n895#1:1130\n895#1:1131,2\n896#1:1133,14\n686#1:1069,7\n880#1:1110\n*E\n"})
public final class QuestManager
implements IsPartOfGameInfoSerialization {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private transient Civilization civ;
    @NotNull
    private ArrayList<AssignedQuest> assignedQuests = new ArrayList();
    private int globalQuestCountdown = -1;
    @NotNull
    private HashMap<String, Integer> individualQuestCountdown = new HashMap();
    @NotNull
    private HashMap<String, Integer> unitsToKillForCiv = new HashMap();
    @NotNull
    private HashMap<String, HashMap<String, Integer>> unitsKilledFromCiv = new HashMap();
    public static final int UNSET = -1;
    public static final int GLOBAL_QUEST_FIRST_POSSIBLE_TURN = 30;
    public static final int INDIVIDUAL_QUEST_FIRST_POSSIBLE_TURN = 30;
    public static final int GLOBAL_QUEST_FIRST_POSSIBLE_TURN_RAND = 20;
    public static final int INDIVIDUAL_QUEST_FIRST_POSSIBLE_TURN_RAND = 20;
    public static final int GLOBAL_QUEST_MIN_TURNS_BETWEEN = 40;
    public static final int INDIVIDUAL_QUEST_MIN_TURNS_BETWEEN = 20;
    public static final int GLOBAL_QUEST_RAND_TURNS_BETWEEN = 25;
    public static final int INDIVIDUAL_QUEST_RAND_TURNS_BETWEEN = 25;
    public static final int GLOBAL_QUEST_MAX_ACTIVE = 1;
    public static final int INDIVIDUAL_QUEST_MAX_ACTIVE = 2;

    private final Ruleset getRuleset() {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        return civilization.getGameInfo().getRuleset();
    }

    @Readonly
    public final boolean haveQuestsFor(@NotNull Civilization challenger) {
        Intrinsics.checkNotNullParameter(challenger, "challenger");
        return SequencesKt.any(this.getAssignedQuestsFor(challenger));
    }

    @Readonly
    @NotNull
    public final Sequence<AssignedQuest> getAssignedQuestsFor(@NotNull String civName) {
        Intrinsics.checkNotNullParameter(civName, "civName");
        return SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.assignedQuests), arg_0 -> QuestManager.getAssignedQuestsFor$lambda$0(civName, arg_0));
    }

    @Readonly
    @NotNull
    public final Sequence<AssignedQuest> getAssignedQuestsFor(@NotNull Civilization civ) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        return SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.assignedQuests), arg_0 -> QuestManager.getAssignedQuestsFor$lambda$1(civ, arg_0));
    }

    @Readonly
    private final Sequence<AssignedQuest> getAssignedQuestsOfName(QuestName questName) {
        return SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.assignedQuests), arg_0 -> QuestManager.getAssignedQuestsOfName$lambda$0(questName, arg_0));
    }

    @Readonly
    public final boolean wantsDead(@NotNull String target) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter(target, "target");
            Sequence<AssignedQuest> $this$any$iv = this.getAssignedQuestsOfName(QuestName.ConquerCityState);
            boolean $i$f$any = false;
            Iterator<AssignedQuest> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                AssignedQuest element$iv;
                AssignedQuest it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getData1(), target)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Readonly
    public final float getInvestmentMultiplier(@NotNull Civilization donor) {
        AssignedQuest assignedQuest;
        block2: {
            Intrinsics.checkNotNullParameter(donor, "donor");
            Sequence<AssignedQuest> $this$firstOrNull$iv = this.getAssignedQuestsOfName(QuestName.Invest);
            boolean $i$f$firstOrNull = false;
            Iterator<AssignedQuest> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                AssignedQuest element$iv;
                AssignedQuest it = element$iv = iterator2.next();
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getAssigneeCiv(), donor)) continue;
                assignedQuest = element$iv;
                break block2;
            }
            assignedQuest = null;
        }
        AssignedQuest assignedQuest2 = assignedQuest;
        if (assignedQuest2 == null) {
            return 1.0f;
        }
        AssignedQuest investmentQuest = assignedQuest2;
        return FormattingExtensionsKt.toPercent(investmentQuest.getData1());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final QuestManager clone() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        QuestManager toReturn = new QuestManager();
        toReturn.globalQuestCountdown = this.globalQuestCountdown;
        toReturn.individualQuestCountdown.putAll((Map<String, Integer>)this.individualQuestCountdown);
        Iterable iterable = this.assignedQuests;
        ArrayList<AssignedQuest> arrayList = toReturn.assignedQuests;
        boolean bl = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AssignedQuest assignedQuest = (AssignedQuest)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.clone());
        }
        arrayList.addAll((List)destination$iv$iv);
        toReturn.unitsToKillForCiv.putAll((Map<String, Integer>)this.unitsToKillForCiv);
        for (Map.Entry entry : ((Map)this.unitsKilledFromCiv).entrySet()) {
            String attacker = (String)entry.getKey();
            HashMap unitsKilled = (HashMap)entry.getValue();
            ((Map)toReturn.unitsKilledFromCiv).put(attacker, new HashMap(unitsKilled));
        }
        return toReturn;
    }

    public final void setTransients(@NotNull Civilization civ) {
        Intrinsics.checkNotNullParameter(civ, "civ");
        this.civ = civ;
        Iterator<AssignedQuest> iterator2 = this.assignedQuests.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<AssignedQuest> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            AssignedQuest quest;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            AssignedQuest.setTransients$core$default(quest, civ.getGameInfo(), null, 2, null);
        }
    }

    public final void endTurn() {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (civilization.isDefeated()) {
            this.assignedQuests.clear();
            this.individualQuestCountdown.clear();
            this.globalQuestCountdown = -1;
            return;
        }
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        if (civilization2.getCities().isEmpty()) {
            return;
        }
        this.seedGlobalQuestCountdown();
        this.seedIndividualQuestsCountdowns();
        this.decrementQuestCountdowns();
        this.handleGlobalQuests();
        this.handleIndividualQuests();
        this.tryStartNewGlobalQuest();
        this.tryStartNewIndividualQuests();
        this.tryBarbarianInvasion();
        this.tryEndWarWithMajorQuests();
    }

    private final void decrementQuestCountdowns() {
        if (this.globalQuestCountdown > 0) {
            --this.globalQuestCountdown;
        }
        for (Map.Entry entry : ((Map)this.individualQuestCountdown).entrySet()) {
            if (((Number)entry.getValue()).intValue() <= 0) continue;
            entry.setValue(((Number)entry.getValue()).intValue() - 1);
        }
    }

    private final void seedGlobalQuestCountdown() {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (civilization.getGameInfo().getTurns() < 30) {
            return;
        }
        if (this.globalQuestCountdown != -1) {
            return;
        }
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        int countdown = civilization2.getGameInfo().getTurns() == 30 ? Random.Default.nextInt(20) : 40 + Random.Default.nextInt(25);
        float f = countdown;
        Civilization civilization3 = this.civ;
        if (civilization3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization3 = null;
        }
        this.globalQuestCountdown = (int)(f * civilization3.getGameInfo().getSpeed().getModifier());
    }

    private final void seedIndividualQuestsCountdowns() {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (civilization.getGameInfo().getTurns() < 30) {
            return;
        }
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        List<Civilization> majorCivs = civilization2.getGameInfo().getAliveMajorCivs();
        for (Civilization majorCiv : majorCivs) {
            if (this.individualQuestCountdown.containsKey(majorCiv.getCivID())) {
                Integer n = this.individualQuestCountdown.get(majorCiv.getCivID());
                int n2 = -1;
                if (n == null || n != n2) continue;
            }
            this.seedIndividualQuestsCountdown(majorCiv);
        }
    }

    private final void seedIndividualQuestsCountdown(Civilization challenger) {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        int countdown = civilization.getGameInfo().getTurns() == 30 ? Random.Default.nextInt(20) : 20 + Random.Default.nextInt(25);
        Map map2 = this.individualQuestCountdown;
        String string = challenger.getCivID();
        float f = countdown;
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        Integer n = (int)(f * civilization2.getGameInfo().getSpeed().getModifier());
        map2.put(string, n);
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final List<Quest> getQuests(Function1<? super Quest, Boolean> predicate) {
        void $this$filterTo$iv$iv;
        Collection<Quest> collection = this.getRuleset().getQuests().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!predicate.invoke((Quest)element$iv$iv).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Readonly
    private final Random getRandom() {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        int n = civilization.getGameInfo().getTurns();
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        return RandomKt.Random(n + civilization2.getCivID().hashCode());
    }

    /*
     * WARNING - void declaration
     */
    private final void tryStartNewGlobalQuest() {
        Sequence<Civilization> majorCivs;
        List<Quest> assignableQuests;
        int n;
        if (this.globalQuestCountdown != 0) {
            return;
        }
        Iterable $this$count$iv = this.assignedQuests;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                AssignedQuest it = (AssignedQuest)element$iv;
                boolean bl = false;
                if (!it.isGlobal() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        if (n >= 1) {
            return;
        }
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (!((Collection)(assignableQuests = this.getQuests(arg_0 -> QuestManager.tryStartNewGlobalQuest$lambda$3(majorCivs = SequencesKt.filter(civilization.getKnownCivs(), arg_0 -> QuestManager.tryStartNewGlobalQuest$lambda$1(this, arg_0)), this, arg_0)))).isEmpty()) {
            void $this$filterTo$iv$iv;
            Quest quest = CollectionExtensionsKt.randomWeighted(assignableQuests, this.getRandom(), arg_0 -> QuestManager.tryStartNewGlobalQuest$lambda$4(this, arg_0));
            Civilization civilization2 = this.civ;
            if (civilization2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization2 = null;
            }
            Iterable $this$filter$iv = civilization2.getGameInfo().getAliveMajorCivs();
            boolean $i$f$filter = false;
            Iterable bl = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Civilization it = (Civilization)element$iv$iv;
                boolean bl2 = false;
                Civilization civilization3 = this.civ;
                if (civilization3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization3 = null;
                }
                if (!(!it.isAtWarWith(civilization3) && this.isQuestValid(quest, it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List assignees = (List)destination$iv$iv;
            this.assignNewQuest(quest, assignees);
            this.globalQuestCountdown = -1;
        }
    }

    private final void tryStartNewIndividualQuests() {
        for (Map.Entry entry : ((Map)this.individualQuestCountdown).entrySet()) {
            List<Quest> assignableQuests;
            String challengerName = (String)entry.getKey();
            int countdown = ((Number)entry.getValue()).intValue();
            Civilization civilization = this.civ;
            if (civilization == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization = null;
            }
            Civilization challenger = civilization.getGameInfo().getCivilization(challengerName);
            if (countdown != 0) continue;
            Sequence<AssignedQuest> $this$count$iv = this.getAssignedQuestsFor(challenger);
            boolean $i$f$count = false;
            int count$iv = 0;
            Civilization[] civilizationArray = $this$count$iv.iterator();
            while (civilizationArray.hasNext()) {
                AssignedQuest element$iv;
                AssignedQuest it = element$iv = civilizationArray.next();
                boolean bl = false;
                if (!it.isIndividual() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            if (count$iv >= 2 || !(!((Collection)(assignableQuests = this.getQuests(arg_0 -> QuestManager.tryStartNewIndividualQuests$lambda$1(this, challenger, arg_0)))).isEmpty())) continue;
            Quest quest = CollectionExtensionsKt.randomWeighted(assignableQuests, this.getRandom(), arg_0 -> QuestManager.tryStartNewIndividualQuests$lambda$2(this, arg_0));
            civilizationArray = new Civilization[]{challenger};
            ArrayList<Civilization> assignees = CollectionsKt.arrayListOf(civilizationArray);
            this.assignNewQuest(quest, (Iterable<Civilization>)assignees);
        }
    }

    private final void tryBarbarianInvasion() {
        block14: {
            Civilization civilization;
            block13: {
                Civilization civilization2 = this.civ;
                if (civilization2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization2 = null;
                }
                if (civilization2.getTurnsTillCallForBarbHelp() == null) break block13;
                Civilization civilization3 = this.civ;
                if (civilization3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization3 = null;
                }
                Integer n = civilization3.getTurnsTillCallForBarbHelp();
                if (n == null || n != 0) break block14;
            }
            if ((civilization = this.civ) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization = null;
            }
            if (civilization.getCityStateFunctions().getNumThreateningBarbarians() >= 2) {
                Civilization civilization4 = this.civ;
                if (civilization4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization4 = null;
                }
                Iterator<Civilization> iterator2 = SequencesKt.filter(civilization4.getKnownCivs(), arg_0 -> QuestManager.tryBarbarianInvasion$lambda$0(this, arg_0)).iterator();
                while (iterator2.hasNext()) {
                    Civilization otherCiv = iterator2.next();
                    StringBuilder stringBuilder = new StringBuilder().append('[');
                    Civilization civilization5 = this.civ;
                    if (civilization5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("civ");
                        civilization5 = null;
                    }
                    String string = stringBuilder.append(civilization5.getCivName()).append("] is being invaded by Barbarians! Destroy Barbarians near their territory to earn Influence.").toString();
                    Civilization civilization6 = this.civ;
                    if (civilization6 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("civ");
                        civilization6 = null;
                    }
                    City city = Civilization.getCapital$default(civilization6, false, 1, null);
                    Intrinsics.checkNotNull(city);
                    HexCoord hexCoord = city.getLocation();
                    String[] stringArray = new String[2];
                    Civilization civilization7 = this.civ;
                    if (civilization7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("civ");
                        civilization7 = null;
                    }
                    stringArray[0] = civilization7.getCivName();
                    stringArray[1] = "OtherIcons/Pillage";
                    otherCiv.addNotification(string, hexCoord, Notification.NotificationCategory.Diplomacy, stringArray);
                }
                Civilization civilization8 = this.civ;
                if (civilization8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization8 = null;
                }
                civilization8.addFlag("TurnsTillCallForBarbHelp", 30);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleGlobalQuests() {
        void $this$mapTo$iv$iv;
        boolean bl;
        AssignedQuest it;
        Iterable $this$filterTo$iv$iv;
        CollectionsKt.removeAll((List)this.assignedQuests, arg_0 -> QuestManager.handleGlobalQuests$lambda$0(this, arg_0));
        Iterable $this$filter$iv = this.assignedQuests;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (AssignedQuest)element$iv$iv;
            bl = false;
            if (!(it.isGlobal() && it.isExpired())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (AssignedQuest)item$iv$iv;
            Collection collection = destination$iv$iv;
            bl = false;
            collection.add(it.getQuestNameInstance());
        }
        List<QuestName> globalQuestsExpired = CollectionsKt.distinct((List)destination$iv$iv);
        for (QuestName globalQuestName : globalQuestsExpired) {
            this.handleGlobalQuest(globalQuestName);
        }
    }

    private final void handleGlobalQuest(QuestName questName) {
        AssignedQuest it;
        WinnersAndLosers winnersAndLosers = new WinnersAndLosers(questName);
        Iterable $this$forEach$iv = winnersAndLosers.getWinners();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AssignedQuest)element$iv;
            boolean bl = false;
            this.giveReward(it);
        }
        $this$forEach$iv = winnersAndLosers.getLosers();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AssignedQuest)element$iv;
            boolean bl = false;
            this.notifyExpired(it, winnersAndLosers.getWinners());
        }
        CollectionsKt.removeAll((List)this.assignedQuests, arg_0 -> QuestManager.handleGlobalQuest$lambda$2(questName, arg_0));
    }

    public final void handleIndividualQuests() {
        CollectionsKt.removeAll((List)this.assignedQuests, arg_0 -> QuestManager.handleIndividualQuests$lambda$0(this, arg_0));
    }

    private final boolean handleIndividualQuest(AssignedQuest assignedQuest) {
        Civilization assignee = assignedQuest.getAssigneeCiv();
        if (!this.canAssignAQuestTo(assignee)) {
            return true;
        }
        if (this.isComplete(assignedQuest)) {
            this.giveReward(assignedQuest);
            return true;
        }
        if (this.isObsolete(assignedQuest)) {
            QuestManager.notifyExpired$default(this, assignedQuest, null, 2, null);
            return true;
        }
        if (assignedQuest.isExpired()) {
            QuestManager.notifyExpired$default(this, assignedQuest, null, 2, null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final void assignNewQuest(Quest quest, Iterable<Civilization> assignees) {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        int turn = civilization.getGameInfo().getTurns();
        Iterator<Civilization> iterator2 = assignees.iterator();
        while (iterator2.hasNext()) {
            void var8_8;
            Civilization civilization2;
            Civilization assignee = iterator2.next();
            String data1 = "";
            String data2 = "";
            Civilization civilization3 = this.civ;
            if (civilization3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization3 = null;
            }
            List<DiplomacyAction> list2 = CollectionsKt.listOf(new DiplomacyAction(civilization3, false, 2, null));
            switch (WhenMappings.$EnumSwitchMapping$0[quest.getQuestNameInstance().ordinal()]) {
                case 1: {
                    Tile camp;
                    Intrinsics.checkNotNull(this.getBarbarianEncampmentForQuest());
                    data1 = String.valueOf(camp.getPosition().getX());
                    data2 = String.valueOf(camp.getPosition().getY());
                    NotificationAction[] notificationActionArray = new NotificationAction[]{new LocationAction(camp.getPosition()), CollectionsKt.first(list2)};
                    List<NotificationAction> list3 = CollectionsKt.listOf(notificationActionArray);
                    break;
                }
                case 2: {
                    TileResource tileResource = this.getResourceForQuest(assignee);
                    Intrinsics.checkNotNull(tileResource);
                    data1 = tileResource.getName();
                    break;
                }
                case 3: {
                    Building building = this.getWonderToBuildForQuest(assignee);
                    Intrinsics.checkNotNull(building);
                    data1 = building.getName();
                    break;
                }
                case 4: {
                    BaseUnit baseUnit = this.getGreatPersonForQuest(assignee);
                    Intrinsics.checkNotNull(baseUnit);
                    data1 = baseUnit.getName();
                    break;
                }
                case 5: {
                    Civilization civilization4 = this.getCivilizationToFindForQuest(assignee);
                    Intrinsics.checkNotNull(civilization4);
                    data1 = civilization4.getCivID();
                    break;
                }
                case 6: {
                    String string = this.getNaturalWonderToFindForQuest(assignee);
                    Intrinsics.checkNotNull(string);
                    data1 = string;
                    break;
                }
                case 7: {
                    Civilization civilization5 = this.getCityStateTarget(assignee);
                    Intrinsics.checkNotNull(civilization5);
                    data1 = civilization5.getCivID();
                    break;
                }
                case 8: {
                    Civilization civilization6 = this.getCityStateTarget(assignee);
                    Intrinsics.checkNotNull(civilization6);
                    data1 = civilization6.getCivID();
                    break;
                }
                case 9: {
                    String string = this.getMostRecentBully();
                    Intrinsics.checkNotNull(string);
                    data1 = string;
                    break;
                }
                case 10: {
                    String string = this.getMostRecentBully();
                    Intrinsics.checkNotNull(string);
                    data1 = string;
                    break;
                }
                case 11: {
                    String string = this.getMostRecentBully();
                    Intrinsics.checkNotNull(string);
                    data1 = string;
                    break;
                }
                case 12: {
                    Object element$iv;
                    Religion it;
                    void $this$first$iv;
                    Civilization civilization7 = this.civ;
                    if (civilization7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("civ");
                        civilization7 = null;
                    }
                    Collection<Religion> collection = civilization7.getGameInfo().getReligions().values();
                    Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                    Iterable iterable = collection;
                    boolean $i$f$first = false;
                    Iterator iterator3 = $this$first$iv.iterator();
                    do {
                        if (!iterator3.hasNext()) {
                            throw new NoSuchElementException("Collection contains no element matching the predicate.");
                        }
                        element$iv = iterator3.next();
                        it = (Religion)element$iv;
                        boolean bl = false;
                    } while (!(Intrinsics.areEqual(it.getFoundingCiv(), assignee) && it.isMajorReligion()));
                    Object t = element$iv;
                    Intrinsics.checkNotNullExpressionValue(t, "first(...)");
                    Religion playerReligion = (Religion)t;
                    data1 = playerReligion.getReligionDisplayName();
                    data2 = playerReligion.getName();
                    break;
                }
                case 13: {
                    data1 = String.valueOf(assignee.getTotalCultureForContests());
                    break;
                }
                case 14: {
                    data1 = String.valueOf(assignee.getTotalFaithForContests());
                    break;
                }
                case 15: {
                    data1 = String.valueOf(assignee.getTech().getNumberOfTechsResearched());
                    break;
                }
                case 16: {
                    data1 = CollectionsKt.first(TranslationsKt.getPlaceholderParameters(quest.getDescription()));
                    break;
                }
            }
            if ((civilization2 = this.civ) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization2 = null;
            }
            GameInfo gameInfo = civilization2.getGameInfo();
            Civilization civilization8 = this.civ;
            if (civilization8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization8 = null;
            }
            AssignedQuest newQuest = new AssignedQuest(gameInfo, quest, civilization8, assignee, turn, data1, data2);
            this.assignedQuests.add(newQuest);
            if (quest.isIndividual()) {
                ((Map)this.individualQuestCountdown).put(assignee.getCivID(), -1);
            }
            StringBuilder stringBuilder = new StringBuilder().append('[');
            Civilization civilization9 = this.civ;
            if (civilization9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization9 = null;
            }
            String string = stringBuilder.append(civilization9.getCivName()).append("] assigned you a new quest: [").append(quest.getName()).append("].").toString();
            Iterable iterable = (Iterable)var8_8;
            String[] stringArray = new String[2];
            Civilization civilization10 = this.civ;
            if (civilization10 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization10 = null;
            }
            stringArray[0] = civilization10.getCivName();
            stringArray[1] = "OtherIcons/Quest";
            assignee.addNotification(string, iterable, Notification.NotificationCategory.Diplomacy, stringArray);
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    private final boolean canAssignAQuestTo(Civilization challenger) {
        if (challenger.isDefeated()) return false;
        if (!challenger.isMajorCiv()) return false;
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (!civilization.knows(challenger)) return false;
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        if (civilization2.isAtWarWith(challenger)) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Readonly
    private final boolean isQuestValid(Quest quest, Civilization challenger) {
        block42: {
            if (!this.canAssignAQuestTo(challenger)) {
                return false;
            }
            $this$any$iv = this.getAssignedQuestsOfName(quest.getQuestNameInstance());
            $i$f$any = false;
            var5_5 = $this$any$iv.iterator();
            while (var5_5.hasNext()) {
                it = element$iv = var5_5.next();
                $i$a$-any-QuestManager$isQuestValid$1 = false;
                if (!Intrinsics.areEqual(it.getAssigneeCiv(), challenger)) continue;
                v0 = true;
                break block42;
            }
            v0 = false;
        }
        if (v0) {
            return false;
        }
        if (quest.isIndividual()) {
            v1 = this.civ;
            if (v1 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                v1 = null;
            }
            v2 = v1.getDiplomacyManager(challenger);
            Intrinsics.checkNotNull(v2);
            if (v2.hasFlag(DiplomacyFlags.Bullied)) {
                return false;
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$0[quest.getQuestNameInstance().ordinal()]) {
            case 1: {
                if (this.getBarbarianEncampmentForQuest() != null) {
                    v3 = true;
                    break;
                }
                v3 = false;
                break;
            }
            case 17: {
                v3 = this.isRouteQuestValid(challenger);
                break;
            }
            case 2: {
                if (this.getResourceForQuest(challenger) != null) {
                    v3 = true;
                    break;
                }
                v3 = false;
                break;
            }
            case 3: {
                if (this.getWonderToBuildForQuest(challenger) != null) {
                    v3 = true;
                    break;
                }
                v3 = false;
                break;
            }
            case 4: {
                if (this.getGreatPersonForQuest(challenger) != null) {
                    v3 = true;
                    break;
                }
                v3 = false;
                break;
            }
            case 5: {
                if (this.getCivilizationToFindForQuest(challenger) != null) {
                    v3 = true;
                    break;
                }
                v3 = false;
                break;
            }
            case 6: {
                if (this.getNaturalWonderToFindForQuest(challenger) != null) {
                    v3 = true;
                    break;
                }
                v3 = false;
                break;
            }
            case 9: {
                if (this.getMostRecentBully() != null) {
                    v4 = this.civ;
                    if (v4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("civ");
                        v4 = null;
                    }
                    if (!v4.getCityStateFunctions().getProtectorCivs().contains(challenger)) {
                        v3 = true;
                        break;
                    }
                }
                v3 = false;
                break;
            }
            case 10: {
                if (this.getMostRecentBully() != null) {
                    v3 = true;
                    break;
                }
                v3 = false;
                break;
            }
            case 11: {
                v3 = this.isDenounceCivQuestValid(challenger, this.getMostRecentBully());
                break;
            }
            case 12: {
                v5 = this.civ;
                if (v5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    v5 = null;
                }
                v6 = v5.getGameInfo().getReligions().values();
                Intrinsics.checkNotNullExpressionValue(v6, "<get-values>(...)");
                $this$firstOrNull$iv = v6;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (Religion)element$iv;
                    $i$a$-firstOrNull-QuestManager$isQuestValid$playerReligion$1 = false;
                    if (!(Intrinsics.areEqual(it.getFoundingCiv(), challenger) != false && it.isMajorReligion() != false)) continue;
                    v7 = element$iv;
                    ** GOTO lbl101
                }
                v7 = null;
lbl101:
                // 2 sources

                v8 = v7;
                v9 = playerReligion = v8 != null ? v8.getName() : null;
                if (playerReligion != null) {
                    v10 = this.civ;
                    if (v10 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("civ");
                        v10 = null;
                    }
                    v11 = Civilization.getCapital$default(v10, false, 1, null);
                    Intrinsics.checkNotNull(v11);
                    v12 = v11.getReligion().getMajorityReligion();
                    if (!Intrinsics.areEqual(v12 != null ? v12.getName() : null, playerReligion)) {
                        v3 = true;
                        break;
                    }
                }
                v3 = false;
                break;
            }
            case 7: {
                if (this.getCityStateTarget(challenger) != null) {
                    v13 = this.civ;
                    if (v13 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("civ");
                        v13 = null;
                    }
                    if (v13.getCityStatePersonality() != CityStatePersonality.Friendly) {
                        v3 = true;
                        break;
                    }
                }
                v3 = false;
                break;
            }
            case 8: {
                if (this.getCityStateTarget(challenger) != null) {
                    v3 = true;
                    break;
                }
                v3 = false;
                break;
            }
            case 14: {
                v14 = this.civ;
                if (v14 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    v14 = null;
                }
                v3 = v14.getGameInfo().isReligionEnabled();
                break;
            }
            default: {
                v3 = true;
            }
        }
        return v3;
    }

    @Readonly
    private final boolean isRouteQuestValid(Civilization challenger) {
        boolean bl;
        block8: {
            if (challenger.getCities().isEmpty()) {
                return false;
            }
            Civilization civilization = this.civ;
            if (civilization == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization = null;
            }
            City city = Civilization.getCapital$default(civilization, false, 1, null);
            Intrinsics.checkNotNull(city);
            if (challenger.isCapitalConnectedToCity(city)) {
                return false;
            }
            Civilization civilization2 = this.civ;
            if (civilization2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization2 = null;
            }
            City city2 = Civilization.getCapital$default(civilization2, false, 1, null);
            if (city2 == null) {
                return false;
            }
            City capital = city2;
            Tile capitalTile = capital.getCenterTile();
            Iterable $this$any$iv = challenger.getCities();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    City it = (City)element$iv;
                    boolean bl2 = false;
                    if (!(it.getCenterTile().getContinent() == capitalTile.getContinent() && it.getCenterTile().aerialDistanceTo(capitalTile) <= 7)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    private final boolean isDenounceCivQuestValid(Civilization challenger, String mostRecentBully) {
        if (mostRecentBully == null) return false;
        if (!challenger.knows(mostRecentBully)) return false;
        DiplomacyManager diplomacyManager = challenger.getDiplomacyManager(mostRecentBully);
        Intrinsics.checkNotNull(diplomacyManager);
        if (diplomacyManager.hasFlag(DiplomacyFlags.Denunciation)) return false;
        DiplomacyManager diplomacyManager2 = challenger.getDiplomacyManager(mostRecentBully);
        Intrinsics.checkNotNull(diplomacyManager2);
        if (diplomacyManager2.getDiplomaticStatus() == DiplomaticStatus.War) return false;
        if (challenger.getPlayerType() != PlayerType.Human) return true;
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (civilization.getGameInfo().getCivilization(mostRecentBully).getPlayerType() == PlayerType.Human) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final boolean isComplete(AssignedQuest assignedQuest) {
        boolean bl;
        Civilization assignee = assignedQuest.getAssigneeCiv();
        block0 : switch (WhenMappings.$EnumSwitchMapping$0[assignedQuest.getQuestNameInstance().ordinal()]) {
            case 17: {
                Civilization civilization = this.civ;
                if (civilization == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization = null;
                }
                City city = Civilization.getCapital$default(civilization, false, 1, null);
                Intrinsics.checkNotNull(city);
                bl = assignee.isCapitalConnectedToCity(city);
                break;
            }
            case 2: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = assignee.getDetailedCivResources();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ResourceSupplyList.ResourceSupply resourceSupply = (ResourceSupplyList.ResourceSupply)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getResource());
                }
                bl = CollectionsKt.contains((List)destination$iv$iv, this.getRuleset().getTileResources().get(assignedQuest.getData1()));
                break;
            }
            case 3: {
                Iterable $this$any$iv = assignee.getCities();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                    break;
                }
                for (Object element$iv : $this$any$iv) {
                    City it = (City)element$iv;
                    boolean bl3 = false;
                    if (!it.getCityConstructions().isBuilt(assignedQuest.getData1())) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 4: {
                Sequence<MapUnit> $this$any$iv = assignee.getUnits().getCivGreatPeople();
                boolean $i$f$any = false;
                Iterator<MapUnit> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    MapUnit element$iv;
                    MapUnit it = element$iv = iterator2.next();
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual(it.getBaseUnit().getReplacedUnit(this.getRuleset()).getName(), assignedQuest.getData1())) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 5: {
                Civilization civilization = this.civ;
                if (civilization == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization = null;
                }
                bl = assignee.hasMetCivTerritory(civilization.getGameInfo().getCivilization(assignedQuest.getData1()));
                break;
            }
            case 6: {
                bl = assignee.getNaturalWonders().contains(assignedQuest.getData1());
                break;
            }
            case 9: {
                Civilization civilization = this.civ;
                if (civilization == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization = null;
                }
                bl = civilization.getCityStateFunctions().getProtectorCivs().contains(assignee);
                break;
            }
            case 11: {
                DiplomacyManager diplomacyManager = assignee.getDiplomacyManager(assignedQuest.getData1());
                Intrinsics.checkNotNull(diplomacyManager);
                bl = diplomacyManager.hasFlag(DiplomacyFlags.Denunciation);
                break;
            }
            case 12: {
                Civilization civilization = this.civ;
                if (civilization == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization = null;
                }
                City city = Civilization.getCapital$default(civilization, false, 1, null);
                Intrinsics.checkNotNull(city);
                Religion religion = city.getReligion().getMajorityReligion();
                Civilization civilization2 = this.civ;
                if (civilization2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization2 = null;
                }
                bl = Intrinsics.areEqual(religion, civilization2.getGameInfo().getReligions().get(assignedQuest.getData2()));
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Readonly
    private final boolean isObsolete(AssignedQuest assignedQuest) {
        boolean bl;
        Civilization assignee = assignedQuest.getAssigneeCiv();
        block0 : switch (WhenMappings.$EnumSwitchMapping$0[assignedQuest.getQuestNameInstance().ordinal()]) {
            case 1: {
                Civilization civilization = this.civ;
                if (civilization == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization = null;
                }
                if (!Intrinsics.areEqual(civilization.getGameInfo().getTileMap().get(Integer.parseInt(assignedQuest.getData1()), Integer.parseInt(assignedQuest.getData2())).getImprovement(), "Barbarian encampment")) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                Civilization civilization = this.civ;
                if (civilization == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization = null;
                }
                Sequence<City> $this$any$iv = civilization.getGameInfo().getCities();
                boolean $i$f$any = false;
                Iterator<City> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    City element$iv;
                    City it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual(it.getCiv(), assignee) && it.getCityConstructions().isBuilt(assignedQuest.getData1()))) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 5: {
                Civilization civilization = this.civ;
                if (civilization == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization = null;
                }
                bl = civilization.getGameInfo().getCivilization(assignedQuest.getData1()).isDefeated();
                break;
            }
            case 7: {
                Civilization civilization = this.civ;
                if (civilization == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization = null;
                }
                bl = civilization.getGameInfo().getCivilization(assignedQuest.getData1()).isDefeated();
                break;
            }
            case 8: {
                Civilization civilization = this.civ;
                if (civilization == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization = null;
                }
                bl = civilization.getGameInfo().getCivilization(assignedQuest.getData1()).isDefeated();
                break;
            }
            case 11: {
                Civilization civilization = this.civ;
                if (civilization == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization = null;
                }
                bl = civilization.getGameInfo().getCivilization(assignedQuest.getData1()).isDefeated();
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private final void giveReward(AssignedQuest assignedQuest) {
        Civilization civilization;
        float rewardInfluence = assignedQuest.getInfluence();
        Civilization assignee = assignedQuest.getAssigneeCiv();
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        DiplomacyManager diplomacyManager = civilization2.getDiplomacyManager(assignee);
        Intrinsics.checkNotNull(diplomacyManager);
        diplomacyManager.addInfluence(rewardInfluence);
        if (rewardInfluence > 0.0f) {
            StringBuilder stringBuilder = new StringBuilder().append('[');
            Civilization civilization3 = this.civ;
            if (civilization3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization3 = null;
            }
            String string = stringBuilder.append(civilization3.getCivName()).append("] rewarded you with [").append((int)rewardInfluence).append("] influence for completing the [").append(assignedQuest.getQuestName()).append("] quest.").toString();
            Civilization civilization4 = this.civ;
            if (civilization4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization4 = null;
            }
            City city = Civilization.getCapital$default(civilization4, false, 1, null);
            Intrinsics.checkNotNull(city);
            HexCoord hexCoord = city.getLocation();
            String[] stringArray = new String[2];
            Civilization civilization5 = this.civ;
            if (civilization5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization5 = null;
            }
            stringArray[0] = civilization5.getCivName();
            stringArray[1] = "OtherIcons/Quest";
            assignee.addNotification(string, hexCoord, Notification.NotificationCategory.Diplomacy, stringArray);
        }
        if ((civilization = this.civ) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        for (City city : civilization.getCities()) {
            CityStats.update$default(city.getCityStats(), null, false, false, null, false, 31, null);
        }
    }

    private final void notifyExpired(AssignedQuest assignedQuest, List<AssignedQuest> winners) {
        Civilization assignee = assignedQuest.getAssigneeCiv();
        if (winners.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder().append('[');
            Civilization civilization = this.civ;
            if (civilization == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization = null;
            }
            String string = stringBuilder.append(civilization.getCivName()).append("] no longer needs your help with the [").append(assignedQuest.getQuestName()).append("] quest.").toString();
            Civilization civilization2 = this.civ;
            if (civilization2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization2 = null;
            }
            City city = Civilization.getCapital$default(civilization2, false, 1, null);
            Intrinsics.checkNotNull(city);
            HexCoord hexCoord = city.getLocation();
            String[] stringArray = new String[2];
            Civilization civilization3 = this.civ;
            if (civilization3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization3 = null;
            }
            stringArray[0] = civilization3.getCivName();
            stringArray[1] = "OtherIcons/Quest";
            assignee.addNotification(string, hexCoord, Notification.NotificationCategory.Diplomacy, stringArray);
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("The [").append(assignedQuest.getQuestName()).append("] quest for [");
            Civilization civilization = this.civ;
            if (civilization == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization = null;
            }
            String string = stringBuilder.append(civilization.getCivName()).append("] has ended. It was won by [").append(CollectionsKt.joinToString$default(winners, null, null, null, 0, null, QuestManager::notifyExpired$lambda$0, 31, null)).append("].").toString();
            Civilization civilization4 = this.civ;
            if (civilization4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization4 = null;
            }
            City city = Civilization.getCapital$default(civilization4, false, 1, null);
            Intrinsics.checkNotNull(city);
            HexCoord hexCoord = city.getLocation();
            String[] stringArray = new String[2];
            Civilization civilization5 = this.civ;
            if (civilization5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization5 = null;
            }
            stringArray[0] = civilization5.getCivName();
            stringArray[1] = "OtherIcons/Quest";
            assignee.addNotification(string, hexCoord, Notification.NotificationCategory.Diplomacy, stringArray);
        }
    }

    static /* synthetic */ void notifyExpired$default(QuestManager questManager, AssignedQuest assignedQuest, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        questManager.notifyExpired(assignedQuest, list2);
    }

    @Readonly
    private final int getScoreForQuest(AssignedQuest assignedQuest) {
        int n;
        Civilization assignee = assignedQuest.getAssigneeCiv();
        switch (WhenMappings.$EnumSwitchMapping$0[assignedQuest.getQuestNameInstance().ordinal()]) {
            case 13: {
                n = assignee.getTotalCultureForContests() - Integer.parseInt(assignedQuest.getData1());
                break;
            }
            case 14: {
                n = assignee.getTotalFaithForContests() - Integer.parseInt(assignedQuest.getData1());
                break;
            }
            case 15: {
                n = assignee.getTech().getNumberOfTechsResearched() - Integer.parseInt(assignedQuest.getData1());
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @Readonly
    @NotNull
    public final String getScoreStringForGlobalQuest(@NotNull AssignedQuest inquiringAssignedQuest) {
        String string;
        Intrinsics.checkNotNullParameter(inquiringAssignedQuest, "inquiringAssignedQuest");
        Civilization civilization = inquiringAssignedQuest.getAssignerCiv();
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        if (!Intrinsics.areEqual(civilization, civilization2)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!inquiringAssignedQuest.isGlobal()) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[inquiringAssignedQuest.getQuestNameInstance().ordinal()]) {
            case 13: {
                string = "Culture";
                break;
            }
            case 14: {
                string = "Faith";
                break;
            }
            case 15: {
                string = "Technologies";
                break;
            }
            default: {
                return "";
            }
        }
        String scoreDescriptor = string;
        WinnersAndLosers evaluation = new WinnersAndLosers(inquiringAssignedQuest.getQuestNameInstance());
        if (evaluation.getWinners().isEmpty()) {
            return "";
        }
        String listOfLeadersAsTranslatedString = CollectionsKt.joinToString$default(evaluation.getWinners(), ", ", null, null, 0, null, QuestManager::getScoreStringForGlobalQuest$lambda$0, 30, null);
        String leadersString = QuestManager.getScoreStringForGlobalQuest$getScoreString(scoreDescriptor, listOfLeadersAsTranslatedString, evaluation.getMaxScore());
        if (evaluation.getWinners().contains(inquiringAssignedQuest)) {
            return "Current leader(s): [" + leadersString + ']';
        }
        String yourScoreString = QuestManager.getScoreStringForGlobalQuest$getScoreString(scoreDescriptor, inquiringAssignedQuest.getAssignee(), this.getScoreForQuest(inquiringAssignedQuest));
        return "Current leader(s): [" + leadersString + "], you: [" + yourScoreString + ']';
    }

    public final void barbarianCampCleared(@NotNull Civilization civInfo, @NotNull Vector2 location) {
        Intrinsics.checkNotNullParameter(civInfo, "civInfo");
        Intrinsics.checkNotNullParameter(location, "location");
        Sequence<AssignedQuest> matchingQuests = SequencesKt.filter(this.getAssignedQuestsOfName(QuestName.ClearBarbarianCamp), arg_0 -> QuestManager.barbarianCampCleared$lambda$0(location, arg_0));
        AssignedQuest winningQuest = SequencesKt.firstOrNull(SequencesKt.filter(matchingQuests, arg_0 -> QuestManager.barbarianCampCleared$lambda$1(civInfo, arg_0)));
        if (winningQuest != null) {
            this.giveReward(winningQuest);
        }
        CollectionsKt.removeAll((Collection)this.assignedQuests, matchingQuests);
    }

    public final void cityStateConquered(@NotNull Civilization cityState, @NotNull Civilization attacker) {
        Intrinsics.checkNotNullParameter(cityState, "cityState");
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Sequence<AssignedQuest> matchingQuests = SequencesKt.filter(this.getAssignedQuestsOfName(QuestName.ConquerCityState), arg_0 -> QuestManager.cityStateConquered$lambda$0(cityState, attacker, arg_0));
        Iterator<AssignedQuest> iterator2 = matchingQuests.iterator();
        while (iterator2.hasNext()) {
            AssignedQuest quest = iterator2.next();
            this.giveReward(quest);
        }
        CollectionsKt.removeAll((Collection)this.assignedQuests, matchingQuests);
    }

    public final void cityStateBullied(@NotNull Civilization cityState, @NotNull Civilization bully) {
        Intrinsics.checkNotNullParameter(cityState, "cityState");
        Intrinsics.checkNotNullParameter(bully, "bully");
        Sequence<AssignedQuest> matchingQuests = SequencesKt.filter(this.getAssignedQuestsOfName(QuestName.BullyCityState), arg_0 -> QuestManager.cityStateBullied$lambda$0(cityState, bully, arg_0));
        Iterator<AssignedQuest> iterator2 = matchingQuests.iterator();
        while (iterator2.hasNext()) {
            AssignedQuest quest = iterator2.next();
            this.giveReward(quest);
        }
        CollectionsKt.removeAll((Collection)this.assignedQuests, matchingQuests);
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (!Intrinsics.areEqual(civilization, cityState)) {
            return;
        }
        List<AssignedQuest> revokedQuests = SequencesKt.toList(SequencesKt.filter(this.getAssignedQuestsFor(bully), QuestManager::cityStateBullied$lambda$1));
        this.assignedQuests.removeAll((Collection)revokedQuests);
        if (revokedQuests.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append('[');
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        String string = stringBuilder.append(civilization2.getCivName()).append("] cancelled the quests they had given you because you demanded tribute from them.").toString();
        Civilization civilization3 = this.civ;
        if (civilization3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization3 = null;
        }
        NotificationAction notificationAction = new DiplomacyAction(civilization3, false, 2, null);
        String[] stringArray = new String[2];
        Civilization civilization4 = this.civ;
        if (civilization4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization4 = null;
        }
        stringArray[0] = civilization4.getCivName();
        stringArray[1] = "OtherIcons/Quest";
        bully.addNotification(string, notificationAction, Notification.NotificationCategory.Diplomacy, stringArray);
    }

    public final void wasAttackedBy(@NotNull Civilization attacker) {
        Intrinsics.checkNotNullParameter(attacker, "attacker");
        Sequence<MapUnit> $this$count$iv = attacker.getUnits().getCivUnits();
        boolean $i$f$count = false;
        int count$iv = 0;
        Iterator<MapUnit> iterator2 = $this$count$iv.iterator();
        while (iterator2.hasNext()) {
            MapUnit element$iv;
            MapUnit it = element$iv = iterator2.next();
            boolean bl = false;
            if (!(!it.isCivilian()) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        int totalMilitaryUnits = count$iv;
        int unitsToKill = RangesKt.coerceAtMost(totalMilitaryUnits / 4, 3);
        ((Map)this.unitsToKillForCiv).put(attacker.getCivID(), unitsToKill);
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        City city = civilization.getCapital(true);
        HexCoord location = city != null ? city.getLocation() : null;
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        Iterator<Civilization> iterator3 = civilization2.getKnownCivs().iterator();
        while (iterator3.hasNext()) {
            Civilization thirdCiv = iterator3.next();
            if (!thirdCiv.isMajorCiv() || thirdCiv.isDefeated()) continue;
            Civilization civilization3 = this.civ;
            if (civilization3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization3 = null;
            }
            if (thirdCiv.isAtWarWith(civilization3)) continue;
            HexCoord hexCoord = location;
            this.notifyAskForAssistance(thirdCiv, attacker.getCivID(), unitsToKill, hexCoord != null ? hexCoord.toHexCoord() : null);
        }
    }

    private final void notifyAskForAssistance(Civilization assignee, String attackerName, int unitsToKill, HexCoord location) {
        if (Intrinsics.areEqual(attackerName, assignee.getCivID())) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append('[');
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        String message = stringBuilder.append(civilization.getCivName()).append("] is being attacked by [").append(attackerName).append("]! Kill [").append(unitsToKill).append("] of the attacker's military units and they will be immensely grateful.").toString();
        Object[] objectArray = new HexCoord[]{location};
        Sequence<LocationAction> sequence = LocationAction.Companion.invoke((HexCoord[])objectArray);
        objectArray = new String[2];
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        objectArray[0] = civilization2.getCivName();
        objectArray[1] = "OtherIcons/Quest";
        assignee.addNotification(message, sequence, Notification.NotificationCategory.Diplomacy, (String[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public final void militaryUnitKilledBy(@NotNull Civilization killer2, @NotNull Civilization killed) {
        Object object;
        void $this$getOrPut$iv;
        block14: {
            block13: {
                Intrinsics.checkNotNullParameter(killer2, "killer");
                Intrinsics.checkNotNullParameter(killed, "killed");
                if (!this.isWarWithMajorActive(killed)) {
                    return;
                }
                Civilization civilization = this.civ;
                if (civilization == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization = null;
                }
                if (!civilization.knows(killer2)) break block13;
                Civilization civilization2 = this.civ;
                if (civilization2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization2 = null;
                }
                if (!civilization2.isAtWarWith(killer2)) break block14;
            }
            return;
        }
        Map map2 = this.unitsKilledFromCiv;
        String key$iv = killed.getCivID();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            HashMap answer$iv = new HashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        HashMap unitsKilledFromCivEntry = (HashMap)object;
        Integer n = (Integer)unitsKilledFromCivEntry.get(killer2.getCivID());
        int updatedKillCount = 1 + (n != null ? n : 0);
        ((Map)unitsKilledFromCivEntry).put(killer2.getCivID(), updatedKillCount);
        Integer n2 = this.unitsToKillForCiv.get(killed.getCivID());
        Intrinsics.checkNotNull(n2);
        if (updatedKillCount >= ((Number)n2).intValue()) {
            StringBuilder stringBuilder = new StringBuilder().append('[');
            Civilization civilization = this.civ;
            if (civilization == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization = null;
            }
            String string = stringBuilder.append(civilization.getCivName()).append("] is deeply grateful for your assistance in the war against [").append(killed.getCivName()).append("]!").toString();
            Civilization civilization3 = this.civ;
            if (civilization3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization3 = null;
            }
            NotificationAction notificationAction = new DiplomacyAction(civilization3, false, 2, null);
            String[] stringArray = new String[2];
            Civilization civilization4 = this.civ;
            if (civilization4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization4 = null;
            }
            stringArray[0] = civilization4.getCivName();
            stringArray[1] = "OtherIcons/Quest";
            killer2.addNotification(string, notificationAction, Notification.NotificationCategory.Diplomacy, stringArray);
            Civilization civilization5 = this.civ;
            if (civilization5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization5 = null;
            }
            DiplomacyManager diplomacyManager = civilization5.getDiplomacyManager(killer2);
            Intrinsics.checkNotNull(diplomacyManager);
            diplomacyManager.addInfluence(100.0f);
            this.endWarWithMajorQuest(killed);
        }
    }

    public final void justMet(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        if (this.unitsToKillForCiv.isEmpty()) {
            return;
        }
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        City city = civilization.getCapital(true);
        HexCoord location = city != null ? city.getLocation() : null;
        for (Map.Entry entry : ((Map)this.unitsToKillForCiv).entrySet()) {
            String attackerName = (String)entry.getKey();
            int unitsToKill = ((Number)entry.getValue()).intValue();
            HexCoord hexCoord = location;
            this.notifyAskForAssistance(otherCiv, attackerName, unitsToKill, hexCoord != null ? hexCoord.toHexCoord() : null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void tryEndWarWithMajorQuests() {
        void $this$mapTo$iv$iv;
        Set<String> set = this.unitsToKillForCiv.keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Civilization civilization = this.civ;
            if (civilization == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization = null;
            }
            GameInfo gameInfo = civilization.getGameInfo();
            Intrinsics.checkNotNull(it);
            collection.add(gameInfo.getCivilization((String)it));
        }
        for (Civilization attacker : (List)destination$iv$iv) {
            Civilization civilization = this.civ;
            if (civilization == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization = null;
            }
            if (!civilization.isDefeated() && !attacker.isDefeated()) {
                Civilization civilization2 = this.civ;
                if (civilization2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    civilization2 = null;
                }
                if (civilization2.isAtWarWith(attacker)) continue;
            }
            this.endWarWithMajorQuest(attacker);
        }
    }

    private final void endWarWithMajorQuest(Civilization attacker) {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        Iterator<Civilization> iterator2 = SequencesKt.filterNot(civilization.getKnownCivs(), arg_0 -> QuestManager.endWarWithMajorQuest$lambda$0(attacker, this, arg_0)).iterator();
        while (iterator2.hasNext()) {
            Civilization thirdCiv = iterator2.next();
            if (this.unitsKilledSoFar(attacker, thirdCiv) >= this.unitsToKill(attacker)) continue;
            StringBuilder stringBuilder = new StringBuilder().append('[');
            Civilization civilization2 = this.civ;
            if (civilization2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization2 = null;
            }
            String string = stringBuilder.append(civilization2.getCivName()).append("] no longer needs your assistance against [").append(attacker.getCivName()).append("].").toString();
            Civilization civilization3 = this.civ;
            if (civilization3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization3 = null;
            }
            NotificationAction notificationAction = new DiplomacyAction(civilization3, false, 2, null);
            String[] stringArray = new String[2];
            Civilization civilization4 = this.civ;
            if (civilization4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization4 = null;
            }
            stringArray[0] = civilization4.getCivName();
            stringArray[1] = "OtherIcons/Quest";
            thirdCiv.addNotification(string, notificationAction, Notification.NotificationCategory.Diplomacy, stringArray);
        }
        this.unitsToKillForCiv.remove(attacker.getCivID());
        this.unitsKilledFromCiv.remove(attacker.getCivID());
    }

    @Readonly
    public final boolean isWarWithMajorActive(@NotNull Civilization target) {
        Intrinsics.checkNotNullParameter(target, "target");
        return this.unitsToKillForCiv.containsKey(target.getCivID());
    }

    @Readonly
    public final int unitsToKill(@NotNull Civilization target) {
        Intrinsics.checkNotNullParameter(target, "target");
        Integer n = this.unitsToKillForCiv.get(target.getCivID());
        return n != null ? n : 0;
    }

    @Readonly
    public final int unitsKilledSoFar(@NotNull Civilization target, @NotNull Civilization viewingCiv) {
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        HashMap<String, Integer> hashMap = this.unitsKilledFromCiv.get(target.getCivID());
        if (hashMap == null) {
            return 0;
        }
        HashMap<String, Integer> killMap = hashMap;
        Integer n = killMap.get(viewingCiv.getCivID());
        return n != null ? n : 0;
    }

    public final void receivedGoldGift(@NotNull Civilization donorCiv) {
        Intrinsics.checkNotNullParameter(donorCiv, "donorCiv");
        Sequence<AssignedQuest> matchingQuests = SequencesKt.filter(this.getAssignedQuestsOfName(QuestName.GiveGold), arg_0 -> QuestManager.receivedGoldGift$lambda$0(donorCiv, arg_0));
        Iterator<AssignedQuest> iterator2 = matchingQuests.iterator();
        while (iterator2.hasNext()) {
            AssignedQuest quest = iterator2.next();
            this.giveReward(quest);
        }
        CollectionsKt.removeAll((Collection)this.assignedQuests, matchingQuests);
    }

    @Readonly
    private final float getQuestWeight(String questName) {
        Float traitWeight;
        Float personalityWeight;
        float weight = 1.0f;
        Quest quest = this.getRuleset().getQuests().get(questName);
        if (quest == null) {
            return 0.0f;
        }
        Quest quest2 = quest;
        HashMap<String, Float> hashMap = quest2.getWeightForCityStateType();
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if ((personalityWeight = hashMap.get(civilization.getCityStatePersonality().name())) != null) {
            weight *= personalityWeight.floatValue();
        }
        HashMap<String, Float> hashMap2 = quest2.getWeightForCityStateType();
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        if ((traitWeight = hashMap2.get(civilization2.getCityStateType().getName())) != null) {
            weight *= traitWeight.floatValue();
        }
        return weight;
    }

    @Readonly
    private final Tile getBarbarianEncampmentForQuest() {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        City city = Civilization.getCapital$default(civilization, false, 1, null);
        Intrinsics.checkNotNull(city);
        List<Tile> encampments = SequencesKt.toList(SequencesKt.filter(city.getCenterTile().getTilesInDistance(8), QuestManager::getBarbarianEncampmentForQuest$lambda$0));
        return (Tile)CollectionsKt.randomOrNull((Collection)encampments, this.getRandom());
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final TileResource getResourceForQuest(Civilization challenger) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        Iterable $this$map$iv = civilization.getDetailedCivResources();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            ResourceSupplyList.ResourceSupply resourceSupply = (ResourceSupplyList.ResourceSupply)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getResource());
        }
        List ownedByCityStateResources = (List)destination$iv$iv;
        Iterable $this$map$iv2 = challenger.getDetailedCivResources();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceSupplyList.ResourceSupply bl = (ResourceSupplyList.ResourceSupply)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getResource());
        }
        List ownedByMajorResources = (List)destination$iv$iv2;
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        Sequence<TileResource> resourcesOnMap = SequencesKt.distinct(SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)civilization2.getGameInfo().getTileMap().getValues()), QuestManager::getResourceForQuest$lambda$2));
        Sequence<TileResource> viewableResourcesForChallenger = SequencesKt.filter(resourcesOnMap, arg_0 -> QuestManager.getResourceForQuest$lambda$3(challenger, arg_0));
        List<TileResource> notOwnedResources = SequencesKt.toList(SequencesKt.filter(viewableResourcesForChallenger, arg_0 -> QuestManager.getResourceForQuest$lambda$4(ownedByCityStateResources, ownedByMajorResources, arg_0)));
        return (TileResource)CollectionsKt.randomOrNull((Collection)notOwnedResources, this.getRandom());
    }

    /*
     * Unable to fully structure code
     */
    @Readonly
    private final Building getWonderToBuildForQuest(Civilization challenger) {
        v0 = this.getRuleset().getBuildings().values();
        Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var5_4 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block6: {
                building = (Building)element$iv$iv;
                $i$a$-filter-QuestManager$getWonderToBuildForQuest$wonders$1 = false;
                if (!building.isWonder()) ** GOTO lbl-1000
                v1 = challenger.getTech();
                Intrinsics.checkNotNull(building);
                if (!v1.isResearched(building)) ** GOTO lbl-1000
                v2 = this.civ;
                if (v2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    v2 = null;
                }
                if (building.isUnavailableBySettings(v2.getGameInfo()) || building.getUniqueTo() != null) ** GOTO lbl-1000
                v3 = this.civ;
                if (v3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("civ");
                    v3 = null;
                }
                $this$none$iv = v3.getGameInfo().getCities();
                $i$f$none = false;
                var14_13 = $this$none$iv.iterator();
                while (var14_13.hasNext()) {
                    it = element$iv = var14_13.next();
                    $i$a$-none-QuestManager$getWonderToBuildForQuest$wonders$1$1 = false;
                    if (!(it.getCityConstructions().isBuilt(building.getName()) != false || QuestManager.getWonderToBuildForQuest$isMoreThanAQuarterDone(it, building.getName()) != false)) continue;
                    v4 = false;
                    break block6;
                }
                v4 = true;
            }
            if (v4) {
                v5 = true;
            } else lbl-1000:
            // 4 sources

            {
                v5 = false;
            }
            if (!v5) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        wonders = (List)destination$iv$iv;
        return (Building)CollectionsKt.randomOrNull(wonders, this.getRandom());
    }

    @Readonly
    private final String getNaturalWonderToFindForQuest(Civilization challenger) {
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        Iterable iterable = CollectionsKt.subtract((Iterable)civilization.getGameInfo().getTileMap().getNaturalWonders(), (Iterable)challenger.getNaturalWonders());
        Civilization civilization2 = this.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        return (String)CollectionsKt.randomOrNull(CollectionsKt.subtract(iterable, (Iterable)civilization2.getNaturalWonders()), this.getRandom());
    }

    /*
     * Unable to fully structure code
     */
    @Readonly
    private final BaseUnit getGreatPersonForQuest(Civilization challenger) {
        ruleset = this.getRuleset();
        v0 = challenger.getUnits().getCivGreatPeople();
        v1 = this.civ;
        if (v1 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            v1 = null;
        }
        existingGreatPeople = SequencesKt.toSet(SequencesKt.map(SequencesKt.plus(v0, v1.getUnits().getCivGreatPeople()), (Function1<MapUnit, BaseUnit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getGreatPersonForQuest$lambda$0(com.unciv.models.ruleset.Ruleset com.unciv.logic.map.mapunit.MapUnit ), (Lcom/unciv/logic/map/mapunit/MapUnit;)Lcom/unciv/models/ruleset/unit/BaseUnit;)((Ruleset)ruleset)));
        var5_4 = challenger.getGreatPeople().getGreatPeople();
        $i$f$map = false;
        var7_6 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var12_11 = (BaseUnit)item$iv$iv;
            var14_13 = destination$iv$iv;
            $i$a$-map-QuestManager$getGreatPersonForQuest$greatPeople$1 = false;
            var14_13.add(it.getReplacedUnit(ruleset));
        }
        $this$map$iv = CollectionsKt.distinct((List)destination$iv$iv);
        $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (BaseUnit)element$iv$iv;
            $i$a$-filterNot-QuestManager$getGreatPersonForQuest$greatPeople$2 = false;
            if (existingGreatPeople.contains(it)) ** GOTO lbl-1000
            v2 = this.civ;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                v2 = null;
            }
            if (it.isUnavailableBySettings(v2.getGameInfo())) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            if (v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        greatPeople = CollectionsKt.toList((List)destination$iv$iv);
        return (BaseUnit)CollectionsKt.randomOrNull((Collection)greatPeople, this.getRandom());
    }

    @Readonly
    private final Civilization getCivilizationToFindForQuest(Civilization challenger) {
        List<Civilization> civilizationsToFind = SequencesKt.toList(SequencesKt.filter(challenger.getKnownCivs(), arg_0 -> QuestManager.getCivilizationToFindForQuest$lambda$0(challenger, arg_0)));
        return (Civilization)CollectionsKt.randomOrNull((Collection)civilizationsToFind, this.getRandom());
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final Civilization getCityStateTarget(Civilization challenger) {
        Object v2;
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        Iterable $this$mapNotNull$iv = civilization.getGameInfo().getAliveCityStates();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Proximity it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Civilization it = (Civilization)element$iv$iv;
            boolean bl2 = false;
            Civilization civilization2 = this.civ;
            if (civilization2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("civ");
                civilization2 = null;
            }
            if (civilization2.getProximity().get(it.getCivID()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Proximity it = (Proximity)element$iv$iv;
            boolean bl = false;
            if (!(it != Proximity.None)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = minElem$iv;
            } else {
                Proximity it = (Proximity)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.ordinal();
                do {
                    Object e$iv = iterator$iv.next();
                    Proximity it2 = (Proximity)e$iv;
                    $i$a$-minByOrNull-QuestManager$getCityStateTarget$closestProximity$3 = false;
                    int v$iv = it2.ordinal();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = minElem$iv;
            }
        }
        Proximity closestProximity = v2;
        if (closestProximity == null || closestProximity == Proximity.Distant) {
            return null;
        }
        Civilization civilization3 = this.civ;
        if (civilization3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization3 = null;
        }
        Sequence<Civilization> validTargets = SequencesKt.filter(civilization3.getKnownCivs(), arg_0 -> QuestManager.getCityStateTarget$lambda$3(challenger, this, closestProximity, arg_0));
        return (Civilization)CollectionsKt.randomOrNull((Collection)SequencesKt.toList(validTargets), this.getRandom());
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final String getMostRecentBully() {
        Object v2;
        void $this$filterTo$iv$iv;
        Civilization civilization = this.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        Collection<DiplomacyManager> collection = civilization.getDiplomacy().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DiplomacyManager it = (DiplomacyManager)element$iv$iv;
            boolean bl = false;
            if (!it.hasFlag(DiplomacyFlags.Bullied)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List bullies = (List)destination$iv$iv;
        Iterable $this$maxByOrNull$iv = bullies;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                DiplomacyManager it = (DiplomacyManager)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getFlag(DiplomacyFlags.Bullied);
                do {
                    Object e$iv = iterator$iv.next();
                    DiplomacyManager it2 = (DiplomacyManager)e$iv;
                    $i$a$-maxByOrNull-QuestManager$getMostRecentBully$1 = false;
                    int v$iv = it2.getFlag(DiplomacyFlags.Bullied);
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        DiplomacyManager diplomacyManager = v2;
        return diplomacyManager != null ? diplomacyManager.getOtherCivName() : null;
    }

    private static final boolean getAssignedQuestsFor$lambda$0(String $civName, AssignedQuest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getAssignee(), $civName);
    }

    private static final boolean getAssignedQuestsFor$lambda$1(Civilization $civ, AssignedQuest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getAssigneeCiv(), $civ);
    }

    private static final boolean getAssignedQuestsOfName$lambda$0(QuestName $questName, AssignedQuest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getQuestNameInstance() == $questName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean tryStartNewGlobalQuest$lambda$1(QuestManager this$0, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (!it.isMajorCiv()) return false;
        Civilization civilization = this$0.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (it.isAtWarWith(civilization)) return false;
        return true;
    }

    @Readonly
    private static final boolean tryStartNewGlobalQuest$isAssignable(Quest $this$tryStartNewGlobalQuest_u24isAssignable, Sequence<Civilization> majorCivs, QuestManager this$0) {
        Sequence<Civilization> $this$count$iv = majorCivs;
        boolean $i$f$count = false;
        int count$iv = 0;
        Iterator<Civilization> iterator2 = $this$count$iv.iterator();
        while (iterator2.hasNext()) {
            Civilization element$iv;
            Civilization civ = element$iv = iterator2.next();
            boolean bl = false;
            if (!this$0.isQuestValid($this$tryStartNewGlobalQuest_u24isAssignable, civ) || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        return count$iv >= $this$tryStartNewGlobalQuest_u24isAssignable.getMinimumCivs();
    }

    private static final boolean tryStartNewGlobalQuest$lambda$3(Sequence $majorCivs, QuestManager this$0, Quest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isGlobal() && QuestManager.tryStartNewGlobalQuest$isAssignable(it, $majorCivs, this$0);
    }

    private static final float tryStartNewGlobalQuest$lambda$4(QuestManager this$0, Quest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.getQuestWeight(it.getName());
    }

    private static final boolean tryStartNewIndividualQuests$lambda$1(QuestManager this$0, Civilization $challenger, Quest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isIndividual() && this$0.isQuestValid(it, $challenger);
    }

    private static final float tryStartNewIndividualQuests$lambda$2(QuestManager this$0, Quest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.getQuestWeight(it.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean tryBarbarianInvasion$lambda$0(QuestManager this$0, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (!it.isMajorCiv()) return false;
        if (!it.isAlive()) return false;
        Civilization civilization = this$0.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (it.isAtWarWith(civilization)) return false;
        Civilization civilization2 = this$0.civ;
        if (civilization2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization2 = null;
        }
        if (it.getProximity(civilization2).compareTo((Enum)Proximity.Far) > 0) return false;
        return true;
    }

    private static final boolean handleGlobalQuests$lambda$0(QuestManager this$0, AssignedQuest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isGlobal() && !this$0.canAssignAQuestTo(it.getAssigneeCiv());
    }

    private static final boolean handleGlobalQuest$lambda$2(QuestName $questName, AssignedQuest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getQuestNameInstance() == $questName;
    }

    private static final boolean handleIndividualQuests$lambda$0(QuestManager this$0, AssignedQuest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isIndividual() && this$0.handleIndividualQuest(it);
    }

    private static final CharSequence notifyExpired$lambda$0(AssignedQuest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return '{' + it.getAssigneeCiv().getCivName() + '}';
    }

    private static final CharSequence getScoreStringForGlobalQuest$lambda$0(AssignedQuest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TranslationsKt.tr$default(it.getAssigneeCiv().getCivName(), false, false, 3, null);
    }

    @Pure
    private static final String getScoreStringForGlobalQuest$getScoreString(String scoreDescriptor, String name, int score) {
        return TranslationsKt.tr$default('[' + name + "] with [" + score + "] [" + scoreDescriptor + ']', false, false, 3, null);
    }

    private static final boolean barbarianCampCleared$lambda$0(Vector2 $location, AssignedQuest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Integer.parseInt(it.getData1()) == (int)$location.x && Integer.parseInt(it.getData2()) == (int)$location.y;
    }

    private static final boolean barbarianCampCleared$lambda$1(Civilization $civInfo, AssignedQuest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getAssigneeCiv(), $civInfo);
    }

    private static final boolean cityStateConquered$lambda$0(Civilization $cityState, Civilization $attacker, AssignedQuest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getData1(), $cityState.getCivID()) && Intrinsics.areEqual(it.getAssigneeCiv(), $attacker);
    }

    private static final boolean cityStateBullied$lambda$0(Civilization $cityState, Civilization $bully, AssignedQuest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getData1(), $cityState.getCivID()) && Intrinsics.areEqual(it.getAssigneeCiv(), $bully);
    }

    private static final boolean cityStateBullied$lambda$1(AssignedQuest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isIndividual() || it.getQuestNameInstance() == QuestName.Invest;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean endWarWithMajorQuest$lambda$0(Civilization $attacker, QuestManager this$0, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.isDefeated()) return true;
        if (Intrinsics.areEqual(it, $attacker)) return true;
        Civilization civilization = this$0.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (!it.isAtWarWith(civilization)) return false;
        return true;
    }

    private static final boolean receivedGoldGift$lambda$0(Civilization $donorCiv, AssignedQuest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getAssigneeCiv(), $donorCiv);
    }

    private static final boolean getBarbarianEncampmentForQuest$lambda$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getImprovement(), "Barbarian encampment");
    }

    private static final TileResource getResourceForQuest$lambda$2(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTileResource();
    }

    private static final boolean getResourceForQuest$lambda$3(Civilization $challenger, TileResource it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $challenger.canSeeResource(it);
    }

    private static final boolean getResourceForQuest$lambda$4(List $ownedByCityStateResources, List $ownedByMajorResources, TileResource it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getResourceType() != ResourceType.Bonus && !$ownedByCityStateResources.contains(it) && !$ownedByMajorResources.contains(it);
    }

    @Readonly
    private static final boolean getWonderToBuildForQuest$isMoreThanAQuarterDone(City city, String buildingName) {
        return city.getCityConstructions().getWorkDone(buildingName) * 3 > CityConstructions.getRemainingWork$default(city.getCityConstructions(), buildingName, false, 2, null);
    }

    private static final BaseUnit getGreatPersonForQuest$lambda$0(Ruleset $ruleset, MapUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getBaseUnit().getReplacedUnit($ruleset);
    }

    private static final boolean getCivilizationToFindForQuest$lambda$0(Civilization $challenger, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isAlive() && it.isMajorCiv() && !$challenger.hasMetCivTerritory(it);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getCityStateTarget$lambda$3(Civilization $challenger, QuestManager this$0, Proximity $closestProximity, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (!it.isCityState()) return false;
        if (!$challenger.knows(it)) return false;
        Civilization civilization = this$0.civ;
        if (civilization == null) {
            Intrinsics.throwUninitializedPropertyAccessException("civ");
            civilization = null;
        }
        if (civilization.getProximity().get(it.getCivID()) != $closestProximity) return false;
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/unciv/logic/civilization/managers/QuestManager$Companion;", "", "<init>", "()V", "UNSET", "", "GLOBAL_QUEST_FIRST_POSSIBLE_TURN", "INDIVIDUAL_QUEST_FIRST_POSSIBLE_TURN", "GLOBAL_QUEST_FIRST_POSSIBLE_TURN_RAND", "INDIVIDUAL_QUEST_FIRST_POSSIBLE_TURN_RAND", "GLOBAL_QUEST_MIN_TURNS_BETWEEN", "INDIVIDUAL_QUEST_MIN_TURNS_BETWEEN", "GLOBAL_QUEST_RAND_TURNS_BETWEEN", "INDIVIDUAL_QUEST_RAND_TURNS_BETWEEN", "GLOBAL_QUEST_MAX_ACTIVE", "INDIVIDUAL_QUEST_MAX_ACTIVE", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QuestName.values().length];
            try {
                nArray[QuestName.ClearBarbarianCamp.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.ConnectResource.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.ConstructWonder.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.GreatPerson.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.FindPlayer.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.FindNaturalWonder.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.ConquerCityState.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.BullyCityState.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.PledgeToProtect.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.GiveGold.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.DenounceCiv.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.SpreadReligion.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.ContestCulture.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.ContestFaith.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.ContestTech.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.Invest.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.Route.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/unciv/logic/civilization/managers/QuestManager$WinnersAndLosers;", "", "questName", "Lcom/unciv/models/ruleset/QuestName;", "<init>", "(Lcom/unciv/logic/civilization/managers/QuestManager;Lcom/unciv/models/ruleset/QuestName;)V", "winners", "", "Lcom/unciv/logic/civilization/managers/AssignedQuest;", "getWinners", "()Ljava/util/List;", "losers", "getLosers", "value", "", "maxScore", "getMaxScore", "()I", "core"})
    public final class WinnersAndLosers {
        @NotNull
        private final List<AssignedQuest> winners;
        @NotNull
        private final List<AssignedQuest> losers;
        private int maxScore;

        public WinnersAndLosers(QuestName questName) {
            Intrinsics.checkNotNullParameter((Object)questName, "questName");
            this.winners = new ArrayList();
            this.losers = new ArrayList();
            this.maxScore = -1;
            Quest quest = QuestManager.this.getRuleset().getQuests().get(questName.getValue());
            Intrinsics.checkNotNull(quest);
            if (!quest.isGlobal()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Iterator iterator2 = QuestManager.this.getAssignedQuestsOfName(questName).iterator();
            while (iterator2.hasNext()) {
                AssignedQuest quest2 = (AssignedQuest)iterator2.next();
                int qScore = QuestManager.this.getScoreForQuest(quest2);
                if (qScore <= 0) continue;
                if (qScore < this.maxScore) {
                    this.losers.add(quest2);
                    continue;
                }
                if (qScore == this.maxScore) {
                    this.winners.add(quest2);
                    continue;
                }
                this.losers.addAll((Collection<AssignedQuest>)this.winners);
                this.winners.clear();
                this.winners.add(quest2);
                this.maxScore = qScore;
            }
        }

        @NotNull
        public final List<AssignedQuest> getWinners() {
            return this.winners;
        }

        @NotNull
        public final List<AssignedQuest> getLosers() {
            return this.losers;
        }

        public final int getMaxScore() {
            return this.maxScore;
        }
    }
}

