/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization.managers;

import com.badlogic.gdx.math.Vector2;
import com.unciv.GUI;
import com.unciv.logic.GameInfo;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.HexMathKt;
import com.unciv.models.ruleset.Quest;
import com.unciv.models.ruleset.QuestName;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.screens.worldscreen.worldmap.WorldMapHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001BG\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fB\t\b\u0016\u00a2\u0006\u0004\b\u000e\u0010\u0010BE\b\u0016\u0012\b\b\u0002\u0010\u0011\u001a\u00020\f\u0012\b\b\u0002\u0010\u0006\u001a\u00020\f\u0012\b\b\u0002\u0010\b\u001a\u00020\f\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u0012J\u0006\u0010'\u001a\u00020\u0000J!\u0010(\u001a\u00020)2\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0000\u00a2\u0006\u0002\b*J\b\u0010+\u001a\u00020,H\u0007J\b\u0010-\u001a\u00020,H\u0007J\b\u0010.\u001a\u00020,H\u0007J\b\u0010/\u001a\u00020,H\u0007J\b\u00100\u001a\u00020\nH\u0007J\b\u00101\u001a\u00020\nH\u0007J\b\u00102\u001a\u000203H\u0007J\b\u00104\u001a\u00020\fH\u0007J\u0006\u00105\u001a\u00020)R\u0011\u0010\u0011\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014R\u001e\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014R\u001e\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082.\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u00066"}, d2={"Lcom/unciv/logic/civilization/managers/AssignedQuest;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "gameInfo", "Lcom/unciv/logic/GameInfo;", "quest", "Lcom/unciv/models/ruleset/Quest;", "assigner", "Lcom/unciv/logic/civilization/Civilization;", "assignee", "assignedOnTurn", "", "data1", "", "data2", "<init>", "(Lcom/unciv/logic/GameInfo;Lcom/unciv/models/ruleset/Quest;Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/logic/civilization/Civilization;ILjava/lang/String;Ljava/lang/String;)V", "()V", "questName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getQuestName", "()Ljava/lang/String;", "getAssignedOnTurn", "()I", "getData1", "getData2", "getAssigner", "value", "assignerCiv", "getAssignerCiv", "()Lcom/unciv/logic/civilization/Civilization;", "getAssignee", "assigneeCiv", "getAssigneeCiv", "getQuest", "()Lcom/unciv/models/ruleset/Quest;", "questNameInstance", "Lcom/unciv/models/ruleset/QuestName;", "getQuestNameInstance", "()Lcom/unciv/models/ruleset/QuestName;", "clone", "setTransients", "", "setTransients$core", "isIndividual", "", "isGlobal", "doesExpire", "isExpired", "getDuration", "getRemainingTurns", "getInfluence", "", "getDescription", "onClickAction", "core"})
public final class AssignedQuest
implements IsPartOfGameInfoSerialization {
    @NotNull
    private final String questName;
    private final int assignedOnTurn;
    @NotNull
    private final String data1;
    @NotNull
    private final String data2;
    @NotNull
    private final String assigner;
    private transient Civilization assignerCiv;
    @NotNull
    private final String assignee;
    private transient Civilization assigneeCiv;
    private transient GameInfo gameInfo;
    private transient Quest quest;

    @NotNull
    public final String getQuestName() {
        return this.questName;
    }

    public final int getAssignedOnTurn() {
        return this.assignedOnTurn;
    }

    @NotNull
    public final String getData1() {
        return this.data1;
    }

    @NotNull
    public final String getData2() {
        return this.data2;
    }

    public AssignedQuest(@NotNull GameInfo gameInfo, @NotNull Quest quest, @NotNull Civilization assigner, @NotNull Civilization assignee, int assignedOnTurn, @NotNull String data1, @NotNull String data2) {
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        Intrinsics.checkNotNullParameter(quest, "quest");
        Intrinsics.checkNotNullParameter(assigner, "assigner");
        Intrinsics.checkNotNullParameter(assignee, "assignee");
        Intrinsics.checkNotNullParameter(data1, "data1");
        Intrinsics.checkNotNullParameter(data2, "data2");
        this.gameInfo = gameInfo;
        this.quest = quest;
        this.questName = quest.getName();
        this.assignedOnTurn = assignedOnTurn;
        this.data1 = data1;
        this.data2 = data2;
        this.assigner = assigner.getCivID();
        this.assignerCiv = assigner;
        this.assignee = assignee.getCivID();
        this.assigneeCiv = assignee;
    }

    public /* synthetic */ AssignedQuest(GameInfo gameInfo, Quest quest, Civilization civilization, Civilization civilization2, int n, String string, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        if ((n2 & 0x20) != 0) {
            string = "";
        }
        if ((n2 & 0x40) != 0) {
            string2 = "";
        }
        this(gameInfo, quest, civilization, civilization2, n, string, string2);
    }

    public AssignedQuest() {
        this("", "", "", 0, "", "");
    }

    public AssignedQuest(@NotNull String questName, @NotNull String assigner, @NotNull String assignee, int assignedOnTurn, @NotNull String data1, @NotNull String data2) {
        Intrinsics.checkNotNullParameter(questName, "questName");
        Intrinsics.checkNotNullParameter(assigner, "assigner");
        Intrinsics.checkNotNullParameter(assignee, "assignee");
        Intrinsics.checkNotNullParameter(data1, "data1");
        Intrinsics.checkNotNullParameter(data2, "data2");
        this.questName = questName;
        this.assignedOnTurn = assignedOnTurn;
        this.data1 = data1;
        this.data2 = data2;
        this.assigner = assigner;
        this.assignee = assignee;
    }

    public /* synthetic */ AssignedQuest(String string, String string2, String string3, int n, String string4, String string5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "";
        }
        if ((n2 & 2) != 0) {
            string2 = "";
        }
        if ((n2 & 4) != 0) {
            string3 = "";
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        if ((n2 & 0x10) != 0) {
            string4 = "";
        }
        if ((n2 & 0x20) != 0) {
            string5 = "";
        }
        this(string, string2, string3, n, string4, string5);
    }

    @NotNull
    public final String getAssigner() {
        return this.assigner;
    }

    @NotNull
    public final Civilization getAssignerCiv() {
        Civilization civilization = this.assignerCiv;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("assignerCiv");
        return null;
    }

    @NotNull
    public final String getAssignee() {
        return this.assignee;
    }

    @NotNull
    public final Civilization getAssigneeCiv() {
        Civilization civilization = this.assigneeCiv;
        if (civilization != null) {
            return civilization;
        }
        Intrinsics.throwUninitializedPropertyAccessException("assigneeCiv");
        return null;
    }

    @NotNull
    public final Quest getQuest() {
        Quest quest = this.quest;
        if (quest != null) {
            return quest;
        }
        Intrinsics.throwUninitializedPropertyAccessException("quest");
        return null;
    }

    @NotNull
    public final QuestName getQuestNameInstance() {
        return this.getQuest().getQuestNameInstance();
    }

    @NotNull
    public final AssignedQuest clone() {
        return new AssignedQuest(this.questName, this.assigner, this.assignee, this.assignedOnTurn, this.data1, this.data2);
    }

    public final void setTransients$core(@NotNull GameInfo gameInfo, @Nullable Quest quest) {
        Intrinsics.checkNotNullParameter(gameInfo, "gameInfo");
        this.gameInfo = gameInfo;
        if (quest != null) {
            this.quest = quest;
        } else if (this.quest == null) {
            Quest quest2 = gameInfo.getRuleset().getQuests().get(this.questName);
            Intrinsics.checkNotNull(quest2);
            this.quest = quest2;
        }
        if (this.assignerCiv == null) {
            this.assignerCiv = gameInfo.getCivilization(this.assigner);
        }
        if (this.assigneeCiv == null) {
            this.assigneeCiv = gameInfo.getCivilization(this.assignee);
        }
    }

    public static /* synthetic */ void setTransients$core$default(AssignedQuest assignedQuest, GameInfo gameInfo, Quest quest, int n, Object object) {
        if ((n & 2) != 0) {
            quest = null;
        }
        assignedQuest.setTransients$core(gameInfo, quest);
    }

    @Readonly
    public final boolean isIndividual() {
        return !this.isGlobal();
    }

    @Readonly
    public final boolean isGlobal() {
        return this.getQuest().isGlobal();
    }

    @Readonly
    public final boolean doesExpire() {
        return this.getQuest().getDuration() > 0;
    }

    @Readonly
    public final boolean isExpired() {
        return this.doesExpire() && this.getRemainingTurns() == 0;
    }

    @Readonly
    public final int getDuration() {
        GameInfo gameInfo = this.gameInfo;
        if (gameInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gameInfo");
            gameInfo = null;
        }
        return (int)(gameInfo.getSpeed().getModifier() * (float)this.getQuest().getDuration());
    }

    @Readonly
    public final int getRemainingTurns() {
        int n = this.assignedOnTurn + this.getDuration();
        GameInfo gameInfo = this.gameInfo;
        if (gameInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gameInfo");
            gameInfo = null;
        }
        return RangesKt.coerceAtLeast(n - gameInfo.getTurns(), 0);
    }

    @Readonly
    public final float getInfluence() {
        return this.getQuest().getInfluence();
    }

    @Readonly
    @NotNull
    public final String getDescription() {
        String[] stringArray = new String[]{this.data1};
        return TranslationsKt.fillPlaceholders(this.getQuest().getDescription(), stringArray);
    }

    public final void onClickAction() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.getQuestNameInstance().ordinal()]) {
            case 1: {
                GUI.INSTANCE.resetToWorldScreen();
                WorldMapHolder.setCenterPosition$default(GUI.INSTANCE.getMap(), HexMathKt.toHexCoord(new Vector2(Float.parseFloat(this.data1), Float.parseFloat(this.data2))), false, false, null, 10, null);
                break;
            }
            case 2: {
                GUI.INSTANCE.resetToWorldScreen();
                WorldMapHolder worldMapHolder = GUI.INSTANCE.getMap();
                City city = Civilization.getCapital$default(this.getAssignerCiv(), false, 1, null);
                Intrinsics.checkNotNull(city);
                WorldMapHolder.setCenterPosition$default(worldMapHolder, city.getLocation().toHexCoord(), false, false, null, 10, null);
                break;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QuestName.values().length];
            try {
                nArray[QuestName.ClearBarbarianCamp.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QuestName.Route.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

